/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.context;

import java.io.Serializable;
import java.net.URI;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.ext.proxy.api.EntityType;

public class EntityUUID
implements Serializable {
    private static final long serialVersionUID = 4855025769803086495L;
    private final URI entitySetURI;
    private final Object key;
    private final int tempKey;
    private Class<?> type;

    public EntityUUID(URI entitySetURI, Class<?> type) {
        this(entitySetURI, type, null);
    }

    public EntityUUID(URI entitySetURI, Class<?> type, Object key) {
        this.entitySetURI = entitySetURI;
        this.key = key;
        this.tempKey = (int)(Math.random() * 1000000.0);
        if (type == null || !Serializable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Invalid Entity type class: " + type);
        }
        if (this.type == null) {
            for (Class<?> clazz : ClassUtils.hierarchy(type, ClassUtils.Interfaces.INCLUDE)) {
                if (!ArrayUtils.contains(clazz.getInterfaces(), EntityType.class)) continue;
                this.type = clazz;
            }
        }
    }

    public URI getEntitySetURI() {
        return this.entitySetURI;
    }

    public Object getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        return this.key == null ? EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]) : EqualsBuilder.reflectionEquals((Object)this, obj, "tempKey");
    }

    public int hashCode() {
        return this.key == null ? HashCodeBuilder.reflectionHashCode((Object)this, new String[0]) : HashCodeBuilder.reflectionHashCode((Object)this, "tempKey");
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SIMPLE_STYLE);
    }
}

