/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.util.HashMap;
import java.util.HashSet;
import javax.validation.ConstraintValidator;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.bval.BeanValidationContext;
import org.apache.bval.jsr303.ConstraintValidation;
import org.apache.bval.jsr303.ConstraintValidationListener;
import org.apache.bval.jsr303.ConstraintValidatorIdentity;
import org.apache.bval.jsr303.GraphBeanIdentity;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.groups.Groups;
import org.apache.bval.jsr303.resolver.CachingTraversableResolver;
import org.apache.bval.jsr303.util.NodeImpl;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupValidationContextImpl<T>
extends BeanValidationContext<ConstraintValidationListener<T>>
implements GroupValidationContext<T>,
MessageInterpolator.Context {
    private final MessageInterpolator messageResolver;
    private final PathImpl path;
    private final MetaBean rootMetaBean;
    private Groups groups;
    private Group currentGroup;
    private Class<?> currentOwner;
    private HashSet<ConstraintValidatorIdentity> validatedConstraints = new HashSet();
    private ConstraintValidation<?> constraintValidation;
    private final TraversableResolver traversableResolver;

    public GroupValidationContextImpl(ConstraintValidationListener<T> listener, MessageInterpolator aMessageResolver, TraversableResolver traversableResolver, MetaBean rootMetaBean) {
        super(listener, new HashMap());
        this.messageResolver = aMessageResolver;
        this.traversableResolver = CachingTraversableResolver.cacheFor(traversableResolver);
        this.rootMetaBean = rootMetaBean;
        this.path = PathImpl.create(null);
    }

    @Override
    public void setCurrentIndex(Integer index) {
        this.path.getLeafNode().setIndex(index);
    }

    @Override
    public void setCurrentKey(Object key) {
        this.path.getLeafNode().setKey(key);
    }

    @Override
    public void moveDown(MetaProperty prop, AccessStrategy access) {
        this.path.addNode(new NodeImpl(prop.getName()));
        super.moveDown(prop, access);
    }

    @Override
    public void moveUp(Object bean, MetaBean metaBean) {
        this.path.removeLeafNode();
        super.moveUp(bean, metaBean);
    }

    @Override
    public boolean collectValidated() {
        GraphBeanIdentity gbi = new GraphBeanIdentity(this.getBean(), this.getCurrentGroup().getGroup(), this.getCurrentOwner());
        HashSet<PathImpl> validatedPathsForGBI = (HashSet<PathImpl>)this.validatedObjects.get(gbi);
        if (validatedPathsForGBI == null) {
            validatedPathsForGBI = new HashSet<PathImpl>();
            this.validatedObjects.put(gbi, validatedPathsForGBI);
        }
        for (PathImpl validatedPath : validatedPathsForGBI) {
            if (!this.path.isSubPathOf(validatedPath)) continue;
            return false;
        }
        validatedPathsForGBI.add(PathImpl.copy(this.path));
        return true;
    }

    @Override
    public boolean collectValidated(ConstraintValidator<?, ?> constraint) {
        ConstraintValidatorIdentity cvi = new ConstraintValidatorIdentity(this.getBean(), this.getPropertyPath(), constraint);
        return this.validatedConstraints.add(cvi);
    }

    public void resetValidatedConstraints() {
        this.validatedConstraints.clear();
    }

    @Override
    public PathImpl getPropertyPath() {
        PathImpl currentPath = PathImpl.copy(this.path);
        if (this.getMetaProperty() != null) {
            currentPath.addNode(new NodeImpl(this.getMetaProperty().getName()));
        }
        return currentPath;
    }

    @Override
    public MetaBean getRootMetaBean() {
        return this.rootMetaBean;
    }

    public void setGroups(Groups groups) {
        this.groups = groups;
    }

    @Override
    public Groups getGroups() {
        return this.groups;
    }

    @Override
    public Group getCurrentGroup() {
        return this.currentGroup;
    }

    @Override
    public void setCurrentGroup(Group currentGroup) {
        this.currentGroup = currentGroup;
    }

    @Override
    public void setConstraintValidation(ConstraintValidation<?> constraint) {
        this.constraintValidation = constraint;
    }

    @Override
    public ConstraintValidation<?> getConstraintValidation() {
        return this.constraintValidation;
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintValidation;
    }

    @Override
    public Object getValidatedValue() {
        if (this.getMetaProperty() != null) {
            return this.getPropertyValue(this.constraintValidation.getAccess());
        }
        return this.getBean();
    }

    @Override
    public MessageInterpolator getMessageResolver() {
        return this.messageResolver;
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    @Override
    public Class<?> getCurrentOwner() {
        return this.currentOwner;
    }

    @Override
    public void setCurrentOwner(Class<?> currentOwner) {
        this.currentOwner = currentOwner;
    }
}

