/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.openjpa.kernel.FillStrategy;

public class ResultShape<T>
implements Serializable {
    private final Class<T> cls;
    private final boolean isPrimitive;
    private boolean isNesting;
    private String alias;
    private final FillStrategy<T> strategy;
    private final List<ResultShape<?>> children;
    private Set<ResultShape<?>> parents;

    public ResultShape(Class<T> cls) {
        this(cls, false);
    }

    public ResultShape(Class<T> cls, boolean primitive) {
        this(cls, cls.isArray() ? new FillStrategy.Array<T>(cls) : new FillStrategy.Assign(), primitive);
        if (cls.isArray() && primitive) {
            throw new IllegalArgumentException(cls.getSimpleName() + " can not be primitive shape");
        }
    }

    public ResultShape(Class<T> cls, FillStrategy<T> strategy) {
        this(cls, strategy, false);
    }

    public ResultShape(Class<T> cls, FillStrategy<T> strategy, boolean primitive) {
        if (cls == null) {
            throw new NullPointerException();
        }
        this.cls = cls;
        this.strategy = strategy;
        this.isPrimitive = primitive;
        this.children = this.isPrimitive ? null : new ArrayList();
    }

    public Class<T> getType() {
        return this.cls;
    }

    public FillStrategy<T> getStrategy() {
        return this.strategy;
    }

    public ResultShape<T> setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<Class<?>> getCompositeTypes() {
        ArrayList result = new ArrayList();
        if (this.isPrimitive() || this.children.isEmpty()) {
            result.add(this.cls);
        } else {
            for (ResultShape<?> child : this.children) {
                result.addAll(child.getCompositeTypes());
            }
        }
        return result;
    }

    public List<Class<?>> getTypes() {
        ArrayList result = new ArrayList();
        if (this.children.isEmpty()) {
            result.add(this.cls);
        } else {
            for (ResultShape<?> child : this.children) {
                result.add(child.getType());
            }
        }
        return result;
    }

    public <X> ResultShape<X> nest(Class<X> cls, FillStrategy strategy, Class<?> ... classes) {
        this.assertNotPrimitive();
        ResultShape<X> child = new ResultShape<X>(cls, strategy, true);
        this.nest(child.add(classes));
        return child;
    }

    public ResultShape<T> nest(ResultShape<?> shape) {
        this.assertNotPrimitive();
        if (shape.isParent(this)) {
            throw new IllegalArgumentException(this + " can not nest recursive " + shape);
        }
        this.children.add(shape);
        super.addParent(this);
        this.isNesting |= !shape.isPrimitive();
        return this;
    }

    private void addParent(ResultShape<?> p) {
        if (this.parents == null) {
            this.parents = new HashSet();
        }
        this.parents.add(p);
    }

    public ResultShape<T> add(Class<?> ... classes) {
        this.assertNotPrimitive();
        for (Class<?> c : classes) {
            this.children.add(new ResultShape(c, true));
        }
        return this;
    }

    public List<ResultShape<?>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isCompound() {
        return !this.isPrimitive;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isNesting() {
        return this.isNesting;
    }

    public boolean isNested() {
        return this.parents != null;
    }

    public boolean isParent(ResultShape<?> p) {
        if (p.getParents().contains(this)) {
            return true;
        }
        if (this.children != null) {
            for (ResultShape<?> child : this.children) {
                if (!child.isParent(p)) continue;
                return true;
            }
        }
        return false;
    }

    void assertNotPrimitive() {
        if (this.isPrimitive) {
            throw new UnsupportedOperationException("Can not add/nest shape to primitive shape " + this);
        }
    }

    public Set<ResultShape<?>> getParents() {
        return this.parents == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(this.parents);
    }

    public int argLength() {
        if (this.isPrimitive() || this.children.isEmpty()) {
            return 1;
        }
        int l = 0;
        for (ResultShape<?> child : this.children) {
            l += child.argLength();
        }
        return l;
    }

    public int length() {
        if (this.isPrimitive() || this.children.isEmpty()) {
            return 1;
        }
        return this.children.size();
    }

    public T pack(Object[] values, Class<?>[] types, String[] aliases) {
        if (values.length < this.argLength()) {
            throw new IndexOutOfBoundsException(values.length + " values are less than " + this.argLength() + " argumenets required to pack " + this);
        }
        Object[] args = new Object[this.length()];
        Class[] argTypes = new Class[this.length()];
        String[] argAliases = new String[this.length()];
        if (this.isPrimitive() || this.children.isEmpty()) {
            args[0] = values[0];
            argTypes[0] = types[0];
            argAliases[0] = aliases[0];
        } else {
            int start = 0;
            int i = 0;
            for (ResultShape<?> rs : this.children) {
                int finish = start + rs.argLength();
                args[i] = rs.pack(this.chop(values, start, finish), this.chop(types, start, finish), this.chop(aliases, start, finish));
                argTypes[i] = rs.getType();
                argAliases[0] = rs.getAlias();
                start = finish;
                ++i;
            }
        }
        return this.strategy.fill(args, argTypes, argAliases);
    }

    <X> X[] chop(X[] values, int start, int finish) {
        Object[] result = (Object[])Array.newInstance(values.getClass().getComponentType(), finish - start);
        System.arraycopy(values, start, result, 0, finish - start);
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.cls.getSimpleName());
        if (this.isPrimitive() || this.children.isEmpty()) {
            return buf.toString();
        }
        int i = 0;
        for (ResultShape<?> child : this.children) {
            buf.append(i++ == 0 ? "{" : ", ");
            buf.append(child);
        }
        if (!this.children.isEmpty()) {
            buf.append("}");
        }
        return buf.toString();
    }
}

