/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ConstantPoolTable {
    private byte[] _bytecode = null;
    private int[] _table = null;
    private int _idx = 0;

    public ConstantPoolTable(byte[] b) {
        this._bytecode = b;
        this._table = new int[ConstantPoolTable.readUnsignedShort(b, 8)];
        this._idx = ConstantPoolTable.parse(b, this._table);
    }

    public ConstantPoolTable(InputStream in) throws IOException {
        this(ConstantPoolTable.toByteArray(in));
    }

    public static int getEndIndex(byte[] b) {
        return ConstantPoolTable.parse(b, null);
    }

    private static int parse(byte[] b, int[] table) {
        int entries = table == null ? ConstantPoolTable.readUnsignedShort(b, 8) : table.length;
        int idx = 10;
        block6: for (int i = 1; i < entries; ++i) {
            if (table != null) {
                table[i] = idx + 1;
            }
            switch (b[idx]) {
                case 1: {
                    idx += 3 + ConstantPoolTable.readUnsignedShort(b, idx + 1);
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    idx += 5;
                    continue block6;
                }
                case 5: 
                case 6: {
                    idx += 9;
                    ++i;
                    continue block6;
                }
                case 15: {
                    idx += 4;
                    continue block6;
                }
                default: {
                    idx += 3;
                }
            }
        }
        return idx;
    }

    public static int readByte(byte[] b, int idx) {
        return b[idx] & 0xFF;
    }

    public static int readUnsignedShort(byte[] b, int idx) {
        return ConstantPoolTable.readByte(b, idx) << 8 | ConstantPoolTable.readByte(b, idx + 1);
    }

    public static int readInt(byte[] b, int idx) {
        return ConstantPoolTable.readByte(b, idx) << 24 | ConstantPoolTable.readByte(b, idx + 1) << 16 | ConstantPoolTable.readByte(b, idx + 2) << 8 | ConstantPoolTable.readByte(b, idx + 3);
    }

    public static long readLong(byte[] b, int idx) {
        return ConstantPoolTable.readInt(b, idx) << 32 | ConstantPoolTable.readInt(b, idx + 4);
    }

    public static String readString(byte[] b, int idx) {
        int len = ConstantPoolTable.readUnsignedShort(b, idx);
        try {
            return new String(b, idx + 2, len, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ClassFormatError(uee.toString());
        }
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((r = in.read(buf)) != -1) {
            bout.write(buf, 0, r);
        }
        return bout.toByteArray();
    }

    public int getEndIndex() {
        return this._idx;
    }

    public int get(int idx) {
        return this._table[idx];
    }

    public int readByte(int idx) {
        return ConstantPoolTable.readByte(this._bytecode, idx);
    }

    public int readUnsignedShort(int idx) {
        return ConstantPoolTable.readUnsignedShort(this._bytecode, idx);
    }

    public int readInt(int idx) {
        return ConstantPoolTable.readInt(this._bytecode, idx);
    }

    public long readLong(int idx) {
        return ConstantPoolTable.readLong(this._bytecode, idx);
    }

    public String readString(int idx) {
        return ConstantPoolTable.readString(this._bytecode, idx);
    }
}

