/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.persistence.pudefaults;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/*
 * An entity which has a @Table annotation which contains a schema name,
 * as such schema in the annotation should take precedence over the
 * persistence-unit-default schema (see pudefaults-orm.xml file).
 */
@Entity
@Table(name = "PUSchemaInTable", schema = "schemaInTableAnnotation")
public class PUSchemaInTableAnnotationEntity implements Serializable {

    private static final long serialVersionUID = -566154189043208199L;

    @Id
    @SequenceGenerator(name = "Seq_4AnnoTableSchema", sequenceName = "SeqName_4AnnoTableSchema")
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "Seq_4AnnoTableSchema")
    @Column(name = "ID")
    private long id;

    public long getId() { return id; }
}
