/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.meta.MetaDataIterator;

public class MetaDataIteratorChain
implements MetaDataIterator {
    private List<MetaDataIterator> _itrs = null;
    private int _cur = -1;
    private MetaDataIterator _itr = null;

    public MetaDataIteratorChain() {
    }

    public MetaDataIteratorChain(MetaDataIterator itr1, MetaDataIterator itr2) {
        this._itrs = new ArrayList<MetaDataIterator>(2);
        this._itrs.add(itr1);
        this._itrs.add(itr2);
    }

    public void addIterator(MetaDataIterator itr) {
        if (this._cur != -1) {
            throw new IllegalStateException();
        }
        if (this._itrs == null) {
            this._itrs = new ArrayList<MetaDataIterator>(4);
        }
        this._itrs.add(itr);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this._itrs == null) {
            return false;
        }
        if (this._cur == -1) {
            this._cur = 0;
        }
        while (this._cur < this._itrs.size()) {
            MetaDataIterator itr = this._itrs.get(this._cur);
            if (itr.hasNext()) {
                this._itr = itr;
                return true;
            }
            ++this._cur;
        }
        this._itr = null;
        return false;
    }

    @Override
    public Object next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._itr.next();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._itr == null) {
            throw new IllegalStateException();
        }
        return this._itr.getInputStream();
    }

    @Override
    public File getFile() throws IOException {
        if (this._itr == null) {
            throw new IllegalStateException();
        }
        return this._itr.getFile();
    }

    @Override
    public void close() {
        if (this._itrs != null) {
            for (MetaDataIterator mdi : this._itrs) {
                mdi.close();
            }
        }
    }
}

