/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.openjpa.ee.AbstractManagedRuntime;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UserException;

class LocalManagedRuntime
extends AbstractManagedRuntime
implements ManagedRuntime,
TransactionManager,
Transaction {
    private static final Localizer _loc = Localizer.forPackage(LocalManagedRuntime.class);
    private Synchronization _broker = null;
    private Synchronization _factorySync = null;
    private boolean _active = false;
    private Throwable _rollbackOnly = null;

    public LocalManagedRuntime(Broker broker) {
        this._broker = broker;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this;
    }

    @Override
    public synchronized void begin() {
        if (this._active) {
            throw new InvalidStateException(_loc.get("active"));
        }
        this._active = true;
    }

    @Override
    public synchronized void commit() {
        RuntimeException err;
        block15: {
            block14: {
                if (!this._active) {
                    throw new InvalidStateException(_loc.get("not-active"));
                }
                err = null;
                if (this._rollbackOnly == null) {
                    try {
                        this._broker.beforeCompletion();
                        if (this._factorySync != null) {
                            this._factorySync.beforeCompletion();
                        }
                    }
                    catch (RuntimeException re) {
                        this._rollbackOnly = re;
                        err = re;
                    }
                } else {
                    err = new StoreException(_loc.get("marked-rollback")).setCause(this._rollbackOnly).setFatal(true);
                }
                if (this._rollbackOnly == null) {
                    try {
                        this._broker.afterCompletion(3);
                        this.notifyAfterCompletion(3);
                    }
                    catch (RuntimeException re) {
                        if (err != null) break block14;
                        err = re;
                    }
                }
            }
            if (this._active) {
                try {
                    this.rollback();
                }
                catch (RuntimeException re) {
                    if (err != null) break block15;
                    err = re;
                }
            }
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    public synchronized void rollback() {
        RuntimeException err;
        block6: {
            if (!this._active) {
                throw new InvalidStateException(_loc.get("not-active"));
            }
            err = null;
            try {
                this._broker.afterCompletion(4);
            }
            catch (RuntimeException re) {
                err = re;
            }
            try {
                this.notifyAfterCompletion(4);
            }
            catch (RuntimeException re) {
                if (err != null) break block6;
                err = re;
            }
        }
        if (err != null) {
            throw err;
        }
    }

    private void notifyAfterCompletion(int status) {
        this._active = false;
        try {
            if (this._factorySync != null) {
                this._factorySync.afterCompletion(status);
            }
        }
        finally {
            this._rollbackOnly = null;
            this._factorySync = null;
        }
    }

    @Override
    public synchronized void setRollbackOnly() {
        this.setRollbackOnly(new UserException());
    }

    @Override
    public void setRollbackOnly(Throwable cause) {
        this._rollbackOnly = cause;
    }

    @Override
    public Throwable getRollbackCause() {
        return this._rollbackOnly;
    }

    @Override
    public synchronized int getStatus() {
        if (this._rollbackOnly != null) {
            return 1;
        }
        if (this._active) {
            return 0;
        }
        return 6;
    }

    @Override
    public Transaction getTransaction() {
        return this;
    }

    @Override
    public void resume(Transaction tobj) throws SystemException {
        throw new SystemException(NotSupportedException.class.getName());
    }

    @Override
    public void setTransactionTimeout(int sec) throws SystemException {
        throw new SystemException(NotSupportedException.class.getName());
    }

    @Override
    public Transaction suspend() throws SystemException {
        throw new SystemException(NotSupportedException.class.getName());
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) throws SystemException {
        throw new SystemException(NotSupportedException.class.getName());
    }

    @Override
    public boolean enlistResource(XAResource xaRes) throws SystemException {
        throw new SystemException(NotSupportedException.class.getName());
    }

    @Override
    public synchronized void registerSynchronization(Synchronization sync) {
        if (sync == this._broker) {
            return;
        }
        if (this._factorySync != null) {
            throw new InternalException();
        }
        this._factorySync = sync;
    }
}

