/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.WidgetLocation;
import org.wicketstuff.dashboard.web.DashboardEvent;
import org.wicketstuff.dashboard.web.SortableAjaxBehavior;
import org.wicketstuff.dashboard.web.WidgetModel;
import org.wicketstuff.dashboard.web.WidgetPanel;

class DashboardColumnPanel
extends GenericPanel<Dashboard> {
    private static final long serialVersionUID = 1L;
    private SortableAjaxBehavior sortableAjaxBehavior;

    public DashboardColumnPanel(String id, final IModel<Dashboard> dashboardModel, int columnIndex) {
        super(id, dashboardModel);
        WebMarkupContainer columnContainer = new WebMarkupContainer("columnContainer");
        columnContainer.setOutputMarkupId(true);
        columnContainer.setMarkupId("column-" + columnIndex);
        List<Widget> widgets = ((Dashboard)this.getModelObject()).getWidgets(columnIndex);
        ListView<Widget> listView = new ListView<Widget>("widgetList", widgets){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<Widget> item) {
                Widget widget = (Widget)item.getModelObject();
                WidgetModel widgetModel = new WidgetModel((IModel<Dashboard>)dashboardModel, widget.getId());
                WidgetPanel widgetPanel = DashboardColumnPanel.this.createWidgetPanel("widget", (IModel<Widget>)widgetModel);
                item.add(new Component[]{widgetPanel});
                item.setOutputMarkupId(true);
                item.setMarkupId("widget-" + widget.getId());
            }
        };
        columnContainer.add(new Component[]{listView});
        this.add(new Component[]{columnContainer});
    }

    public WebMarkupContainer getColumnContainer() {
        return (WebMarkupContainer)this.get("columnContainer");
    }

    public Dashboard getDashboard() {
        return (Dashboard)this.getModelObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addSortableBehavior((Component)this.getColumnContainer());
    }

    private WidgetPanel createWidgetPanel(String id, IModel<Widget> model) {
        return new WidgetPanel(id, model);
    }

    private void addSortableBehavior(Component component) {
        this.sortableAjaxBehavior = new SortableAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            public void onSort(AjaxRequestTarget target, Map<String, WidgetLocation> widgetLocations) {
                DashboardColumnPanel.this.send((IEventSink)DashboardColumnPanel.this.getPage(), Broadcast.BREADTH, new DashboardEvent(target, DashboardEvent.EventType.WIDGETS_SORTED, widgetLocations));
            }
        };
        component.add(new Behavior[]{this.sortableAjaxBehavior});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        CharSequence script = this.sortableAjaxBehavior.getCallbackFunctionBody(new CallbackParameter[0]);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("component", this.get("columnContainer").getMarkupId());
        vars.put("stopBehavior", script.toString());
        try (PackageTextTemplate template = new PackageTextTemplate(DashboardColumnPanel.class, "res/sort-behavior.template.js");){
            template.interpolate(vars);
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)template.getString()));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }
}

