/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ContentLengthHeader;

public class ContentLength
extends SIPHeader
implements ContentLengthHeader {
    private static final long serialVersionUID = 1187190542411037027L;
    public static final String NAME_LOWER = "Content-Length".toLowerCase();
    protected int contentLength = -1;

    public ContentLength() {
        super("Content-Length");
    }

    public ContentLength(int length) {
        super("Content-Length");
        this.contentLength = length;
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setContentLength(int contentLength) throws InvalidArgumentException {
        if (contentLength < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, ContentLength, setContentLength(), the contentLength parameter is <0");
        }
        this.contentLength = contentLength;
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.contentLength < 0) {
            buffer.append("0");
        } else {
            buffer.append(this.contentLength);
        }
        return buffer;
    }

    @Override
    public boolean match(Object other) {
        return other instanceof ContentLength;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ContentLengthHeader) {
            ContentLengthHeader o = (ContentLengthHeader)other;
            return this.getContentLength() == o.getContentLength();
        }
        return false;
    }
}

