/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.impl.ProbeUtils;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.counters.Counter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

enum ProbeType {
    TYPE_LONG_PRIMITIVE(Long.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE),
    TYPE_LONG_NUMBER(Long.TYPE, Byte.class, Integer.class, Short.class, Long.class, AtomicInteger.class, AtomicLong.class, LongAdder.class, LongAccumulator.class),
    TYPE_DOUBLE_PRIMITIVE(Double.TYPE, Double.TYPE, Float.TYPE),
    TYPE_DOUBLE_NUMBER(Double.TYPE, Double.class, Float.class),
    TYPE_COLLECTION(Long.TYPE, Collection.class),
    TYPE_MAP(Long.TYPE, Map.class),
    TYPE_COUNTER(Long.TYPE, Counter.class),
    TYPE_SEMAPHORE(Long.TYPE, Semaphore.class);

    private static final Map<Class<?>, ProbeType> TYPES;
    private final Class<?> mapsTo;
    private final Class<?>[] types;

    private ProbeType(Class<?> mapsTo, Class<?> ... types) {
        this.mapsTo = mapsTo;
        this.types = types;
    }

    Class<?> getMapsTo() {
        return this.mapsTo;
    }

    boolean isPrimitive() {
        return Arrays.stream(this.types).allMatch(Class::isPrimitive);
    }

    static ProbeType getType(Class<?> classType) {
        ProbeType type = TYPES.get(classType);
        if (type != null) {
            return type;
        }
        LinkedHashSet flattenedClasses = new LinkedHashSet();
        ProbeUtils.flatten(classType, flattenedClasses);
        return flattenedClasses.stream().map(TYPES::get).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static {
        Map<Class<?>, ProbeType> types = MapUtil.createHashMap(20);
        for (ProbeType probeUtils : ProbeType.values()) {
            for (Class<?> type : probeUtils.types) {
                types.put(type, probeUtils);
            }
        }
        TYPES = Collections.unmodifiableMap(types);
    }
}

