/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.ClusterVersionAware;
import com.hazelcast.internal.serialization.impl.DataSerializableHeader;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.TypedDataSerializable;
import com.hazelcast.nio.serialization.TypedStreamDeserializer;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.nio.serialization.impl.VersionedIdentifiedDataSerializable;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

class VersionedDataSerializableSerializer
implements StreamSerializer<DataSerializable>,
TypedStreamDeserializer<DataSerializable> {
    private static final String FACTORY_ID = "com.hazelcast.DataSerializerHook";
    private final ClusterVersionAware clusterVersionAware;
    private final Int2ObjectHashMap<DataSerializableFactory> factories = new Int2ObjectHashMap();

    VersionedDataSerializableSerializer(Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, ClassLoader classLoader, ClusterVersionAware clusterVersionAware) {
        this(dataSerializableFactories, classLoader, clusterVersionAware, FACTORY_ID);
    }

    VersionedDataSerializableSerializer(Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, ClassLoader classLoader, ClusterVersionAware clusterVersionAware, String factoryId) {
        this.clusterVersionAware = clusterVersionAware;
        try {
            ArrayList hooks = new ArrayList();
            ServiceLoader.iterator(DataSerializerHook.class, factoryId, classLoader).forEachRemaining(hooks::add);
            for (DataSerializerHook hook : hooks) {
                DataSerializableFactory factory;
                if (!hook.shouldRegister() || (factory = hook.createFactory()) == null) continue;
                this.register(hook.getFactoryId(), factory);
            }
            for (DataSerializerHook hook : hooks) {
                hook.afterFactoriesCreated(this.factories);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        if (dataSerializableFactories != null) {
            for (Map.Entry<Integer, ? extends DataSerializableFactory> entry : dataSerializableFactories.entrySet()) {
                this.register(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void register(int factoryId, DataSerializableFactory factory) {
        DataSerializableFactory current = this.factories.get(factoryId);
        if (current != null) {
            if (!current.equals(factory)) throw new IllegalArgumentException("DataSerializableFactory[" + factoryId + "] is already registered! " + current + " -> " + factory);
            Logger.getLogger(this.getClass()).warning("DataSerializableFactory[" + factoryId + "] is already registered! Skipping " + factory);
            return;
        } else {
            this.factories.put(factoryId, factory);
        }
    }

    @Override
    public int getTypeId() {
        return -2;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }

    @Override
    public void write(ObjectDataOutput out, DataSerializable obj) throws IOException {
        Version previousClusterVersion = out.getVersion();
        if (out.getWanProtocolVersion() == Version.UNKNOWN) {
            Version version = obj instanceof Versioned ? this.clusterVersionAware.getClusterVersion() : Version.UNKNOWN;
            out.setVersion(version);
        }
        if (obj instanceof IdentifiedDataSerializable) {
            IdentifiedDataSerializable serializable = (IdentifiedDataSerializable)obj;
            this.writeIdentifiedDataSerializable(out, serializable, out.getVersion(), out.getWanProtocolVersion());
        } else {
            this.writeDataSerializable(out, obj, out.getVersion(), out.getWanProtocolVersion());
        }
        obj.writeData(out);
        if (out.getWanProtocolVersion() == Version.UNKNOWN) {
            out.setVersion(previousClusterVersion);
        }
    }

    private void writeIdentifiedDataSerializable(ObjectDataOutput out, IdentifiedDataSerializable obj, Version clusterVersion, Version wanProtocolVersion) throws IOException {
        int n;
        boolean versioned = clusterVersion != Version.UNKNOWN || wanProtocolVersion != Version.UNKNOWN;
        out.writeByte(DataSerializableHeader.createHeader(true, versioned));
        out.writeInt(obj.getFactoryId());
        if (obj instanceof VersionedIdentifiedDataSerializable) {
            VersionedIdentifiedDataSerializable vids = (VersionedIdentifiedDataSerializable)obj;
            n = vids.getClassId(clusterVersion);
        } else {
            n = obj.getClassId();
        }
        out.writeInt(n);
        if (wanProtocolVersion != Version.UNKNOWN) {
            out.writeByte(-wanProtocolVersion.getMajor());
            out.writeByte(wanProtocolVersion.getMinor());
        } else if (clusterVersion != Version.UNKNOWN) {
            out.writeByte(clusterVersion.getMajor());
            out.writeByte(clusterVersion.getMinor());
        }
    }

    private void writeDataSerializable(ObjectDataOutput out, DataSerializable obj, Version clusterVersion, Version wanProtocolVersion) throws IOException {
        boolean versioned = clusterVersion != Version.UNKNOWN || wanProtocolVersion != Version.UNKNOWN;
        out.writeByte(DataSerializableHeader.createHeader(false, versioned));
        if (obj instanceof TypedDataSerializable) {
            TypedDataSerializable serializable = (TypedDataSerializable)obj;
            out.writeString(serializable.getClassType().getName());
        } else {
            out.writeString(obj.getClass().getName());
        }
        if (wanProtocolVersion != Version.UNKNOWN) {
            out.writeByte(-wanProtocolVersion.getMajor());
            out.writeByte(wanProtocolVersion.getMinor());
        } else if (clusterVersion != Version.UNKNOWN) {
            out.writeByte(clusterVersion.getMajor());
            out.writeByte(clusterVersion.getMinor());
        }
    }

    @Override
    public DataSerializable read(ObjectDataInput in, Class clazz) throws IOException {
        DataSerializable instance = null;
        if (null != clazz) {
            try {
                instance = (DataSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException("Requested class " + clazz + " could not be instantiated.", e);
            }
        }
        return this.doRead(in, instance);
    }

    @Override
    public DataSerializable read(ObjectDataInput in) throws IOException {
        return this.doRead(in, null);
    }

    private DataSerializable doRead(ObjectDataInput in, DataSerializable instance) throws IOException {
        byte header = in.readByte();
        if (DataSerializableHeader.isIdentifiedDataSerializable(header)) {
            return this.readIdentifiedDataSerializable(in, header, instance);
        }
        return this.readDataSerializable(in, header, instance);
    }

    private DataSerializable readIdentifiedDataSerializable(ObjectDataInput in, byte header, DataSerializable instance) throws IOException {
        int factoryId = 0;
        int classId = 0;
        try {
            factoryId = in.readInt();
            classId = in.readInt();
            Version previousClusterVersion = in.getVersion();
            Version previousWanProtocolVersion = in.getWanProtocolVersion();
            if (DataSerializableHeader.isVersioned(header)) {
                this.readVersions(in);
            } else {
                in.setVersion(Version.UNKNOWN);
                in.setWanProtocolVersion(Version.UNKNOWN);
            }
            DataSerializable ds = instance != null ? instance : this.createIdentifiedDataSerializable(in.getVersion(), in.getWanProtocolVersion(), factoryId, classId);
            ds.readData(in);
            in.setVersion(previousClusterVersion);
            in.setWanProtocolVersion(previousWanProtocolVersion);
            return ds;
        }
        catch (Exception ex) {
            throw VersionedDataSerializableSerializer.rethrowIdsReadException(factoryId, classId, ex);
        }
    }

    private void readVersions(ObjectDataInput in) throws IOException {
        byte major = in.readByte();
        byte minor = in.readByte();
        assert (this.clusterVersionAware.getClusterVersion() != null);
        if (major < 0) {
            in.setWanProtocolVersion(Version.of(-major, minor));
        } else {
            in.setVersion(Version.of(major, minor));
        }
    }

    private DataSerializable createIdentifiedDataSerializable(Version clusterVersion, Version wanProtocolVersion, int factoryId, int classId) {
        DataSerializableFactory dsf = this.factories.get(factoryId);
        if (dsf == null) {
            throw new HazelcastSerializationException("No DataSerializerFactory registered for namespace: " + factoryId);
        }
        return dsf.create(classId);
    }

    private DataSerializable readDataSerializable(ObjectDataInput in, byte header, DataSerializable instance) throws IOException {
        String className = in.readString();
        try {
            Version previousClusterVersion = in.getVersion();
            Version previousWanProtocolVersion = in.getWanProtocolVersion();
            if (DataSerializableHeader.isVersioned(header)) {
                this.readVersions(in);
            } else {
                in.setVersion(Version.UNKNOWN);
                in.setWanProtocolVersion(Version.UNKNOWN);
            }
            DataSerializable ds = instance != null ? instance : (DataSerializable)ClassLoaderUtil.newInstance(in.getClassLoader(), className);
            ds.readData(in);
            in.setVersion(previousClusterVersion);
            in.setWanProtocolVersion(previousWanProtocolVersion);
            return ds;
        }
        catch (Exception ex) {
            throw VersionedDataSerializableSerializer.rethrowDsReadException(className, ex);
        }
    }

    private static IOException rethrowIdsReadException(int factoryId, int classId, Exception e) throws IOException {
        if (e instanceof IOException) {
            IOException exception = (IOException)e;
            throw exception;
        }
        if (e instanceof HazelcastSerializationException) {
            HazelcastSerializationException exception = (HazelcastSerializationException)e;
            throw exception;
        }
        throw new HazelcastSerializationException("Problem while reading IdentifiedDataSerializable, namespace: " + factoryId + ", classId: " + classId + ", exception: " + e.getMessage(), e);
    }

    private static IOException rethrowDsReadException(String className, Exception e) throws IOException {
        if (e instanceof IOException) {
            IOException exception = (IOException)e;
            throw exception;
        }
        if (e instanceof HazelcastSerializationException) {
            HazelcastSerializationException exception = (HazelcastSerializationException)e;
            throw exception;
        }
        throw new HazelcastSerializationException("Problem while reading DataSerializable, class-name: " + className + ", exception: " + e.getMessage(), e);
    }
}

