/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.iobuffer;

import com.hazelcast.internal.tpcengine.iobuffer.IOBuffer;
import com.hazelcast.internal.tpcengine.iobuffer.IOBufferAllocator;
import com.hazelcast.internal.tpcengine.util.BufferUtil;
import java.nio.ByteBuffer;

public final class NonConcurrentIOBufferAllocator
implements IOBufferAllocator {
    private final int minSize;
    private final boolean direct;
    private long newAllocateCnt;
    private long allocateCnt;
    private IOBuffer[] bufs = new IOBuffer[4096];
    private int index = -1;

    public NonConcurrentIOBufferAllocator(int minSize, boolean direct) {
        this.minSize = minSize;
        this.direct = direct;
    }

    @Override
    public IOBuffer allocate() {
        ++this.allocateCnt;
        if (this.index == -1) {
            for (int k = 0; k < this.bufs.length; ++k) {
                ByteBuffer buffer = BufferUtil.allocateBuffer(this.direct, this.minSize);
                IOBuffer buf = new IOBuffer(buffer);
                buf.concurrent = false;
                ++this.newAllocateCnt;
                buf.allocator = this;
                ++this.index;
                this.bufs[k] = buf;
            }
        }
        IOBuffer buf = this.bufs[this.index];
        this.bufs[this.index] = null;
        --this.index;
        buf.acquire();
        return buf;
    }

    @Override
    public IOBuffer allocate(int minSize) {
        IOBuffer buf = this.allocate();
        buf.ensureRemaining(minSize);
        return buf;
    }

    @Override
    public void free(IOBuffer buf) {
        buf.clear();
        buf.next = null;
        if (this.index == this.bufs.length - 1) {
            IOBuffer[] newBuf = new IOBuffer[this.bufs.length * 2];
            System.arraycopy(this.bufs, 0, newBuf, 0, this.bufs.length);
            this.bufs = newBuf;
        }
        ++this.index;
        this.bufs[this.index] = buf;
    }
}

