/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;

public class QueryEntry
extends QueryableEntry {
    private Data key;
    private Object value;

    public QueryEntry() {
    }

    public QueryEntry(SerializationService serializationService, Data key, Object value, Extractors extractors) {
        this.init(serializationService, key, value, extractors);
    }

    public void init(SerializationService serializationService, Data key, Object value, Extractors extractors) {
        if (key == null) {
            throw new IllegalArgumentException("keyData cannot be null");
        }
        this.serializationService = (InternalSerializationService)serializationService;
        this.key = key;
        this.value = value;
        this.extractors = extractors;
    }

    @Override
    public Object getKey() {
        return this.serializationService.toObject(this.key);
    }

    @Override
    public Data getKeyData() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.serializationService.toObject(this.value);
    }

    @Override
    public Data getValueData() {
        return this.serializationService.toData(this.value);
    }

    public Object getKeyIfPresent() {
        return null;
    }

    @Override
    public Data getKeyDataIfPresent() {
        return this.key;
    }

    public Object getValueIfPresent() {
        if (!(this.value instanceof Data)) {
            return this.value;
        }
        Object possiblyNotData = this.record.getValue();
        return possiblyNotData instanceof Data ? null : possiblyNotData;
    }

    @Override
    public Data getValueDataIfPresent() {
        Data d;
        Object object = this.value;
        if (object instanceof Data) {
            Data data = (Data)object;
            return data;
        }
        Object possiblyData = this.record.getValue();
        return possiblyData instanceof Data ? (d = (Data)possiblyData) : null;
    }

    @Override
    protected Object getTargetObject(boolean key) {
        return key ? this.key : this.value;
    }

    @Override
    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEntry that = (QueryEntry)o;
        return this.key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }
}

