/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ProtocolCommandSupport;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.io.CRLFLineReader;
import org.apache.commons.net.smtp.SMTPCommand;
import org.apache.commons.net.smtp.SMTPConnectionClosedException;
import org.apache.commons.net.util.NetConstants;

public class SMTP
extends SocketClient {
    public static final int DEFAULT_PORT = 25;
    private static final String DEFAULT_ENCODING = StandardCharsets.ISO_8859_1.name();
    protected final String encoding;
    protected ProtocolCommandSupport _commandSupport_;
    BufferedReader reader;
    BufferedWriter writer;
    private int replyCode;
    private final ArrayList<String> replyLines;
    private boolean newReplyString;
    private String replyString;

    public SMTP() {
        this(DEFAULT_ENCODING);
    }

    public SMTP(String encoding) {
        this.setDefaultPort(25);
        this.replyLines = new ArrayList();
        this.newReplyString = false;
        this.replyString = null;
        this._commandSupport_ = new ProtocolCommandSupport(this);
        this.encoding = encoding;
    }

    @Override
    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this.reader = new CRLFLineReader(new InputStreamReader(this._input_, this.encoding));
        this.writer = new BufferedWriter(new OutputStreamWriter(this._output_, this.encoding));
        this.getReply();
    }

    public int data() throws IOException {
        return this.sendCommand(3);
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this.reader = null;
        this.writer = null;
        this.replyString = null;
        this.replyLines.clear();
        this.newReplyString = false;
    }

    public int expn(String name) throws IOException {
        return this.sendCommand(9, name);
    }

    @Override
    protected ProtocolCommandSupport getCommandSupport() {
        return this._commandSupport_;
    }

    public int getReply() throws IOException {
        this.newReplyString = true;
        this.replyLines.clear();
        String line = this.reader.readLine();
        if (line == null) {
            throw new SMTPConnectionClosedException("Connection closed without indication.");
        }
        int length = line.length();
        if (length < 3) {
            throw new MalformedServerReplyException("Truncated server reply: " + line);
        }
        try {
            String code = line.substring(0, 3);
            this.replyCode = Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new MalformedServerReplyException("Could not parse response code.\nServer Reply: " + line);
        }
        this.replyLines.add(line);
        if (length > 3 && line.charAt(3) == '-') {
            do {
                if ((line = this.reader.readLine()) == null) {
                    throw new SMTPConnectionClosedException("Connection closed without indication.");
                }
                this.replyLines.add(line);
            } while (line.length() < 4 || line.charAt(3) == '-' || !Character.isDigit(line.charAt(0)));
        }
        this.fireReplyReceived(this.replyCode, this.getReplyString());
        if (this.replyCode == 421) {
            throw new SMTPConnectionClosedException("SMTP response 421 received.  Server closed connection.");
        }
        return this.replyCode;
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public String getReplyString() {
        if (!this.newReplyString) {
            return this.replyString;
        }
        StringBuilder buffer = new StringBuilder();
        for (String line : this.replyLines) {
            buffer.append(line);
            buffer.append("\r\n");
        }
        this.newReplyString = false;
        this.replyString = buffer.toString();
        return this.replyString;
    }

    public String[] getReplyStrings() {
        return this.replyLines.toArray(NetConstants.EMPTY_STRING_ARRAY);
    }

    public int helo(String hostname) throws IOException {
        return this.sendCommand(0, hostname);
    }

    public int help() throws IOException {
        return this.sendCommand(10);
    }

    public int help(String command) throws IOException {
        return this.sendCommand(10, command);
    }

    public int mail(String reversePath) throws IOException {
        return this.sendCommand(1, reversePath, false);
    }

    public int noop() throws IOException {
        return this.sendCommand(11);
    }

    public int quit() throws IOException {
        return this.sendCommand(13);
    }

    public int rcpt(String forwardPath) throws IOException {
        return this.sendCommand(2, forwardPath, false);
    }

    public void removeProtocolCommandistener(ProtocolCommandListener listener) {
        this.removeProtocolCommandListener(listener);
    }

    public int rset() throws IOException {
        return this.sendCommand(7);
    }

    public int saml(String reversePath) throws IOException {
        return this.sendCommand(6, reversePath);
    }

    public int send(String reversePath) throws IOException {
        return this.sendCommand(4, reversePath);
    }

    public int sendCommand(int command) throws IOException {
        return this.sendCommand(command, null);
    }

    public int sendCommand(int command, String args) throws IOException {
        return this.sendCommand(SMTPCommand.getCommand(command), args);
    }

    private int sendCommand(int command, String args, boolean includeSpace) throws IOException {
        return this.sendCommand(SMTPCommand.getCommand(command), args, includeSpace);
    }

    public int sendCommand(String command) throws IOException {
        return this.sendCommand(command, null);
    }

    public int sendCommand(String command, String args) throws IOException {
        return this.sendCommand(command, args, true);
    }

    private int sendCommand(String command, String args, boolean includeSpace) throws IOException {
        StringBuilder builder = new StringBuilder(command);
        if (args != null) {
            if (includeSpace) {
                builder.append(' ');
            }
            builder.append(args);
        }
        builder.append("\r\n");
        String message = builder.toString();
        this.writer.write(message);
        this.writer.flush();
        this.fireCommandSent(command, message);
        return this.getReply();
    }

    public int soml(String reversePath) throws IOException {
        return this.sendCommand(5, reversePath);
    }

    public int turn() throws IOException {
        return this.sendCommand(12);
    }

    public int vrfy(String user) throws IOException {
        return this.sendCommand(8, user);
    }
}

