/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0Font;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2Font;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.CIDType0FontValidator;
import org.apache.pdfbox.preflight.font.CIDType2FontValidator;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.container.Type0Container;
import org.apache.pdfbox.preflight.utils.COSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type0FontValidator
extends FontValidator<Type0Container> {
    protected COSDocument cosDocument = this.context.getDocument().getDocument();

    public Type0FontValidator(PreflightContext context, PDFont font) {
        super(context, font, new Type0Container(font));
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryFields();
        this.processDescendantFont();
        this.checkEncoding();
        this.checkToUnicode();
    }

    protected void checkMandatoryFields() {
        COSDictionary fontDictionary = (COSDictionary)this.font.getCOSObject();
        boolean areFieldsPResent = fontDictionary.containsKey(COSName.TYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.SUBTYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.BASE_FONT);
        areFieldsPResent &= fontDictionary.containsKey(COSName.DESCENDANT_FONTS);
        if (!(areFieldsPResent &= fontDictionary.containsKey(COSName.ENCODING))) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "Some keys are missing from composite font dictionary"));
        }
    }

    protected void processDescendantFont() throws ValidationException {
        COSDictionary fontDictionary = (COSDictionary)this.font.getCOSObject();
        COSArray array = COSUtils.getAsArray(fontDictionary.getItem(COSName.DESCENDANT_FONTS), this.cosDocument);
        if (array == null || array.size() != 1) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", "CIDFont is missing from the DescendantFonts array or the size of array is greater than 1"));
            return;
        }
        COSDictionary cidFont = COSUtils.getAsDictionary(array.get(0), this.cosDocument);
        if (cidFont == null) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", "The DescendantFonts array should have one element with is a dictionary."));
            return;
        }
        FontValidator<? extends FontContainer> cidFontValidator = this.createDescendantValidator(cidFont);
        if (cidFontValidator != null) {
            ((Type0Container)this.fontContainer).setDelegateFontContainer(cidFontValidator.getFontContainer());
            cidFontValidator.validate();
        }
    }

    protected FontValidator<? extends FontContainer> createDescendantValidator(COSDictionary cidFont) {
        String subtype = cidFont.getNameAsString(COSName.SUBTYPE);
        FontValidator<? extends FontContainer> cidFontValidator = null;
        if ("CIDFontType0".equals(subtype)) {
            cidFontValidator = this.createCIDType0FontValidator(cidFont);
        } else if ("CIDFontType2".equals(subtype)) {
            cidFontValidator = this.createCIDType2FontValidator(cidFont);
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "Type and/or Subtype keys are missing"));
        }
        return cidFontValidator;
    }

    protected FontValidator<? extends FontContainer> createCIDType0FontValidator(COSDictionary fDict) {
        return new CIDType0FontValidator(this.context, new PDCIDFontType0Font(fDict));
    }

    protected FontValidator<? extends FontContainer> createCIDType2FontValidator(COSDictionary fDict) {
        return new CIDType2FontValidator(this.context, new PDCIDFontType2Font(fDict));
    }

    @Override
    protected void checkEncoding() {
        COSBase encoding = ((COSDictionary)this.font.getCOSObject()).getItem(COSName.ENCODING);
        this.checkCMapEncoding(encoding);
    }

    protected void checkCMapEncoding(COSBase encoding) {
        if (COSUtils.isString(encoding, this.cosDocument)) {
            String str = COSUtils.getAsString(encoding, this.cosDocument);
            if (!"Identity-V".equals(str) && !"Identity-H".equals(str)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.7", "The CMap is a string but it isn't an Identity-H/V"));
                return;
            }
        } else if (COSUtils.isStream(encoding, this.cosDocument)) {
            this.processCMapAsStream(COSUtils.getAsStream(encoding, this.cosDocument));
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", "The CMap type is invalid"));
        }
    }

    private void processCMapAsStream(COSStream aCMap) {
        COSBase sysinfo = aCMap.getItem(COSName.CIDSYSTEMINFO);
        this.checkCIDSystemInfo(sysinfo);
        try {
            CMap fontboxCMap = new CMapParser().parse(null, aCMap.getUnfilteredStream());
            int wmValue = fontboxCMap.getWMode();
            String cmnValue = fontboxCMap.getName();
            int wmode = aCMap.getInt(COSName.getPDFName("WMode"), 0);
            String type = aCMap.getNameAsString(COSName.TYPE);
            String cmapName = aCMap.getNameAsString(COSName.getPDFName("CMapName"));
            if (cmapName == null || "".equals(cmapName) || wmode > 1) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", "Some elements in the CMap dictionary are missing or invalid"));
            } else if (wmValue != wmode || !cmapName.equals(cmnValue)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", "CMapName or WMode is inconsistent"));
            } else if (!"CMap".equals(type)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.10", "The CMap type is invalid"));
            }
        }
        catch (IOException e) {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.5", "The CMap type is damaged"));
        }
        COSDictionary cmapUsed = (COSDictionary)aCMap.getDictionaryObject(COSName.getPDFName("UseCMap"));
        if (cmapUsed != null) {
            this.checkCMapEncoding(cmapUsed);
        }
        this.compareCIDSystemInfo(aCMap);
    }

    protected boolean checkCIDSystemInfo(COSBase sysinfo) {
        boolean result = true;
        COSDictionary cidSysInfo = COSUtils.getAsDictionary(sysinfo, this.cosDocument);
        if (cidSysInfo != null) {
            COSBase reg = cidSysInfo.getItem(COSName.REGISTRY);
            COSBase ord = cidSysInfo.getItem(COSName.ORDERING);
            COSBase sup = cidSysInfo.getItem(COSName.SUPPLEMENT);
            if (!(COSUtils.isString(reg, this.cosDocument) && COSUtils.isString(ord, this.cosDocument) && COSUtils.isInteger(sup, this.cosDocument))) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8"));
                result = false;
            }
        } else {
            ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8"));
            result = false;
        }
        return result;
    }

    private void compareCIDSystemInfo(COSDictionary cmap) {
        COSDictionary fontDictionary = (COSDictionary)this.font.getCOSObject();
        COSArray array = COSUtils.getAsArray(fontDictionary.getItem(COSName.DESCENDANT_FONTS), this.cosDocument);
        if (array != null && array.size() > 0) {
            COSDictionary cidFont = COSUtils.getAsDictionary(array.get(0), this.cosDocument);
            COSDictionary cmsi = COSUtils.getAsDictionary(cmap.getItem(COSName.CIDSYSTEMINFO), this.cosDocument);
            COSDictionary cfsi = COSUtils.getAsDictionary(cidFont.getItem(COSName.CIDSYSTEMINFO), this.cosDocument);
            String regCM = COSUtils.getAsString(cmsi.getItem(COSName.REGISTRY), this.cosDocument);
            String ordCM = COSUtils.getAsString(cmsi.getItem(COSName.ORDERING), this.cosDocument);
            String regCF = COSUtils.getAsString(cfsi.getItem(COSName.REGISTRY), this.cosDocument);
            String ordCF = COSUtils.getAsString(cfsi.getItem(COSName.ORDERING), this.cosDocument);
            if (!regCF.equals(regCM) || !ordCF.equals(ordCM)) {
                ((Type0Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.8", "The CIDSystemInfo is inconsistent"));
            }
        }
    }
}

