/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.utils;

import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.ValidationProcess;

public class ContextHelper {
    public static void validateElement(PreflightContext context, Object element, String processName) throws ValidationException {
        if (element == null) {
            context.addValidationError(new ValidationResult.ValidationError("8.1", "Unable to process an element if it is null."));
        } else {
            ContextHelper.callValidation(context, element, processName);
        }
    }

    private static void callValidation(PreflightContext context, Object element, String processName) throws ValidationException {
        PreflightPath validationPath = context.getValidationPath();
        if (ContextHelper.hasRecursion(context, element, validationPath)) {
            return;
        }
        boolean needPop = validationPath.pushObject(element);
        PreflightConfiguration config = context.getConfig();
        ValidationProcess process = config.getInstanceOfProcess(processName);
        process.validate(context);
        if (needPop) {
            validationPath.pop();
        }
    }

    public static void validateElement(PreflightContext context, String processName) throws ValidationException {
        ContextHelper.callValidation(context, null, processName);
    }

    private static boolean hasRecursion(PreflightContext context, Object element, PreflightPath validationPath) {
        if (element instanceof PDResources) {
            for (int i = 0; i < validationPath.size(); ++i) {
                PDResources pdRes;
                Object obj = validationPath.getPathElement(i, Object.class);
                if (!(obj instanceof PDResources) || (pdRes = (PDResources)obj).getCOSObject() != ((PDResources)element).getCOSObject()) continue;
                context.addValidationError(new ValidationResult.ValidationError("8", "Resources recursion"));
                return true;
            }
        }
        return false;
    }
}

