/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesLiftGroupMode is the corresponding interface of BACnetPropertyStatesLiftGroupMode
type BACnetPropertyStatesLiftGroupMode interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetLiftGroupMode returns LiftGroupMode (property field)
	GetLiftGroupMode() BACnetLiftGroupModeTagged
	// IsBACnetPropertyStatesLiftGroupMode is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesLiftGroupMode()
	// CreateBuilder creates a BACnetPropertyStatesLiftGroupModeBuilder
	CreateBACnetPropertyStatesLiftGroupModeBuilder() BACnetPropertyStatesLiftGroupModeBuilder
}

// _BACnetPropertyStatesLiftGroupMode is the data-structure of this message
type _BACnetPropertyStatesLiftGroupMode struct {
	BACnetPropertyStatesContract
	LiftGroupMode BACnetLiftGroupModeTagged
}

var _ BACnetPropertyStatesLiftGroupMode = (*_BACnetPropertyStatesLiftGroupMode)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesLiftGroupMode)(nil)

// NewBACnetPropertyStatesLiftGroupMode factory function for _BACnetPropertyStatesLiftGroupMode
func NewBACnetPropertyStatesLiftGroupMode(peekedTagHeader BACnetTagHeader, liftGroupMode BACnetLiftGroupModeTagged) *_BACnetPropertyStatesLiftGroupMode {
	if liftGroupMode == nil {
		panic("liftGroupMode of type BACnetLiftGroupModeTagged for BACnetPropertyStatesLiftGroupMode must not be nil")
	}
	_result := &_BACnetPropertyStatesLiftGroupMode{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		LiftGroupMode:                liftGroupMode,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesLiftGroupModeBuilder is a builder for BACnetPropertyStatesLiftGroupMode
type BACnetPropertyStatesLiftGroupModeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(liftGroupMode BACnetLiftGroupModeTagged) BACnetPropertyStatesLiftGroupModeBuilder
	// WithLiftGroupMode adds LiftGroupMode (property field)
	WithLiftGroupMode(BACnetLiftGroupModeTagged) BACnetPropertyStatesLiftGroupModeBuilder
	// WithLiftGroupModeBuilder adds LiftGroupMode (property field) which is build by the builder
	WithLiftGroupModeBuilder(func(BACnetLiftGroupModeTaggedBuilder) BACnetLiftGroupModeTaggedBuilder) BACnetPropertyStatesLiftGroupModeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesLiftGroupMode or returns an error if something is wrong
	Build() (BACnetPropertyStatesLiftGroupMode, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesLiftGroupMode
}

// NewBACnetPropertyStatesLiftGroupModeBuilder() creates a BACnetPropertyStatesLiftGroupModeBuilder
func NewBACnetPropertyStatesLiftGroupModeBuilder() BACnetPropertyStatesLiftGroupModeBuilder {
	return &_BACnetPropertyStatesLiftGroupModeBuilder{_BACnetPropertyStatesLiftGroupMode: new(_BACnetPropertyStatesLiftGroupMode)}
}

type _BACnetPropertyStatesLiftGroupModeBuilder struct {
	*_BACnetPropertyStatesLiftGroupMode

	parentBuilder *_BACnetPropertyStatesBuilder

	collectedErr []error
}

var _ (BACnetPropertyStatesLiftGroupModeBuilder) = (*_BACnetPropertyStatesLiftGroupModeBuilder)(nil)

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesLiftGroupMode
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) WithMandatoryFields(liftGroupMode BACnetLiftGroupModeTagged) BACnetPropertyStatesLiftGroupModeBuilder {
	return b.WithLiftGroupMode(liftGroupMode)
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) WithLiftGroupMode(liftGroupMode BACnetLiftGroupModeTagged) BACnetPropertyStatesLiftGroupModeBuilder {
	b.LiftGroupMode = liftGroupMode
	return b
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) WithLiftGroupModeBuilder(builderSupplier func(BACnetLiftGroupModeTaggedBuilder) BACnetLiftGroupModeTaggedBuilder) BACnetPropertyStatesLiftGroupModeBuilder {
	builder := builderSupplier(b.LiftGroupMode.CreateBACnetLiftGroupModeTaggedBuilder())
	var err error
	b.LiftGroupMode, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetLiftGroupModeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) Build() (BACnetPropertyStatesLiftGroupMode, error) {
	if b.LiftGroupMode == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'liftGroupMode' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyStatesLiftGroupMode.deepCopy(), nil
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) MustBuild() BACnetPropertyStatesLiftGroupMode {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesLiftGroupModeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesLiftGroupModeBuilder().(*_BACnetPropertyStatesLiftGroupModeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyStatesLiftGroupModeBuilder creates a BACnetPropertyStatesLiftGroupModeBuilder
func (b *_BACnetPropertyStatesLiftGroupMode) CreateBACnetPropertyStatesLiftGroupModeBuilder() BACnetPropertyStatesLiftGroupModeBuilder {
	if b == nil {
		return NewBACnetPropertyStatesLiftGroupModeBuilder()
	}
	return &_BACnetPropertyStatesLiftGroupModeBuilder{_BACnetPropertyStatesLiftGroupMode: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesLiftGroupMode) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesLiftGroupMode) GetLiftGroupMode() BACnetLiftGroupModeTagged {
	return m.LiftGroupMode
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesLiftGroupMode(structType any) BACnetPropertyStatesLiftGroupMode {
	if casted, ok := structType.(BACnetPropertyStatesLiftGroupMode); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesLiftGroupMode); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesLiftGroupMode) GetTypeName() string {
	return "BACnetPropertyStatesLiftGroupMode"
}

func (m *_BACnetPropertyStatesLiftGroupMode) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (liftGroupMode)
	lengthInBits += m.LiftGroupMode.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesLiftGroupMode) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesLiftGroupMode) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesLiftGroupMode BACnetPropertyStatesLiftGroupMode, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesLiftGroupMode"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesLiftGroupMode")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	liftGroupMode, err := ReadSimpleField[BACnetLiftGroupModeTagged](ctx, "liftGroupMode", ReadComplex[BACnetLiftGroupModeTagged](BACnetLiftGroupModeTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'liftGroupMode' field"))
	}
	m.LiftGroupMode = liftGroupMode

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesLiftGroupMode"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesLiftGroupMode")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesLiftGroupMode) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesLiftGroupMode) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesLiftGroupMode"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesLiftGroupMode")
		}

		if err := WriteSimpleField[BACnetLiftGroupModeTagged](ctx, "liftGroupMode", m.GetLiftGroupMode(), WriteComplex[BACnetLiftGroupModeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'liftGroupMode' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesLiftGroupMode"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesLiftGroupMode")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesLiftGroupMode) IsBACnetPropertyStatesLiftGroupMode() {}

func (m *_BACnetPropertyStatesLiftGroupMode) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesLiftGroupMode) deepCopy() *_BACnetPropertyStatesLiftGroupMode {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesLiftGroupModeCopy := &_BACnetPropertyStatesLiftGroupMode{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetLiftGroupModeTagged](m.LiftGroupMode),
	}
	_BACnetPropertyStatesLiftGroupModeCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesLiftGroupModeCopy
}

func (m *_BACnetPropertyStatesLiftGroupMode) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
