/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AdditionalParametersType is the corresponding interface of AdditionalParametersType
type AdditionalParametersType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetParameters returns Parameters (property field)
	GetParameters() []KeyValuePair
	// IsAdditionalParametersType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAdditionalParametersType()
	// CreateBuilder creates a AdditionalParametersTypeBuilder
	CreateAdditionalParametersTypeBuilder() AdditionalParametersTypeBuilder
}

// _AdditionalParametersType is the data-structure of this message
type _AdditionalParametersType struct {
	ExtensionObjectDefinitionContract
	Parameters []KeyValuePair
}

var _ AdditionalParametersType = (*_AdditionalParametersType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_AdditionalParametersType)(nil)

// NewAdditionalParametersType factory function for _AdditionalParametersType
func NewAdditionalParametersType(parameters []KeyValuePair) *_AdditionalParametersType {
	_result := &_AdditionalParametersType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Parameters:                        parameters,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AdditionalParametersTypeBuilder is a builder for AdditionalParametersType
type AdditionalParametersTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(parameters []KeyValuePair) AdditionalParametersTypeBuilder
	// WithParameters adds Parameters (property field)
	WithParameters(...KeyValuePair) AdditionalParametersTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the AdditionalParametersType or returns an error if something is wrong
	Build() (AdditionalParametersType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AdditionalParametersType
}

// NewAdditionalParametersTypeBuilder() creates a AdditionalParametersTypeBuilder
func NewAdditionalParametersTypeBuilder() AdditionalParametersTypeBuilder {
	return &_AdditionalParametersTypeBuilder{_AdditionalParametersType: new(_AdditionalParametersType)}
}

type _AdditionalParametersTypeBuilder struct {
	*_AdditionalParametersType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (AdditionalParametersTypeBuilder) = (*_AdditionalParametersTypeBuilder)(nil)

func (b *_AdditionalParametersTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._AdditionalParametersType
}

func (b *_AdditionalParametersTypeBuilder) WithMandatoryFields(parameters []KeyValuePair) AdditionalParametersTypeBuilder {
	return b.WithParameters(parameters...)
}

func (b *_AdditionalParametersTypeBuilder) WithParameters(parameters ...KeyValuePair) AdditionalParametersTypeBuilder {
	b.Parameters = parameters
	return b
}

func (b *_AdditionalParametersTypeBuilder) Build() (AdditionalParametersType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._AdditionalParametersType.deepCopy(), nil
}

func (b *_AdditionalParametersTypeBuilder) MustBuild() AdditionalParametersType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AdditionalParametersTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_AdditionalParametersTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_AdditionalParametersTypeBuilder) DeepCopy() any {
	_copy := b.CreateAdditionalParametersTypeBuilder().(*_AdditionalParametersTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateAdditionalParametersTypeBuilder creates a AdditionalParametersTypeBuilder
func (b *_AdditionalParametersType) CreateAdditionalParametersTypeBuilder() AdditionalParametersTypeBuilder {
	if b == nil {
		return NewAdditionalParametersTypeBuilder()
	}
	return &_AdditionalParametersTypeBuilder{_AdditionalParametersType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AdditionalParametersType) GetExtensionId() int32 {
	return int32(16315)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AdditionalParametersType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AdditionalParametersType) GetParameters() []KeyValuePair {
	return m.Parameters
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAdditionalParametersType(structType any) AdditionalParametersType {
	if casted, ok := structType.(AdditionalParametersType); ok {
		return casted
	}
	if casted, ok := structType.(*AdditionalParametersType); ok {
		return *casted
	}
	return nil
}

func (m *_AdditionalParametersType) GetTypeName() string {
	return "AdditionalParametersType"
}

func (m *_AdditionalParametersType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Implicit Field (noOfParameters)
	lengthInBits += 32

	// Array field
	if len(m.Parameters) > 0 {
		for _curItem, element := range m.Parameters {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Parameters), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_AdditionalParametersType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AdditionalParametersType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__additionalParametersType AdditionalParametersType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AdditionalParametersType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdditionalParametersType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	noOfParameters, err := ReadImplicitField[int32](ctx, "noOfParameters", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfParameters' field"))
	}
	_ = noOfParameters

	parameters, err := ReadCountArrayField[KeyValuePair](ctx, "parameters", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfParameters))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'parameters' field"))
	}
	m.Parameters = parameters

	if closeErr := readBuffer.CloseContext("AdditionalParametersType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdditionalParametersType")
	}

	return m, nil
}

func (m *_AdditionalParametersType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdditionalParametersType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AdditionalParametersType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AdditionalParametersType")
		}
		noOfParameters := int32(utils.InlineIf(bool((m.GetParameters()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetParameters()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfParameters", noOfParameters, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfParameters' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "parameters", m.GetParameters(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'parameters' field")
		}

		if popErr := writeBuffer.PopContext("AdditionalParametersType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AdditionalParametersType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AdditionalParametersType) IsAdditionalParametersType() {}

func (m *_AdditionalParametersType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AdditionalParametersType) deepCopy() *_AdditionalParametersType {
	if m == nil {
		return nil
	}
	_AdditionalParametersTypeCopy := &_AdditionalParametersType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.Parameters),
	}
	_AdditionalParametersTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _AdditionalParametersTypeCopy
}

func (m *_AdditionalParametersType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
