/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonDataSetMetaDataMessage is the corresponding interface of JsonDataSetMetaDataMessage
type JsonDataSetMetaDataMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMessageId returns MessageId (property field)
	GetMessageId() PascalString
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() PascalString
	// GetDataSetWriterId returns DataSetWriterId (property field)
	GetDataSetWriterId() uint16
	// GetWriterGroupName returns WriterGroupName (property field)
	GetWriterGroupName() PascalString
	// GetDataSetWriterName returns DataSetWriterName (property field)
	GetDataSetWriterName() PascalString
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetMetaData returns MetaData (property field)
	GetMetaData() DataSetMetaDataType
	// IsJsonDataSetMetaDataMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonDataSetMetaDataMessage()
	// CreateBuilder creates a JsonDataSetMetaDataMessageBuilder
	CreateJsonDataSetMetaDataMessageBuilder() JsonDataSetMetaDataMessageBuilder
}

// _JsonDataSetMetaDataMessage is the data-structure of this message
type _JsonDataSetMetaDataMessage struct {
	ExtensionObjectDefinitionContract
	MessageId         PascalString
	MessageType       PascalString
	PublisherId       PascalString
	DataSetWriterId   uint16
	WriterGroupName   PascalString
	DataSetWriterName PascalString
	Timestamp         int64
	MetaData          DataSetMetaDataType
}

var _ JsonDataSetMetaDataMessage = (*_JsonDataSetMetaDataMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonDataSetMetaDataMessage)(nil)

// NewJsonDataSetMetaDataMessage factory function for _JsonDataSetMetaDataMessage
func NewJsonDataSetMetaDataMessage(messageId PascalString, messageType PascalString, publisherId PascalString, dataSetWriterId uint16, writerGroupName PascalString, dataSetWriterName PascalString, timestamp int64, metaData DataSetMetaDataType) *_JsonDataSetMetaDataMessage {
	if messageId == nil {
		panic("messageId of type PascalString for JsonDataSetMetaDataMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonDataSetMetaDataMessage must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type PascalString for JsonDataSetMetaDataMessage must not be nil")
	}
	if writerGroupName == nil {
		panic("writerGroupName of type PascalString for JsonDataSetMetaDataMessage must not be nil")
	}
	if dataSetWriterName == nil {
		panic("dataSetWriterName of type PascalString for JsonDataSetMetaDataMessage must not be nil")
	}
	if metaData == nil {
		panic("metaData of type DataSetMetaDataType for JsonDataSetMetaDataMessage must not be nil")
	}
	_result := &_JsonDataSetMetaDataMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MessageId:                         messageId,
		MessageType:                       messageType,
		PublisherId:                       publisherId,
		DataSetWriterId:                   dataSetWriterId,
		WriterGroupName:                   writerGroupName,
		DataSetWriterName:                 dataSetWriterName,
		Timestamp:                         timestamp,
		MetaData:                          metaData,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonDataSetMetaDataMessageBuilder is a builder for JsonDataSetMetaDataMessage
type JsonDataSetMetaDataMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, dataSetWriterId uint16, writerGroupName PascalString, dataSetWriterName PascalString, timestamp int64, metaData DataSetMetaDataType) JsonDataSetMetaDataMessageBuilder
	// WithMessageId adds MessageId (property field)
	WithMessageId(PascalString) JsonDataSetMetaDataMessageBuilder
	// WithMessageIdBuilder adds MessageId (property field) which is build by the builder
	WithMessageIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonDataSetMetaDataMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(PascalString) JsonDataSetMetaDataMessageBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder
	// WithDataSetWriterId adds DataSetWriterId (property field)
	WithDataSetWriterId(uint16) JsonDataSetMetaDataMessageBuilder
	// WithWriterGroupName adds WriterGroupName (property field)
	WithWriterGroupName(PascalString) JsonDataSetMetaDataMessageBuilder
	// WithWriterGroupNameBuilder adds WriterGroupName (property field) which is build by the builder
	WithWriterGroupNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder
	// WithDataSetWriterName adds DataSetWriterName (property field)
	WithDataSetWriterName(PascalString) JsonDataSetMetaDataMessageBuilder
	// WithDataSetWriterNameBuilder adds DataSetWriterName (property field) which is build by the builder
	WithDataSetWriterNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonDataSetMetaDataMessageBuilder
	// WithMetaData adds MetaData (property field)
	WithMetaData(DataSetMetaDataType) JsonDataSetMetaDataMessageBuilder
	// WithMetaDataBuilder adds MetaData (property field) which is build by the builder
	WithMetaDataBuilder(func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) JsonDataSetMetaDataMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonDataSetMetaDataMessage or returns an error if something is wrong
	Build() (JsonDataSetMetaDataMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonDataSetMetaDataMessage
}

// NewJsonDataSetMetaDataMessageBuilder() creates a JsonDataSetMetaDataMessageBuilder
func NewJsonDataSetMetaDataMessageBuilder() JsonDataSetMetaDataMessageBuilder {
	return &_JsonDataSetMetaDataMessageBuilder{_JsonDataSetMetaDataMessage: new(_JsonDataSetMetaDataMessage)}
}

type _JsonDataSetMetaDataMessageBuilder struct {
	*_JsonDataSetMetaDataMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (JsonDataSetMetaDataMessageBuilder) = (*_JsonDataSetMetaDataMessageBuilder)(nil)

func (b *_JsonDataSetMetaDataMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonDataSetMetaDataMessage
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, dataSetWriterId uint16, writerGroupName PascalString, dataSetWriterName PascalString, timestamp int64, metaData DataSetMetaDataType) JsonDataSetMetaDataMessageBuilder {
	return b.WithMessageId(messageId).WithMessageType(messageType).WithPublisherId(publisherId).WithDataSetWriterId(dataSetWriterId).WithWriterGroupName(writerGroupName).WithDataSetWriterName(dataSetWriterName).WithTimestamp(timestamp).WithMetaData(metaData)
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithMessageId(messageId PascalString) JsonDataSetMetaDataMessageBuilder {
	b.MessageId = messageId
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithMessageIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder {
	builder := builderSupplier(b.MessageId.CreatePascalStringBuilder())
	var err error
	b.MessageId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithMessageType(messageType PascalString) JsonDataSetMetaDataMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithPublisherId(publisherId PascalString) JsonDataSetMetaDataMessageBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithPublisherIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder {
	builder := builderSupplier(b.PublisherId.CreatePascalStringBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithDataSetWriterId(dataSetWriterId uint16) JsonDataSetMetaDataMessageBuilder {
	b.DataSetWriterId = dataSetWriterId
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithWriterGroupName(writerGroupName PascalString) JsonDataSetMetaDataMessageBuilder {
	b.WriterGroupName = writerGroupName
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithWriterGroupNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder {
	builder := builderSupplier(b.WriterGroupName.CreatePascalStringBuilder())
	var err error
	b.WriterGroupName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithDataSetWriterName(dataSetWriterName PascalString) JsonDataSetMetaDataMessageBuilder {
	b.DataSetWriterName = dataSetWriterName
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithDataSetWriterNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMetaDataMessageBuilder {
	builder := builderSupplier(b.DataSetWriterName.CreatePascalStringBuilder())
	var err error
	b.DataSetWriterName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithTimestamp(timestamp int64) JsonDataSetMetaDataMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithMetaData(metaData DataSetMetaDataType) JsonDataSetMetaDataMessageBuilder {
	b.MetaData = metaData
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) WithMetaDataBuilder(builderSupplier func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) JsonDataSetMetaDataMessageBuilder {
	builder := builderSupplier(b.MetaData.CreateDataSetMetaDataTypeBuilder())
	var err error
	b.MetaData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "DataSetMetaDataTypeBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMetaDataMessageBuilder) Build() (JsonDataSetMetaDataMessage, error) {
	if b.MessageId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageId' not set"))
	}
	if b.MessageType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'messageType' not set"))
	}
	if b.PublisherId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'publisherId' not set"))
	}
	if b.WriterGroupName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'writerGroupName' not set"))
	}
	if b.DataSetWriterName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dataSetWriterName' not set"))
	}
	if b.MetaData == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'metaData' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._JsonDataSetMetaDataMessage.deepCopy(), nil
}

func (b *_JsonDataSetMetaDataMessageBuilder) MustBuild() JsonDataSetMetaDataMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonDataSetMetaDataMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonDataSetMetaDataMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonDataSetMetaDataMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonDataSetMetaDataMessageBuilder().(*_JsonDataSetMetaDataMessageBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateJsonDataSetMetaDataMessageBuilder creates a JsonDataSetMetaDataMessageBuilder
func (b *_JsonDataSetMetaDataMessage) CreateJsonDataSetMetaDataMessageBuilder() JsonDataSetMetaDataMessageBuilder {
	if b == nil {
		return NewJsonDataSetMetaDataMessageBuilder()
	}
	return &_JsonDataSetMetaDataMessageBuilder{_JsonDataSetMetaDataMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonDataSetMetaDataMessage) GetExtensionId() int32 {
	return int32(19315)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonDataSetMetaDataMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonDataSetMetaDataMessage) GetMessageId() PascalString {
	return m.MessageId
}

func (m *_JsonDataSetMetaDataMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonDataSetMetaDataMessage) GetPublisherId() PascalString {
	return m.PublisherId
}

func (m *_JsonDataSetMetaDataMessage) GetDataSetWriterId() uint16 {
	return m.DataSetWriterId
}

func (m *_JsonDataSetMetaDataMessage) GetWriterGroupName() PascalString {
	return m.WriterGroupName
}

func (m *_JsonDataSetMetaDataMessage) GetDataSetWriterName() PascalString {
	return m.DataSetWriterName
}

func (m *_JsonDataSetMetaDataMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonDataSetMetaDataMessage) GetMetaData() DataSetMetaDataType {
	return m.MetaData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonDataSetMetaDataMessage(structType any) JsonDataSetMetaDataMessage {
	if casted, ok := structType.(JsonDataSetMetaDataMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonDataSetMetaDataMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonDataSetMetaDataMessage) GetTypeName() string {
	return "JsonDataSetMetaDataMessage"
}

func (m *_JsonDataSetMetaDataMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (messageId)
	lengthInBits += m.MessageId.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (dataSetWriterId)
	lengthInBits += 16

	// Simple field (writerGroupName)
	lengthInBits += m.WriterGroupName.GetLengthInBits(ctx)

	// Simple field (dataSetWriterName)
	lengthInBits += m.DataSetWriterName.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (metaData)
	lengthInBits += m.MetaData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_JsonDataSetMetaDataMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonDataSetMetaDataMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonDataSetMetaDataMessage JsonDataSetMetaDataMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonDataSetMetaDataMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonDataSetMetaDataMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageId, err := ReadSimpleField[PascalString](ctx, "messageId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageId' field"))
	}
	m.MessageId = messageId

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	publisherId, err := ReadSimpleField[PascalString](ctx, "publisherId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	dataSetWriterId, err := ReadSimpleField(ctx, "dataSetWriterId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterId' field"))
	}
	m.DataSetWriterId = dataSetWriterId

	writerGroupName, err := ReadSimpleField[PascalString](ctx, "writerGroupName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writerGroupName' field"))
	}
	m.WriterGroupName = writerGroupName

	dataSetWriterName, err := ReadSimpleField[PascalString](ctx, "dataSetWriterName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterName' field"))
	}
	m.DataSetWriterName = dataSetWriterName

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	metaData, err := ReadSimpleField[DataSetMetaDataType](ctx, "metaData", ReadComplex[DataSetMetaDataType](ExtensionObjectDefinitionParseWithBufferProducer[DataSetMetaDataType]((int32)(int32(14525))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'metaData' field"))
	}
	m.MetaData = metaData

	if closeErr := readBuffer.CloseContext("JsonDataSetMetaDataMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonDataSetMetaDataMessage")
	}

	return m, nil
}

func (m *_JsonDataSetMetaDataMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonDataSetMetaDataMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonDataSetMetaDataMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonDataSetMetaDataMessage")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageId", m.GetMessageId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "publisherId", m.GetPublisherId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[uint16](ctx, "dataSetWriterId", m.GetDataSetWriterId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "writerGroupName", m.GetWriterGroupName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'writerGroupName' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "dataSetWriterName", m.GetDataSetWriterName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterName' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[DataSetMetaDataType](ctx, "metaData", m.GetMetaData(), WriteComplex[DataSetMetaDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'metaData' field")
		}

		if popErr := writeBuffer.PopContext("JsonDataSetMetaDataMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonDataSetMetaDataMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonDataSetMetaDataMessage) IsJsonDataSetMetaDataMessage() {}

func (m *_JsonDataSetMetaDataMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonDataSetMetaDataMessage) deepCopy() *_JsonDataSetMetaDataMessage {
	if m == nil {
		return nil
	}
	_JsonDataSetMetaDataMessageCopy := &_JsonDataSetMetaDataMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.MessageId),
		utils.DeepCopy[PascalString](m.MessageType),
		utils.DeepCopy[PascalString](m.PublisherId),
		m.DataSetWriterId,
		utils.DeepCopy[PascalString](m.WriterGroupName),
		utils.DeepCopy[PascalString](m.DataSetWriterName),
		m.Timestamp,
		utils.DeepCopy[DataSetMetaDataType](m.MetaData),
	}
	_JsonDataSetMetaDataMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonDataSetMetaDataMessageCopy
}

func (m *_JsonDataSetMetaDataMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
