/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetEventParameterChangeOfLifeSavety extends BACnetEventParameter
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetOpeningTag openingTag;
  protected final BACnetContextTagUnsignedInteger timeDelay;
  protected final BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues
      listOfLifeSavetyAlarmValues;
  protected final BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues listOfAlarmValues;
  protected final BACnetDeviceObjectPropertyReferenceEnclosed modePropertyReference;
  protected final BACnetClosingTag closingTag;

  public BACnetEventParameterChangeOfLifeSavety(
      BACnetTagHeader peekedTagHeader,
      BACnetOpeningTag openingTag,
      BACnetContextTagUnsignedInteger timeDelay,
      BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues listOfLifeSavetyAlarmValues,
      BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues listOfAlarmValues,
      BACnetDeviceObjectPropertyReferenceEnclosed modePropertyReference,
      BACnetClosingTag closingTag) {
    super(peekedTagHeader);
    this.openingTag = openingTag;
    this.timeDelay = timeDelay;
    this.listOfLifeSavetyAlarmValues = listOfLifeSavetyAlarmValues;
    this.listOfAlarmValues = listOfAlarmValues;
    this.modePropertyReference = modePropertyReference;
    this.closingTag = closingTag;
  }

  public BACnetOpeningTag getOpeningTag() {
    return openingTag;
  }

  public BACnetContextTagUnsignedInteger getTimeDelay() {
    return timeDelay;
  }

  public BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues
      getListOfLifeSavetyAlarmValues() {
    return listOfLifeSavetyAlarmValues;
  }

  public BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues getListOfAlarmValues() {
    return listOfAlarmValues;
  }

  public BACnetDeviceObjectPropertyReferenceEnclosed getModePropertyReference() {
    return modePropertyReference;
  }

  public BACnetClosingTag getClosingTag() {
    return closingTag;
  }

  @Override
  protected void serializeBACnetEventParameterChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetEventParameterChangeOfLifeSavety");

    // Simple Field (openingTag)
    writeSimpleField("openingTag", openingTag, writeComplex(writeBuffer));

    // Simple Field (timeDelay)
    writeSimpleField("timeDelay", timeDelay, writeComplex(writeBuffer));

    // Simple Field (listOfLifeSavetyAlarmValues)
    writeSimpleField(
        "listOfLifeSavetyAlarmValues", listOfLifeSavetyAlarmValues, writeComplex(writeBuffer));

    // Simple Field (listOfAlarmValues)
    writeSimpleField("listOfAlarmValues", listOfAlarmValues, writeComplex(writeBuffer));

    // Simple Field (modePropertyReference)
    writeSimpleField("modePropertyReference", modePropertyReference, writeComplex(writeBuffer));

    // Simple Field (closingTag)
    writeSimpleField("closingTag", closingTag, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetEventParameterChangeOfLifeSavety");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetEventParameterChangeOfLifeSavety _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (openingTag)
    lengthInBits += openingTag.getLengthInBits();

    // Simple field (timeDelay)
    lengthInBits += timeDelay.getLengthInBits();

    // Simple field (listOfLifeSavetyAlarmValues)
    lengthInBits += listOfLifeSavetyAlarmValues.getLengthInBits();

    // Simple field (listOfAlarmValues)
    lengthInBits += listOfAlarmValues.getLengthInBits();

    // Simple field (modePropertyReference)
    lengthInBits += modePropertyReference.getLengthInBits();

    // Simple field (closingTag)
    lengthInBits += closingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetEventParameterBuilder staticParseBACnetEventParameterBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetEventParameterChangeOfLifeSavety");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag openingTag =
        readSimpleField(
            "openingTag",
            readComplex(() -> BACnetOpeningTag.staticParse(readBuffer, (short) (8)), readBuffer));

    BACnetContextTagUnsignedInteger timeDelay =
        readSimpleField(
            "timeDelay",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues listOfLifeSavetyAlarmValues =
        readSimpleField(
            "listOfLifeSavetyAlarmValues",
            readComplex(
                () ->
                    BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues.staticParse(
                        readBuffer, (short) (1)),
                readBuffer));

    BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues listOfAlarmValues =
        readSimpleField(
            "listOfAlarmValues",
            readComplex(
                () ->
                    BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues.staticParse(
                        readBuffer, (short) (2)),
                readBuffer));

    BACnetDeviceObjectPropertyReferenceEnclosed modePropertyReference =
        readSimpleField(
            "modePropertyReference",
            readComplex(
                () ->
                    BACnetDeviceObjectPropertyReferenceEnclosed.staticParse(
                        readBuffer, (short) (4)),
                readBuffer));

    BACnetClosingTag closingTag =
        readSimpleField(
            "closingTag",
            readComplex(() -> BACnetClosingTag.staticParse(readBuffer, (short) (8)), readBuffer));

    readBuffer.closeContext("BACnetEventParameterChangeOfLifeSavety");
    // Create the instance
    return new BACnetEventParameterChangeOfLifeSavetyBuilderImpl(
        openingTag,
        timeDelay,
        listOfLifeSavetyAlarmValues,
        listOfAlarmValues,
        modePropertyReference,
        closingTag);
  }

  public static class BACnetEventParameterChangeOfLifeSavetyBuilderImpl
      implements BACnetEventParameter.BACnetEventParameterBuilder {
    private final BACnetOpeningTag openingTag;
    private final BACnetContextTagUnsignedInteger timeDelay;
    private final BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues
        listOfLifeSavetyAlarmValues;
    private final BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues listOfAlarmValues;
    private final BACnetDeviceObjectPropertyReferenceEnclosed modePropertyReference;
    private final BACnetClosingTag closingTag;

    public BACnetEventParameterChangeOfLifeSavetyBuilderImpl(
        BACnetOpeningTag openingTag,
        BACnetContextTagUnsignedInteger timeDelay,
        BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues
            listOfLifeSavetyAlarmValues,
        BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues listOfAlarmValues,
        BACnetDeviceObjectPropertyReferenceEnclosed modePropertyReference,
        BACnetClosingTag closingTag) {
      this.openingTag = openingTag;
      this.timeDelay = timeDelay;
      this.listOfLifeSavetyAlarmValues = listOfLifeSavetyAlarmValues;
      this.listOfAlarmValues = listOfAlarmValues;
      this.modePropertyReference = modePropertyReference;
      this.closingTag = closingTag;
    }

    public BACnetEventParameterChangeOfLifeSavety build(BACnetTagHeader peekedTagHeader) {
      BACnetEventParameterChangeOfLifeSavety bACnetEventParameterChangeOfLifeSavety =
          new BACnetEventParameterChangeOfLifeSavety(
              peekedTagHeader,
              openingTag,
              timeDelay,
              listOfLifeSavetyAlarmValues,
              listOfAlarmValues,
              modePropertyReference,
              closingTag);
      return bACnetEventParameterChangeOfLifeSavety;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetEventParameterChangeOfLifeSavety)) {
      return false;
    }
    BACnetEventParameterChangeOfLifeSavety that = (BACnetEventParameterChangeOfLifeSavety) o;
    return (getOpeningTag() == that.getOpeningTag())
        && (getTimeDelay() == that.getTimeDelay())
        && (getListOfLifeSavetyAlarmValues() == that.getListOfLifeSavetyAlarmValues())
        && (getListOfAlarmValues() == that.getListOfAlarmValues())
        && (getModePropertyReference() == that.getModePropertyReference())
        && (getClosingTag() == that.getClosingTag())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getOpeningTag(),
        getTimeDelay(),
        getListOfLifeSavetyAlarmValues(),
        getListOfAlarmValues(),
        getModePropertyReference(),
        getClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
