/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DataSetReaderDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15625;
  }

  // Properties.
  protected final PascalString name;
  protected final boolean enabled;
  protected final Variant publisherId;
  protected final int writerGroupId;
  protected final int dataSetWriterId;
  protected final DataSetMetaDataType dataSetMetaData;
  protected final DataSetFieldContentMask dataSetFieldContentMask;
  protected final double messageReceiveTimeout;
  protected final long keyFrameCount;
  protected final PascalString headerLayoutUri;
  protected final MessageSecurityMode securityMode;
  protected final PascalString securityGroupId;
  protected final List<EndpointDescription> securityKeyServices;
  protected final List<KeyValuePair> dataSetReaderProperties;
  protected final ExtensionObject transportSettings;
  protected final ExtensionObject messageSettings;
  protected final ExtensionObject subscribedDataSet;

  public DataSetReaderDataType(
      PascalString name,
      boolean enabled,
      Variant publisherId,
      int writerGroupId,
      int dataSetWriterId,
      DataSetMetaDataType dataSetMetaData,
      DataSetFieldContentMask dataSetFieldContentMask,
      double messageReceiveTimeout,
      long keyFrameCount,
      PascalString headerLayoutUri,
      MessageSecurityMode securityMode,
      PascalString securityGroupId,
      List<EndpointDescription> securityKeyServices,
      List<KeyValuePair> dataSetReaderProperties,
      ExtensionObject transportSettings,
      ExtensionObject messageSettings,
      ExtensionObject subscribedDataSet) {
    super();
    this.name = name;
    this.enabled = enabled;
    this.publisherId = publisherId;
    this.writerGroupId = writerGroupId;
    this.dataSetWriterId = dataSetWriterId;
    this.dataSetMetaData = dataSetMetaData;
    this.dataSetFieldContentMask = dataSetFieldContentMask;
    this.messageReceiveTimeout = messageReceiveTimeout;
    this.keyFrameCount = keyFrameCount;
    this.headerLayoutUri = headerLayoutUri;
    this.securityMode = securityMode;
    this.securityGroupId = securityGroupId;
    this.securityKeyServices = securityKeyServices;
    this.dataSetReaderProperties = dataSetReaderProperties;
    this.transportSettings = transportSettings;
    this.messageSettings = messageSettings;
    this.subscribedDataSet = subscribedDataSet;
  }

  public PascalString getName() {
    return name;
  }

  public boolean getEnabled() {
    return enabled;
  }

  public Variant getPublisherId() {
    return publisherId;
  }

  public int getWriterGroupId() {
    return writerGroupId;
  }

  public int getDataSetWriterId() {
    return dataSetWriterId;
  }

  public DataSetMetaDataType getDataSetMetaData() {
    return dataSetMetaData;
  }

  public DataSetFieldContentMask getDataSetFieldContentMask() {
    return dataSetFieldContentMask;
  }

  public double getMessageReceiveTimeout() {
    return messageReceiveTimeout;
  }

  public long getKeyFrameCount() {
    return keyFrameCount;
  }

  public PascalString getHeaderLayoutUri() {
    return headerLayoutUri;
  }

  public MessageSecurityMode getSecurityMode() {
    return securityMode;
  }

  public PascalString getSecurityGroupId() {
    return securityGroupId;
  }

  public List<EndpointDescription> getSecurityKeyServices() {
    return securityKeyServices;
  }

  public List<KeyValuePair> getDataSetReaderProperties() {
    return dataSetReaderProperties;
  }

  public ExtensionObject getTransportSettings() {
    return transportSettings;
  }

  public ExtensionObject getMessageSettings() {
    return messageSettings;
  }

  public ExtensionObject getSubscribedDataSet() {
    return subscribedDataSet;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DataSetReaderDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (enabled)
    writeSimpleField("enabled", enabled, writeBoolean(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (writerGroupId)
    writeSimpleField("writerGroupId", writerGroupId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dataSetWriterId)
    writeSimpleField("dataSetWriterId", dataSetWriterId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (dataSetMetaData)
    writeSimpleField("dataSetMetaData", dataSetMetaData, writeComplex(writeBuffer));

    // Simple Field (dataSetFieldContentMask)
    writeSimpleEnumField(
        "dataSetFieldContentMask",
        "DataSetFieldContentMask",
        dataSetFieldContentMask,
        writeEnum(
            DataSetFieldContentMask::getValue,
            DataSetFieldContentMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (messageReceiveTimeout)
    writeSimpleField("messageReceiveTimeout", messageReceiveTimeout, writeDouble(writeBuffer, 64));

    // Simple Field (keyFrameCount)
    writeSimpleField("keyFrameCount", keyFrameCount, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (headerLayoutUri)
    writeSimpleField("headerLayoutUri", headerLayoutUri, writeComplex(writeBuffer));

    // Simple Field (securityMode)
    writeSimpleEnumField(
        "securityMode",
        "MessageSecurityMode",
        securityMode,
        writeEnum(
            MessageSecurityMode::getValue,
            MessageSecurityMode::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (securityGroupId)
    writeSimpleField("securityGroupId", securityGroupId, writeComplex(writeBuffer));

    // Implicit Field (noOfSecurityKeyServices) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfSecurityKeyServices =
        (int) ((((getSecurityKeyServices()) == (null)) ? -(1) : COUNT(getSecurityKeyServices())));
    writeImplicitField(
        "noOfSecurityKeyServices", noOfSecurityKeyServices, writeSignedInt(writeBuffer, 32));

    // Array Field (securityKeyServices)
    writeComplexTypeArrayField("securityKeyServices", securityKeyServices, writeBuffer);

    // Implicit Field (noOfDataSetReaderProperties) (Used for parsing, but its value is not stored
    // as it's implicitly given by the objects content)
    int noOfDataSetReaderProperties =
        (int)
            ((((getDataSetReaderProperties()) == (null))
                ? -(1)
                : COUNT(getDataSetReaderProperties())));
    writeImplicitField(
        "noOfDataSetReaderProperties",
        noOfDataSetReaderProperties,
        writeSignedInt(writeBuffer, 32));

    // Array Field (dataSetReaderProperties)
    writeComplexTypeArrayField("dataSetReaderProperties", dataSetReaderProperties, writeBuffer);

    // Simple Field (transportSettings)
    writeSimpleField("transportSettings", transportSettings, writeComplex(writeBuffer));

    // Simple Field (messageSettings)
    writeSimpleField("messageSettings", messageSettings, writeComplex(writeBuffer));

    // Simple Field (subscribedDataSet)
    writeSimpleField("subscribedDataSet", subscribedDataSet, writeComplex(writeBuffer));

    writeBuffer.popContext("DataSetReaderDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DataSetReaderDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (enabled)
    lengthInBits += 1;

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (writerGroupId)
    lengthInBits += 16;

    // Simple field (dataSetWriterId)
    lengthInBits += 16;

    // Simple field (dataSetMetaData)
    lengthInBits += dataSetMetaData.getLengthInBits();

    // Simple field (dataSetFieldContentMask)
    lengthInBits += 32;

    // Simple field (messageReceiveTimeout)
    lengthInBits += 64;

    // Simple field (keyFrameCount)
    lengthInBits += 32;

    // Simple field (headerLayoutUri)
    lengthInBits += headerLayoutUri.getLengthInBits();

    // Simple field (securityMode)
    lengthInBits += 32;

    // Simple field (securityGroupId)
    lengthInBits += securityGroupId.getLengthInBits();

    // Implicit Field (noOfSecurityKeyServices)
    lengthInBits += 32;

    // Array field
    if (securityKeyServices != null) {
      int i = 0;
      for (EndpointDescription element : securityKeyServices) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securityKeyServices.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDataSetReaderProperties)
    lengthInBits += 32;

    // Array field
    if (dataSetReaderProperties != null) {
      int i = 0;
      for (KeyValuePair element : dataSetReaderProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataSetReaderProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (transportSettings)
    lengthInBits += transportSettings.getLengthInBits();

    // Simple field (messageSettings)
    lengthInBits += messageSettings.getLengthInBits();

    // Simple field (subscribedDataSet)
    lengthInBits += subscribedDataSet.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("DataSetReaderDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean enabled = readSimpleField("enabled", readBoolean(readBuffer));

    Variant publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> Variant.staticParse(readBuffer), readBuffer));

    int writerGroupId = readSimpleField("writerGroupId", readUnsignedInt(readBuffer, 16));

    int dataSetWriterId = readSimpleField("dataSetWriterId", readUnsignedInt(readBuffer, 16));

    DataSetMetaDataType dataSetMetaData =
        readSimpleField(
            "dataSetMetaData",
            readComplex(
                () ->
                    (DataSetMetaDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (14525)),
                readBuffer));

    DataSetFieldContentMask dataSetFieldContentMask =
        readEnumField(
            "dataSetFieldContentMask",
            "DataSetFieldContentMask",
            readEnum(DataSetFieldContentMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    double messageReceiveTimeout =
        readSimpleField("messageReceiveTimeout", readDouble(readBuffer, 64));

    long keyFrameCount = readSimpleField("keyFrameCount", readUnsignedLong(readBuffer, 32));

    PascalString headerLayoutUri =
        readSimpleField(
            "headerLayoutUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    MessageSecurityMode securityMode =
        readEnumField(
            "securityMode",
            "MessageSecurityMode",
            readEnum(MessageSecurityMode::enumForValue, readUnsignedLong(readBuffer, 32)));

    PascalString securityGroupId =
        readSimpleField(
            "securityGroupId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfSecurityKeyServices =
        readImplicitField("noOfSecurityKeyServices", readSignedInt(readBuffer, 32));

    List<EndpointDescription> securityKeyServices =
        readCountArrayField(
            "securityKeyServices",
            readComplex(
                () ->
                    (EndpointDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (314)),
                readBuffer),
            noOfSecurityKeyServices);

    int noOfDataSetReaderProperties =
        readImplicitField("noOfDataSetReaderProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> dataSetReaderProperties =
        readCountArrayField(
            "dataSetReaderProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfDataSetReaderProperties);

    ExtensionObject transportSettings =
        readSimpleField(
            "transportSettings",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    ExtensionObject messageSettings =
        readSimpleField(
            "messageSettings",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    ExtensionObject subscribedDataSet =
        readSimpleField(
            "subscribedDataSet",
            readComplex(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    readBuffer.closeContext("DataSetReaderDataType");
    // Create the instance
    return new DataSetReaderDataTypeBuilderImpl(
        name,
        enabled,
        publisherId,
        writerGroupId,
        dataSetWriterId,
        dataSetMetaData,
        dataSetFieldContentMask,
        messageReceiveTimeout,
        keyFrameCount,
        headerLayoutUri,
        securityMode,
        securityGroupId,
        securityKeyServices,
        dataSetReaderProperties,
        transportSettings,
        messageSettings,
        subscribedDataSet);
  }

  public static class DataSetReaderDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final boolean enabled;
    private final Variant publisherId;
    private final int writerGroupId;
    private final int dataSetWriterId;
    private final DataSetMetaDataType dataSetMetaData;
    private final DataSetFieldContentMask dataSetFieldContentMask;
    private final double messageReceiveTimeout;
    private final long keyFrameCount;
    private final PascalString headerLayoutUri;
    private final MessageSecurityMode securityMode;
    private final PascalString securityGroupId;
    private final List<EndpointDescription> securityKeyServices;
    private final List<KeyValuePair> dataSetReaderProperties;
    private final ExtensionObject transportSettings;
    private final ExtensionObject messageSettings;
    private final ExtensionObject subscribedDataSet;

    public DataSetReaderDataTypeBuilderImpl(
        PascalString name,
        boolean enabled,
        Variant publisherId,
        int writerGroupId,
        int dataSetWriterId,
        DataSetMetaDataType dataSetMetaData,
        DataSetFieldContentMask dataSetFieldContentMask,
        double messageReceiveTimeout,
        long keyFrameCount,
        PascalString headerLayoutUri,
        MessageSecurityMode securityMode,
        PascalString securityGroupId,
        List<EndpointDescription> securityKeyServices,
        List<KeyValuePair> dataSetReaderProperties,
        ExtensionObject transportSettings,
        ExtensionObject messageSettings,
        ExtensionObject subscribedDataSet) {
      this.name = name;
      this.enabled = enabled;
      this.publisherId = publisherId;
      this.writerGroupId = writerGroupId;
      this.dataSetWriterId = dataSetWriterId;
      this.dataSetMetaData = dataSetMetaData;
      this.dataSetFieldContentMask = dataSetFieldContentMask;
      this.messageReceiveTimeout = messageReceiveTimeout;
      this.keyFrameCount = keyFrameCount;
      this.headerLayoutUri = headerLayoutUri;
      this.securityMode = securityMode;
      this.securityGroupId = securityGroupId;
      this.securityKeyServices = securityKeyServices;
      this.dataSetReaderProperties = dataSetReaderProperties;
      this.transportSettings = transportSettings;
      this.messageSettings = messageSettings;
      this.subscribedDataSet = subscribedDataSet;
    }

    public DataSetReaderDataType build() {
      DataSetReaderDataType dataSetReaderDataType =
          new DataSetReaderDataType(
              name,
              enabled,
              publisherId,
              writerGroupId,
              dataSetWriterId,
              dataSetMetaData,
              dataSetFieldContentMask,
              messageReceiveTimeout,
              keyFrameCount,
              headerLayoutUri,
              securityMode,
              securityGroupId,
              securityKeyServices,
              dataSetReaderProperties,
              transportSettings,
              messageSettings,
              subscribedDataSet);
      return dataSetReaderDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DataSetReaderDataType)) {
      return false;
    }
    DataSetReaderDataType that = (DataSetReaderDataType) o;
    return (getName() == that.getName())
        && (getEnabled() == that.getEnabled())
        && (getPublisherId() == that.getPublisherId())
        && (getWriterGroupId() == that.getWriterGroupId())
        && (getDataSetWriterId() == that.getDataSetWriterId())
        && (getDataSetMetaData() == that.getDataSetMetaData())
        && (getDataSetFieldContentMask() == that.getDataSetFieldContentMask())
        && (getMessageReceiveTimeout() == that.getMessageReceiveTimeout())
        && (getKeyFrameCount() == that.getKeyFrameCount())
        && (getHeaderLayoutUri() == that.getHeaderLayoutUri())
        && (getSecurityMode() == that.getSecurityMode())
        && (getSecurityGroupId() == that.getSecurityGroupId())
        && (getSecurityKeyServices() == that.getSecurityKeyServices())
        && (getDataSetReaderProperties() == that.getDataSetReaderProperties())
        && (getTransportSettings() == that.getTransportSettings())
        && (getMessageSettings() == that.getMessageSettings())
        && (getSubscribedDataSet() == that.getSubscribedDataSet())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getEnabled(),
        getPublisherId(),
        getWriterGroupId(),
        getDataSetWriterId(),
        getDataSetMetaData(),
        getDataSetFieldContentMask(),
        getMessageReceiveTimeout(),
        getKeyFrameCount(),
        getHeaderLayoutUri(),
        getSecurityMode(),
        getSecurityGroupId(),
        getSecurityKeyServices(),
        getDataSetReaderProperties(),
        getTransportSettings(),
        getMessageSettings(),
        getSubscribedDataSet());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
