/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class QuantityDimension extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 32440;
  }

  // Properties.
  protected final byte massExponent;
  protected final byte lengthExponent;
  protected final byte timeExponent;
  protected final byte electricCurrentExponent;
  protected final byte amountOfSubstanceExponent;
  protected final byte luminousIntensityExponent;
  protected final byte absoluteTemperatureExponent;
  protected final byte dimensionlessExponent;

  public QuantityDimension(
      byte massExponent,
      byte lengthExponent,
      byte timeExponent,
      byte electricCurrentExponent,
      byte amountOfSubstanceExponent,
      byte luminousIntensityExponent,
      byte absoluteTemperatureExponent,
      byte dimensionlessExponent) {
    super();
    this.massExponent = massExponent;
    this.lengthExponent = lengthExponent;
    this.timeExponent = timeExponent;
    this.electricCurrentExponent = electricCurrentExponent;
    this.amountOfSubstanceExponent = amountOfSubstanceExponent;
    this.luminousIntensityExponent = luminousIntensityExponent;
    this.absoluteTemperatureExponent = absoluteTemperatureExponent;
    this.dimensionlessExponent = dimensionlessExponent;
  }

  public byte getMassExponent() {
    return massExponent;
  }

  public byte getLengthExponent() {
    return lengthExponent;
  }

  public byte getTimeExponent() {
    return timeExponent;
  }

  public byte getElectricCurrentExponent() {
    return electricCurrentExponent;
  }

  public byte getAmountOfSubstanceExponent() {
    return amountOfSubstanceExponent;
  }

  public byte getLuminousIntensityExponent() {
    return luminousIntensityExponent;
  }

  public byte getAbsoluteTemperatureExponent() {
    return absoluteTemperatureExponent;
  }

  public byte getDimensionlessExponent() {
    return dimensionlessExponent;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("QuantityDimension");

    // Simple Field (massExponent)
    writeSimpleField("massExponent", massExponent, writeSignedByte(writeBuffer, 8));

    // Simple Field (lengthExponent)
    writeSimpleField("lengthExponent", lengthExponent, writeSignedByte(writeBuffer, 8));

    // Simple Field (timeExponent)
    writeSimpleField("timeExponent", timeExponent, writeSignedByte(writeBuffer, 8));

    // Simple Field (electricCurrentExponent)
    writeSimpleField(
        "electricCurrentExponent", electricCurrentExponent, writeSignedByte(writeBuffer, 8));

    // Simple Field (amountOfSubstanceExponent)
    writeSimpleField(
        "amountOfSubstanceExponent", amountOfSubstanceExponent, writeSignedByte(writeBuffer, 8));

    // Simple Field (luminousIntensityExponent)
    writeSimpleField(
        "luminousIntensityExponent", luminousIntensityExponent, writeSignedByte(writeBuffer, 8));

    // Simple Field (absoluteTemperatureExponent)
    writeSimpleField(
        "absoluteTemperatureExponent",
        absoluteTemperatureExponent,
        writeSignedByte(writeBuffer, 8));

    // Simple Field (dimensionlessExponent)
    writeSimpleField(
        "dimensionlessExponent", dimensionlessExponent, writeSignedByte(writeBuffer, 8));

    writeBuffer.popContext("QuantityDimension");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    QuantityDimension _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (massExponent)
    lengthInBits += 8;

    // Simple field (lengthExponent)
    lengthInBits += 8;

    // Simple field (timeExponent)
    lengthInBits += 8;

    // Simple field (electricCurrentExponent)
    lengthInBits += 8;

    // Simple field (amountOfSubstanceExponent)
    lengthInBits += 8;

    // Simple field (luminousIntensityExponent)
    lengthInBits += 8;

    // Simple field (absoluteTemperatureExponent)
    lengthInBits += 8;

    // Simple field (dimensionlessExponent)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("QuantityDimension");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte massExponent = readSimpleField("massExponent", readSignedByte(readBuffer, 8));

    byte lengthExponent = readSimpleField("lengthExponent", readSignedByte(readBuffer, 8));

    byte timeExponent = readSimpleField("timeExponent", readSignedByte(readBuffer, 8));

    byte electricCurrentExponent =
        readSimpleField("electricCurrentExponent", readSignedByte(readBuffer, 8));

    byte amountOfSubstanceExponent =
        readSimpleField("amountOfSubstanceExponent", readSignedByte(readBuffer, 8));

    byte luminousIntensityExponent =
        readSimpleField("luminousIntensityExponent", readSignedByte(readBuffer, 8));

    byte absoluteTemperatureExponent =
        readSimpleField("absoluteTemperatureExponent", readSignedByte(readBuffer, 8));

    byte dimensionlessExponent =
        readSimpleField("dimensionlessExponent", readSignedByte(readBuffer, 8));

    readBuffer.closeContext("QuantityDimension");
    // Create the instance
    return new QuantityDimensionBuilderImpl(
        massExponent,
        lengthExponent,
        timeExponent,
        electricCurrentExponent,
        amountOfSubstanceExponent,
        luminousIntensityExponent,
        absoluteTemperatureExponent,
        dimensionlessExponent);
  }

  public static class QuantityDimensionBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final byte massExponent;
    private final byte lengthExponent;
    private final byte timeExponent;
    private final byte electricCurrentExponent;
    private final byte amountOfSubstanceExponent;
    private final byte luminousIntensityExponent;
    private final byte absoluteTemperatureExponent;
    private final byte dimensionlessExponent;

    public QuantityDimensionBuilderImpl(
        byte massExponent,
        byte lengthExponent,
        byte timeExponent,
        byte electricCurrentExponent,
        byte amountOfSubstanceExponent,
        byte luminousIntensityExponent,
        byte absoluteTemperatureExponent,
        byte dimensionlessExponent) {
      this.massExponent = massExponent;
      this.lengthExponent = lengthExponent;
      this.timeExponent = timeExponent;
      this.electricCurrentExponent = electricCurrentExponent;
      this.amountOfSubstanceExponent = amountOfSubstanceExponent;
      this.luminousIntensityExponent = luminousIntensityExponent;
      this.absoluteTemperatureExponent = absoluteTemperatureExponent;
      this.dimensionlessExponent = dimensionlessExponent;
    }

    public QuantityDimension build() {
      QuantityDimension quantityDimension =
          new QuantityDimension(
              massExponent,
              lengthExponent,
              timeExponent,
              electricCurrentExponent,
              amountOfSubstanceExponent,
              luminousIntensityExponent,
              absoluteTemperatureExponent,
              dimensionlessExponent);
      return quantityDimension;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof QuantityDimension)) {
      return false;
    }
    QuantityDimension that = (QuantityDimension) o;
    return (getMassExponent() == that.getMassExponent())
        && (getLengthExponent() == that.getLengthExponent())
        && (getTimeExponent() == that.getTimeExponent())
        && (getElectricCurrentExponent() == that.getElectricCurrentExponent())
        && (getAmountOfSubstanceExponent() == that.getAmountOfSubstanceExponent())
        && (getLuminousIntensityExponent() == that.getLuminousIntensityExponent())
        && (getAbsoluteTemperatureExponent() == that.getAbsoluteTemperatureExponent())
        && (getDimensionlessExponent() == that.getDimensionlessExponent())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMassExponent(),
        getLengthExponent(),
        getTimeExponent(),
        getElectricCurrentExponent(),
        getAmountOfSubstanceExponent(),
        getLuminousIntensityExponent(),
        getAbsoluteTemperatureExponent(),
        getDimensionlessExponent());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
