/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleBigList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class DoubleMappedBigList
extends AbstractDoubleBigList {
    public static int LOG2_BYTES = 63 - Long.numberOfLeadingZeros(8L);
    @Deprecated
    public static int LOG2_BITS = 63 - Long.numberOfLeadingZeros(8L);
    private static int CHUNK_SHIFT = 30 - LOG2_BYTES;
    public static final long CHUNK_SIZE = 1L << CHUNK_SHIFT;
    private static final long CHUNK_MASK = CHUNK_SIZE - 1L;
    private final DoubleBuffer[] buffer;
    private final boolean[] readyToUse;
    private final int n;
    private final long size;

    protected DoubleMappedBigList(DoubleBuffer[] buffer, long size, boolean[] readyToUse) {
        this.buffer = buffer;
        this.n = buffer.length;
        this.size = size;
        this.readyToUse = readyToUse;
        for (int i = 0; i < this.n; ++i) {
            if (i >= this.n - 1 || (long)buffer[i].capacity() == CHUNK_SIZE) continue;
            throw new IllegalArgumentException();
        }
    }

    public static DoubleMappedBigList map(FileChannel fileChannel) throws IOException {
        return DoubleMappedBigList.map(fileChannel, ByteOrder.BIG_ENDIAN);
    }

    public static DoubleMappedBigList map(FileChannel fileChannel, ByteOrder byteOrder) throws IOException {
        return DoubleMappedBigList.map(fileChannel, byteOrder, FileChannel.MapMode.READ_ONLY);
    }

    public static DoubleMappedBigList map(FileChannel fileChannel, ByteOrder byteOrder, FileChannel.MapMode mapMode) throws IOException {
        long size = fileChannel.size() / 8L;
        int chunks = (int)((size + (CHUNK_SIZE - 1L)) / CHUNK_SIZE);
        DoubleBuffer[] buffer = new DoubleBuffer[chunks];
        for (int i = 0; i < chunks; ++i) {
            buffer[i] = fileChannel.map(mapMode, (long)i * CHUNK_SIZE * 8L, Math.min(CHUNK_SIZE, size - (long)i * CHUNK_SIZE) * 8L).order(byteOrder).asDoubleBuffer();
        }
        boolean[] readyToUse = new boolean[chunks];
        Arrays.fill(readyToUse, true);
        return new DoubleMappedBigList(buffer, size, readyToUse);
    }

    private DoubleBuffer DoubleBuffer(int n) {
        if (this.readyToUse[n]) {
            return this.buffer[n];
        }
        this.readyToUse[n] = true;
        this.buffer[n] = this.buffer[n].duplicate();
        return this.buffer[n];
    }

    public DoubleMappedBigList copy() {
        return new DoubleMappedBigList((DoubleBuffer[])this.buffer.clone(), this.size, new boolean[this.n]);
    }

    @Override
    public double getDouble(long index) {
        return this.DoubleBuffer((int)(index >>> CHUNK_SHIFT)).get((int)(index & CHUNK_MASK));
    }

    @Override
    public void getElements(long from, double[] a, int offset, int length) {
        int chunk = (int)(from >>> CHUNK_SHIFT);
        int displ = (int)(from & CHUNK_MASK);
        while (length > 0) {
            DoubleBuffer b = this.DoubleBuffer(chunk);
            int l = Math.min(b.capacity() - displ, length);
            if (l == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            b.position(displ);
            b.get(a, offset, l);
            if ((long)(displ += l) == CHUNK_SIZE) {
                displ = 0;
                ++chunk;
            }
            offset += l;
            length -= l;
        }
    }

    @Override
    public double set(long index, double value) {
        DoubleBuffer b = this.DoubleBuffer((int)(index >>> CHUNK_SHIFT));
        int i = (int)(index & CHUNK_MASK);
        double previousValue = b.get(i);
        b.put(i, value);
        return previousValue;
    }

    @Override
    public long size64() {
        return this.size;
    }
}

