/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import org.apache.qpid.transport.Acquired;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseOk;
import org.apache.qpid.transport.ConnectionHeartbeat;
import org.apache.qpid.transport.ConnectionOpen;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.ConnectionRedirect;
import org.apache.qpid.transport.ConnectionSecure;
import org.apache.qpid.transport.ConnectionSecureOk;
import org.apache.qpid.transport.ConnectionStart;
import org.apache.qpid.transport.ConnectionStartOk;
import org.apache.qpid.transport.ConnectionTune;
import org.apache.qpid.transport.ConnectionTuneOk;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.DtxCommit;
import org.apache.qpid.transport.DtxEnd;
import org.apache.qpid.transport.DtxForget;
import org.apache.qpid.transport.DtxGetTimeout;
import org.apache.qpid.transport.DtxPrepare;
import org.apache.qpid.transport.DtxRecover;
import org.apache.qpid.transport.DtxRollback;
import org.apache.qpid.transport.DtxSelect;
import org.apache.qpid.transport.DtxSetTimeout;
import org.apache.qpid.transport.DtxStart;
import org.apache.qpid.transport.ExchangeBind;
import org.apache.qpid.transport.ExchangeBound;
import org.apache.qpid.transport.ExchangeBoundResult;
import org.apache.qpid.transport.ExchangeDeclare;
import org.apache.qpid.transport.ExchangeDelete;
import org.apache.qpid.transport.ExchangeQuery;
import org.apache.qpid.transport.ExchangeQueryResult;
import org.apache.qpid.transport.ExchangeUnbind;
import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.ExecutionResult;
import org.apache.qpid.transport.ExecutionSync;
import org.apache.qpid.transport.FragmentProperties;
import org.apache.qpid.transport.GetTimeoutResult;
import org.apache.qpid.transport.MessageAccept;
import org.apache.qpid.transport.MessageAcquire;
import org.apache.qpid.transport.MessageCancel;
import org.apache.qpid.transport.MessageFlow;
import org.apache.qpid.transport.MessageFlush;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageReject;
import org.apache.qpid.transport.MessageRelease;
import org.apache.qpid.transport.MessageResume;
import org.apache.qpid.transport.MessageResumeResult;
import org.apache.qpid.transport.MessageSetFlowMode;
import org.apache.qpid.transport.MessageStop;
import org.apache.qpid.transport.MessageSubscribe;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.QueueDeclare;
import org.apache.qpid.transport.QueueDelete;
import org.apache.qpid.transport.QueuePurge;
import org.apache.qpid.transport.QueueQuery;
import org.apache.qpid.transport.QueueQueryResult;
import org.apache.qpid.transport.RecoverResult;
import org.apache.qpid.transport.ReplyTo;
import org.apache.qpid.transport.SessionAttach;
import org.apache.qpid.transport.SessionAttached;
import org.apache.qpid.transport.SessionCommandFragment;
import org.apache.qpid.transport.SessionCommandPoint;
import org.apache.qpid.transport.SessionCompleted;
import org.apache.qpid.transport.SessionConfirmed;
import org.apache.qpid.transport.SessionDetach;
import org.apache.qpid.transport.SessionDetached;
import org.apache.qpid.transport.SessionExpected;
import org.apache.qpid.transport.SessionFlush;
import org.apache.qpid.transport.SessionGap;
import org.apache.qpid.transport.SessionHeader;
import org.apache.qpid.transport.SessionKnownCompleted;
import org.apache.qpid.transport.SessionRequestTimeout;
import org.apache.qpid.transport.SessionTimeout;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.TxCommit;
import org.apache.qpid.transport.TxRollback;
import org.apache.qpid.transport.TxSelect;
import org.apache.qpid.transport.XaResult;
import org.apache.qpid.transport.Xid;

class StructFactory {
    StructFactory() {
    }

    public static Struct create(int type) {
        switch (type) {
            case -1: {
                return new SessionHeader();
            }
            case -2: {
                return new SessionCommandFragment();
            }
            case 1025: {
                return new DeliveryProperties();
            }
            case 1026: {
                return new FragmentProperties();
            }
            case -3: {
                return new ReplyTo();
            }
            case 1027: {
                return new MessageProperties();
            }
            case 1537: {
                return new XaResult();
            }
            case 1540: {
                return new Xid();
            }
            case 1028: {
                return new Acquired();
            }
            case 1029: {
                return new MessageResumeResult();
            }
            case 1538: {
                return new GetTimeoutResult();
            }
            case 1539: {
                return new RecoverResult();
            }
            case 1793: {
                return new ExchangeQueryResult();
            }
            case 1794: {
                return new ExchangeBoundResult();
            }
            case 2049: {
                return new QueueQueryResult();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static Struct createInstruction(int type) {
        switch (type) {
            case 257: {
                return new ConnectionStart();
            }
            case 258: {
                return new ConnectionStartOk();
            }
            case 259: {
                return new ConnectionSecure();
            }
            case 260: {
                return new ConnectionSecureOk();
            }
            case 261: {
                return new ConnectionTune();
            }
            case 262: {
                return new ConnectionTuneOk();
            }
            case 263: {
                return new ConnectionOpen();
            }
            case 264: {
                return new ConnectionOpenOk();
            }
            case 265: {
                return new ConnectionRedirect();
            }
            case 266: {
                return new ConnectionHeartbeat(new Option[0]);
            }
            case 267: {
                return new ConnectionClose();
            }
            case 268: {
                return new ConnectionCloseOk(new Option[0]);
            }
            case 513: {
                return new SessionAttach();
            }
            case 514: {
                return new SessionAttached();
            }
            case 515: {
                return new SessionDetach();
            }
            case 516: {
                return new SessionDetached();
            }
            case 517: {
                return new SessionRequestTimeout();
            }
            case 518: {
                return new SessionTimeout();
            }
            case 519: {
                return new SessionCommandPoint();
            }
            case 520: {
                return new SessionExpected();
            }
            case 521: {
                return new SessionConfirmed();
            }
            case 522: {
                return new SessionCompleted();
            }
            case 523: {
                return new SessionKnownCompleted();
            }
            case 524: {
                return new SessionFlush();
            }
            case 525: {
                return new SessionGap();
            }
            case 769: {
                return new ExecutionSync(new Option[0]);
            }
            case 770: {
                return new ExecutionResult();
            }
            case 771: {
                return new ExecutionException();
            }
            case 1025: {
                return new MessageTransfer();
            }
            case 1026: {
                return new MessageAccept();
            }
            case 1027: {
                return new MessageReject();
            }
            case 1028: {
                return new MessageRelease();
            }
            case 1029: {
                return new MessageAcquire();
            }
            case 1030: {
                return new MessageResume();
            }
            case 1031: {
                return new MessageSubscribe();
            }
            case 1032: {
                return new MessageCancel();
            }
            case 1033: {
                return new MessageSetFlowMode();
            }
            case 1034: {
                return new MessageFlow();
            }
            case 1035: {
                return new MessageFlush();
            }
            case 1036: {
                return new MessageStop();
            }
            case 1281: {
                return new TxSelect(new Option[0]);
            }
            case 1282: {
                return new TxCommit(new Option[0]);
            }
            case 1283: {
                return new TxRollback(new Option[0]);
            }
            case 1537: {
                return new DtxSelect(new Option[0]);
            }
            case 1538: {
                return new DtxStart();
            }
            case 1539: {
                return new DtxEnd();
            }
            case 1540: {
                return new DtxCommit();
            }
            case 1541: {
                return new DtxForget();
            }
            case 1542: {
                return new DtxGetTimeout();
            }
            case 1543: {
                return new DtxPrepare();
            }
            case 1544: {
                return new DtxRecover(new Option[0]);
            }
            case 1545: {
                return new DtxRollback();
            }
            case 1546: {
                return new DtxSetTimeout();
            }
            case 1793: {
                return new ExchangeDeclare();
            }
            case 1794: {
                return new ExchangeDelete();
            }
            case 1795: {
                return new ExchangeQuery();
            }
            case 1796: {
                return new ExchangeBind();
            }
            case 1797: {
                return new ExchangeUnbind();
            }
            case 1798: {
                return new ExchangeBound();
            }
            case 2049: {
                return new QueueDeclare();
            }
            case 2050: {
                return new QueueDelete();
            }
            case 2051: {
                return new QueuePurge();
            }
            case 2052: {
                return new QueueQuery();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }
}

