/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.qpid.transport.ExceptionHandlingByteBufferReceiver;
import org.apache.qpid.transport.FrameSizeObserver;
import org.apache.qpid.transport.NetworkEventReceiver;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.SegmentType;
import org.apache.qpid.transport.network.Frame;
import org.apache.qpid.transport.util.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputHandler
implements ExceptionHandlingByteBufferReceiver,
FrameSizeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputHandler.class);
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);
    private int _maxFrameSize = 4096;
    private final NetworkEventReceiver receiver;
    private State state;
    private ByteBuffer input = null;
    private int needed;
    private byte flags;
    private SegmentType type;
    private byte track;
    private int channel;

    public InputHandler(NetworkEventReceiver receiver) {
        this.receiver = receiver;
        this.state = State.PROTO_HDR;
        switch (this.state) {
            case PROTO_HDR: {
                this.needed = 8;
                break;
            }
            case FRAME_HDR: {
                this.needed = 12;
            }
        }
    }

    @Override
    public void setMaxFrameSize(int maxFrameSize) {
        this._maxFrameSize = maxFrameSize;
    }

    private void error(String fmt, Object ... args) {
        this.receiver.received(new ProtocolError(0, fmt, args));
    }

    @Override
    public void received(ByteBuffer buf) {
        int limit = buf.limit();
        int remaining = buf.remaining();
        while (remaining > 0) {
            if (remaining >= this.needed) {
                int consumed = this.needed;
                int pos = buf.position();
                if (this.input == null) {
                    buf.limit(pos + this.needed);
                    this.input = buf;
                    this.state = this.next(pos);
                    buf.limit(limit);
                    buf.position(pos + consumed);
                } else {
                    buf.limit(pos + this.needed);
                    this.input.put(buf);
                    buf.limit(limit);
                    this.input.flip();
                    this.state = this.next(0);
                }
                remaining -= consumed;
                this.input = null;
                continue;
            }
            if (this.input == null) {
                this.input = ByteBuffer.allocate(this.needed);
            }
            this.input.put(buf);
            this.needed -= remaining;
            remaining = 0;
        }
    }

    private State next(int pos) {
        this.input.order(ByteOrder.BIG_ENDIAN);
        switch (this.state) {
            case PROTO_HDR: {
                if (this.input.get(pos) != 65 && this.input.get(pos + 1) != 77 && this.input.get(pos + 2) != 81 && this.input.get(pos + 3) != 80) {
                    this.error("bad protocol header: %s", Functions.str(this.input));
                    return State.ERROR;
                }
                byte protoClass = this.input.get(pos + 4);
                byte instance = this.input.get(pos + 5);
                byte major = this.input.get(pos + 6);
                byte minor = this.input.get(pos + 7);
                this.receiver.received(new ProtocolHeader(protoClass, instance, major, minor));
                this.needed = 12;
                return State.FRAME_HDR;
            }
            case FRAME_HDR: {
                this.flags = this.input.get(pos);
                this.type = SegmentType.get(this.input.get(pos + 1));
                int size = 0xFFFF & this.input.getShort(pos + 2);
                this._maxFrameSize = 65536;
                if ((size -= 12) < 0 || size > this._maxFrameSize - 12) {
                    this.error("bad frame size: %d", size);
                    return State.ERROR;
                }
                byte b = this.input.get(pos + 5);
                if ((b & 0xF0) != 0) {
                    this.error("non-zero reserved bits in upper nibble of frame header byte 5: '%x'", b);
                    return State.ERROR;
                }
                this.track = (byte)(b & 0xF);
                this.channel = 0xFFFF & this.input.getShort(pos + 6);
                if (size == 0) {
                    Frame frame = new Frame(this.flags, this.type, this.track, this.channel, EMPTY_BYTE_BUFFER);
                    this.receiver.received(frame);
                    this.needed = 12;
                    return State.FRAME_HDR;
                }
                this.needed = size;
                return State.FRAME_BODY;
            }
            case FRAME_BODY: {
                Frame frame = new Frame(this.flags, this.type, this.track, this.channel, this.input.slice());
                this.receiver.received(frame);
                this.needed = 12;
                return State.FRAME_HDR;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void exception(Throwable t) {
        this.receiver.exception(t);
    }

    @Override
    public void closed() {
        this.receiver.closed();
    }

    public static enum State {
        PROTO_HDR,
        FRAME_HDR,
        FRAME_BODY,
        ERROR;

    }
}

