/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.utils;

import io.openmessaging.KeyValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.logging.InternalLogger;

public final class BeanUtils {
    static InternalLogger log = ClientLogger.getLog();
    private static Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static Map<Class<?>, Class<?>> wrapperMap;

    public static <T> T populate(Properties properties, Class<T> clazz) {
        T obj = null;
        try {
            obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return BeanUtils.populate(properties, obj);
        }
        catch (Throwable e) {
            log.warn("Error occurs !", e);
            return obj;
        }
    }

    public static <T> T populate(KeyValue properties, Class<T> clazz) {
        T obj = null;
        try {
            obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return BeanUtils.populate(properties, obj);
        }
        catch (Throwable e) {
            log.warn("Error occurs !", e);
            return obj;
        }
    }

    public static Class<?> getMethodClass(Class<?> clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            return method.getParameterTypes()[0];
        }
        return null;
    }

    public static void setProperties(Class<?> clazz, Object obj, String methodName, Object value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> parameterClass = BeanUtils.getMethodClass(clazz, methodName);
        Method setterMethod = clazz.getMethod(methodName, parameterClass);
        if (parameterClass == Boolean.TYPE) {
            setterMethod.invoke(obj, Boolean.valueOf(value.toString()));
        } else if (parameterClass == Integer.TYPE) {
            setterMethod.invoke(obj, Integer.valueOf(value.toString()));
        } else if (parameterClass == Double.TYPE) {
            setterMethod.invoke(obj, Double.valueOf(value.toString()));
        } else if (parameterClass == Float.TYPE) {
            setterMethod.invoke(obj, Float.valueOf(value.toString()));
        } else if (parameterClass == Long.TYPE) {
            setterMethod.invoke(obj, Long.valueOf(value.toString()));
        } else {
            setterMethod.invoke(obj, value);
        }
    }

    public static <T> T populate(Properties properties, T obj) {
        Class<?> clazz = obj.getClass();
        try {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String entryKey = entry.getKey().toString();
                Object[] keyGroup = entryKey.split("\\.");
                for (int i = 0; i < keyGroup.length; ++i) {
                    keyGroup[i] = ((String)keyGroup[i]).toLowerCase();
                    keyGroup[i] = StringUtils.capitalize((String)keyGroup[i]);
                }
                String beanFieldNameWithCapitalization = StringUtils.join((Object[])keyGroup);
                try {
                    BeanUtils.setProperties(clazz, obj, "set" + beanFieldNameWithCapitalization, entry.getValue());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
            }
        }
        catch (RuntimeException e) {
            log.warn("Error occurs !", (Throwable)e);
        }
        return obj;
    }

    public static <T> T populate(KeyValue properties, T obj) {
        Class<?> clazz = obj.getClass();
        try {
            Set keySet = properties.keySet();
            for (String key : keySet) {
                Object[] keyGroup = key.split("[\\._]");
                for (int i = 0; i < keyGroup.length; ++i) {
                    keyGroup[i] = ((String)keyGroup[i]).toLowerCase();
                    keyGroup[i] = StringUtils.capitalize((String)keyGroup[i]);
                }
                String beanFieldNameWithCapitalization = StringUtils.join((Object[])keyGroup);
                try {
                    BeanUtils.setProperties(clazz, obj, "set" + beanFieldNameWithCapitalization, properties.getString(key));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
            }
        }
        catch (RuntimeException e) {
            log.warn("Error occurs !", (Throwable)e);
        }
        return obj;
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        wrapperMap = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> primitiveClass : primitiveWrapperMap.entrySet()) {
            Class<?> wrapperClass = primitiveClass.getValue();
            if (primitiveClass.getKey().equals(wrapperClass)) continue;
            wrapperMap.put(wrapperClass, primitiveClass.getKey());
        }
        wrapperMap.put(String.class, String.class);
    }
}

