/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.rpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingInfo;
import org.apache.rocketmq.common.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class ClientMetadata {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");
    private final ConcurrentMap<String, TopicRouteData> topicRouteTable = new ConcurrentHashMap<String, TopicRouteData>();
    private final ConcurrentMap<String, ConcurrentMap<MessageQueue, String>> topicEndPointsTable = new ConcurrentHashMap<String, ConcurrentMap<MessageQueue, String>>();
    private final ConcurrentMap<String, HashMap<Long, String>> brokerAddrTable = new ConcurrentHashMap<String, HashMap<Long, String>>();
    private final ConcurrentMap<String, HashMap<String, Integer>> brokerVersionTable = new ConcurrentHashMap<String, HashMap<String, Integer>>();

    public void freshTopicRoute(String topic, TopicRouteData topicRouteData) {
        if (topic == null || topicRouteData == null) {
            return;
        }
        TopicRouteData old = (TopicRouteData)((Object)this.topicRouteTable.get(topic));
        if (!topicRouteData.topicRouteDataChanged(old)) {
            return;
        }
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            this.brokerAddrTable.put(bd.getBrokerName(), bd.getBrokerAddrs());
        }
        ConcurrentMap<MessageQueue, String> mqEndPoints = ClientMetadata.topicRouteData2EndpointsForStaticTopic(topic, topicRouteData);
        if (mqEndPoints != null && !mqEndPoints.isEmpty()) {
            this.topicEndPointsTable.put(topic, mqEndPoints);
        }
    }

    public String getBrokerNameFromMessageQueue(MessageQueue mq) {
        if (this.topicEndPointsTable.get(mq.getTopic()) != null && !((ConcurrentMap)this.topicEndPointsTable.get(mq.getTopic())).isEmpty()) {
            return (String)((ConcurrentMap)this.topicEndPointsTable.get(mq.getTopic())).get(mq);
        }
        return mq.getBrokerName();
    }

    public void refreshClusterInfo(ClusterInfo clusterInfo) {
        if (clusterInfo == null || clusterInfo.getBrokerAddrTable() == null) {
            return;
        }
        for (Map.Entry<String, BrokerData> entry : clusterInfo.getBrokerAddrTable().entrySet()) {
            this.brokerAddrTable.put(entry.getKey(), entry.getValue().getBrokerAddrs());
        }
    }

    public String findMasterBrokerAddr(String brokerName) {
        if (!this.brokerAddrTable.containsKey(brokerName)) {
            return null;
        }
        return (String)((HashMap)this.brokerAddrTable.get(brokerName)).get(0L);
    }

    public ConcurrentMap<String, HashMap<Long, String>> getBrokerAddrTable() {
        return this.brokerAddrTable;
    }

    public static ConcurrentMap<MessageQueue, String> topicRouteData2EndpointsForStaticTopic(String topic, TopicRouteData route) {
        if (route.getTopicQueueMappingByBroker() == null || route.getTopicQueueMappingByBroker().isEmpty()) {
            return new ConcurrentHashMap<MessageQueue, String>();
        }
        ConcurrentHashMap<MessageQueue, String> mqEndPointsOfBroker = new ConcurrentHashMap<MessageQueue, String>();
        HashMap mappingInfosByScope = new HashMap();
        for (Map.Entry<String, TopicQueueMappingInfo> entry : route.getTopicQueueMappingByBroker().entrySet()) {
            TopicQueueMappingInfo info = entry.getValue();
            String scope = info.getScope();
            if (scope == null) continue;
            if (!mappingInfosByScope.containsKey(scope)) {
                mappingInfosByScope.put(scope, new HashMap());
            }
            ((Map)mappingInfosByScope.get(scope)).put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, TopicQueueMappingInfo> entry : mappingInfosByScope.entrySet()) {
            String scope = entry.getKey();
            Map topicQueueMappingInfoMap = (Map)((Object)entry.getValue());
            ConcurrentHashMap<MessageQueue, TopicQueueMappingInfo> mqEndPoints = new ConcurrentHashMap<MessageQueue, TopicQueueMappingInfo>();
            ArrayList mappingInfos = new ArrayList(topicQueueMappingInfoMap.entrySet());
            Collections.sort(mappingInfos, new Comparator<Map.Entry<String, TopicQueueMappingInfo>>(){

                @Override
                public int compare(Map.Entry<String, TopicQueueMappingInfo> o1, Map.Entry<String, TopicQueueMappingInfo> o2) {
                    return (int)(o2.getValue().getEpoch() - o1.getValue().getEpoch());
                }
            });
            int maxTotalNums = 0;
            long maxTotalNumOfEpoch = -1L;
            for (Map.Entry entry2 : mappingInfos) {
                TopicQueueMappingInfo info = (TopicQueueMappingInfo)((Object)entry2.getValue());
                if (info.getEpoch() >= maxTotalNumOfEpoch && info.getTotalQueues() > maxTotalNums) {
                    maxTotalNums = info.getTotalQueues();
                }
                for (Map.Entry idEntry : ((TopicQueueMappingInfo)((Object)entry2.getValue())).getCurrIdMap().entrySet()) {
                    int globalId = (Integer)idEntry.getKey();
                    MessageQueue mq = new MessageQueue(topic, TopicQueueMappingUtils.getMockBrokerName(info.getScope()), globalId);
                    TopicQueueMappingInfo oldInfo = (TopicQueueMappingInfo)((Object)mqEndPoints.get(mq));
                    if (oldInfo != null && oldInfo.getEpoch() > info.getEpoch()) continue;
                    mqEndPoints.put(mq, info);
                }
            }
            for (int i = 0; i < maxTotalNums; ++i) {
                MessageQueue messageQueue = new MessageQueue(topic, TopicQueueMappingUtils.getMockBrokerName(scope), i);
                if (!mqEndPoints.containsKey(messageQueue)) {
                    mqEndPointsOfBroker.put(messageQueue, "__syslo__none__");
                    continue;
                }
                mqEndPointsOfBroker.put(messageQueue, ((TopicQueueMappingInfo)((Object)mqEndPoints.get(messageQueue))).getBname());
            }
        }
        return mqEndPointsOfBroker;
    }
}

