/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.route;

import apache.rocketmq.v2.AddressScheme;
import apache.rocketmq.v2.Assignment;
import apache.rocketmq.v2.Broker;
import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.Endpoints;
import apache.rocketmq.v2.MessageQueue;
import apache.rocketmq.v2.MessageType;
import apache.rocketmq.v2.Permission;
import apache.rocketmq.v2.QueryAssignmentRequest;
import apache.rocketmq.v2.QueryAssignmentResponse;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.QueryRouteResponse;
import apache.rocketmq.v2.Resource;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.protocol.route.QueueData;
import org.apache.rocketmq.proxy.common.Address;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.grpc.v2.AbstractMessingActivity;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcConverter;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseBuilder;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.service.route.ProxyTopicRouteData;

public class RouteActivity
extends AbstractMessingActivity {
    public RouteActivity(MessagingProcessor messagingProcessor, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager) {
        super(messagingProcessor, grpcClientSettingsManager, grpcChannelManager);
    }

    public CompletableFuture<QueryRouteResponse> queryRoute(ProxyContext ctx, QueryRouteRequest request) {
        CompletableFuture<QueryRouteResponse> future = new CompletableFuture<QueryRouteResponse>();
        try {
            QueueData queueData;
            String brokerName;
            Map<Long, Broker> brokerIdMap;
            this.validateTopic(request.getTopic());
            List<Address> addressList = this.convertToAddressList(request.getEndpoints());
            String topicName = GrpcConverter.getInstance().wrapResourceWithNamespace(request.getTopic());
            ProxyTopicRouteData proxyTopicRouteData = this.messagingProcessor.getTopicRouteDataForProxy(ctx, addressList, topicName);
            ArrayList<MessageQueue> messageQueueList = new ArrayList<MessageQueue>();
            Map<String, Map<Long, Broker>> brokerMap = this.buildBrokerMap(proxyTopicRouteData.getBrokerDatas());
            TopicMessageType topicMessageType = this.messagingProcessor.getMetadataService().getTopicMessageType(topicName);
            Iterator<QueueData> iterator = proxyTopicRouteData.getQueueDatas().iterator();
            while (iterator.hasNext() && (brokerIdMap = brokerMap.get(brokerName = (queueData = iterator.next()).getBrokerName())) != null) {
                for (Broker broker : brokerIdMap.values()) {
                    messageQueueList.addAll(this.genMessageQueueFromQueueData(queueData, request.getTopic(), topicMessageType, broker));
                }
            }
            QueryRouteResponse response = QueryRouteResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.OK, Code.OK.name())).addAllMessageQueues(messageQueueList).build();
            future.complete(response);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<QueryAssignmentResponse> queryAssignment(ProxyContext ctx, QueryAssignmentRequest request) {
        CompletableFuture<QueryAssignmentResponse> future = new CompletableFuture<QueryAssignmentResponse>();
        try {
            this.validateTopicAndConsumerGroup(request.getTopic(), request.getGroup());
            List<Address> addressList = this.convertToAddressList(request.getEndpoints());
            ProxyTopicRouteData proxyTopicRouteData = this.messagingProcessor.getTopicRouteDataForProxy(ctx, addressList, GrpcConverter.getInstance().wrapResourceWithNamespace(request.getTopic()));
            ArrayList<Assignment> assignments = new ArrayList<Assignment>();
            Map<String, Map<Long, Broker>> brokerMap = this.buildBrokerMap(proxyTopicRouteData.getBrokerDatas());
            for (QueueData queueData : proxyTopicRouteData.getQueueDatas()) {
                Map<Long, Broker> brokerIdMap;
                if (!PermName.isReadable((int)queueData.getPerm()) || queueData.getReadQueueNums() <= 0 || (brokerIdMap = brokerMap.get(queueData.getBrokerName())) == null) continue;
                Broker broker = brokerIdMap.get(0L);
                MessageQueue defaultMessageQueue = MessageQueue.newBuilder().setTopic(request.getTopic()).setId(-1).setPermission(this.convertToPermission(queueData.getPerm())).setBroker(broker).build();
                assignments.add(Assignment.newBuilder().setMessageQueue(defaultMessageQueue).build());
            }
            QueryAssignmentResponse response = assignments.isEmpty() ? QueryAssignmentResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.FORBIDDEN, "no readable queue")).build() : QueryAssignmentResponse.newBuilder().addAllAssignments(assignments).setStatus(ResponseBuilder.getInstance().buildStatus(Code.OK, Code.OK.name())).build();
            future.complete(response);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    protected Permission convertToPermission(int perm) {
        boolean isReadable = PermName.isReadable((int)perm);
        boolean isWriteable = PermName.isWriteable((int)perm);
        if (isReadable && isWriteable) {
            return Permission.READ_WRITE;
        }
        if (isReadable) {
            return Permission.READ;
        }
        if (isWriteable) {
            return Permission.WRITE;
        }
        return Permission.NONE;
    }

    protected List<Address> convertToAddressList(Endpoints endpoints) {
        int port = ConfigurationManager.getProxyConfig().getGrpcServerPort();
        ArrayList<Address> addressList = new ArrayList<Address>();
        for (apache.rocketmq.v2.Address address : endpoints.getAddressesList()) {
            addressList.add(new Address(Address.AddressScheme.valueOf(endpoints.getScheme().name()), HostAndPort.fromParts((String)address.getHost(), (int)port)));
        }
        return addressList;
    }

    protected Map<String, Map<Long, Broker>> buildBrokerMap(List<ProxyTopicRouteData.ProxyBrokerData> brokerDataList) {
        HashMap<String, Map<Long, Broker>> brokerMap = new HashMap<String, Map<Long, Broker>>();
        for (ProxyTopicRouteData.ProxyBrokerData brokerData : brokerDataList) {
            HashMap<Long, Broker> brokerIdMap = new HashMap<Long, Broker>();
            String brokerName = brokerData.getBrokerName();
            for (Map.Entry<Long, List<Address>> entry : brokerData.getBrokerAddrs().entrySet()) {
                Long brokerId = entry.getKey();
                ArrayList<apache.rocketmq.v2.Address> addressList = new ArrayList<apache.rocketmq.v2.Address>();
                AddressScheme addressScheme = AddressScheme.IPv4;
                for (Address address : entry.getValue()) {
                    addressScheme = AddressScheme.valueOf((String)address.getAddressScheme().name());
                    addressList.add(apache.rocketmq.v2.Address.newBuilder().setHost(address.getHostAndPort().getHost()).setPort(address.getHostAndPort().getPort()).build());
                }
                Broker broker = Broker.newBuilder().setName(brokerName).setId(Math.toIntExact(brokerId)).setEndpoints(Endpoints.newBuilder().setScheme(addressScheme).addAllAddresses(addressList).build()).build();
                brokerIdMap.put(brokerId, broker);
            }
            brokerMap.put(brokerName, brokerIdMap);
        }
        return brokerMap;
    }

    protected List<MessageQueue> genMessageQueueFromQueueData(QueueData queueData, Resource topic, TopicMessageType topicMessageType, Broker broker) {
        MessageQueue messageQueue;
        int i;
        ArrayList<MessageQueue> messageQueueList = new ArrayList<MessageQueue>();
        int r = 0;
        int w = 0;
        int rw = 0;
        if (PermName.isWriteable((int)queueData.getPerm()) && PermName.isReadable((int)queueData.getPerm())) {
            rw = Math.min(queueData.getWriteQueueNums(), queueData.getReadQueueNums());
            r = queueData.getReadQueueNums() - rw;
            w = queueData.getWriteQueueNums() - rw;
        } else if (PermName.isWriteable((int)queueData.getPerm())) {
            w = queueData.getWriteQueueNums();
        } else if (PermName.isReadable((int)queueData.getPerm())) {
            r = queueData.getReadQueueNums();
        }
        int queueIdIndex = 0;
        for (i = 0; i < r; ++i) {
            messageQueue = MessageQueue.newBuilder().setBroker(broker).setTopic(topic).setId(queueIdIndex++).setPermission(Permission.READ).addAcceptMessageTypes(this.parseTopicMessageType(topicMessageType)).build();
            messageQueueList.add(messageQueue);
        }
        for (i = 0; i < w; ++i) {
            messageQueue = MessageQueue.newBuilder().setBroker(broker).setTopic(topic).setId(queueIdIndex++).setPermission(Permission.WRITE).addAcceptMessageTypes(this.parseTopicMessageType(topicMessageType)).build();
            messageQueueList.add(messageQueue);
        }
        for (i = 0; i < rw; ++i) {
            messageQueue = MessageQueue.newBuilder().setBroker(broker).setTopic(topic).setId(queueIdIndex++).setPermission(Permission.READ_WRITE).addAcceptMessageTypes(this.parseTopicMessageType(topicMessageType)).build();
            messageQueueList.add(messageQueue);
        }
        return messageQueueList;
    }

    private MessageType parseTopicMessageType(TopicMessageType topicMessageType) {
        switch (topicMessageType) {
            case NORMAL: {
                return MessageType.NORMAL;
            }
            case FIFO: {
                return MessageType.FIFO;
            }
            case TRANSACTION: {
                return MessageType.TRANSACTION;
            }
            case DELAY: {
                return MessageType.DELAY;
            }
        }
        return MessageType.MESSAGE_TYPE_UNSPECIFIED;
    }
}

