/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.controller.ControllerManager;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.srvutil.ShutdownHookThread;
import org.slf4j.LoggerFactory;

public class NamesrvStartup {
    private static InternalLogger log;
    private static Properties properties;
    private static NamesrvConfig namesrvConfig;
    private static NettyServerConfig nettyServerConfig;
    private static NettyClientConfig nettyClientConfig;
    private static ControllerConfig controllerConfig;

    public static void main(String[] args) {
        NamesrvStartup.main0(args);
        NamesrvStartup.controllerManagerMain();
    }

    public static void main0(String[] args) {
        try {
            NamesrvStartup.parseCommandlineAndConfigFile(args);
            NamesrvStartup.createAndStartNamesrvController();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void controllerManagerMain() {
        try {
            if (namesrvConfig.isEnableControllerInNamesrv()) {
                NamesrvStartup.createAndStartControllerManager();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void parseCommandlineAndConfigFile(String[] args) throws Exception {
        String file;
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"mqnamesrv", (String[])args, (Options)NamesrvStartup.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
        if (null == commandLine) {
            System.exit(-1);
            return;
        }
        namesrvConfig = new NamesrvConfig();
        nettyServerConfig = new NettyServerConfig();
        nettyClientConfig = new NettyClientConfig();
        nettyServerConfig.setListenPort(9876);
        controllerConfig = new ControllerConfig();
        if (commandLine.hasOption('c') && (file = commandLine.getOptionValue('c')) != null) {
            BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]));
            properties = new Properties();
            properties.load(in);
            MixAll.properties2Object((Properties)properties, (Object)namesrvConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyClientConfig);
            MixAll.properties2Object((Properties)properties, (Object)controllerConfig);
            namesrvConfig.setConfigStorePath(file);
            System.out.printf("load config properties file OK, %s%n", file);
            ((InputStream)in).close();
        }
        if (commandLine.hasOption('p')) {
            MixAll.printObjectProperties(null, (Object)namesrvConfig);
            MixAll.printObjectProperties(null, (Object)nettyServerConfig);
            MixAll.printObjectProperties(null, (Object)nettyClientConfig);
            MixAll.printObjectProperties(null, (Object)controllerConfig);
            System.exit(0);
        }
        MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)namesrvConfig);
        if (null == namesrvConfig.getRocketmqHome()) {
            System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation%n", "ROCKETMQ_HOME");
            System.exit(-2);
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure(namesrvConfig.getRocketmqHome() + "/conf/logback_namesrv.xml");
        log = InternalLoggerFactory.getLogger((String)"RocketmqNamesrv");
        MixAll.printObjectProperties((InternalLogger)log, (Object)namesrvConfig);
        MixAll.printObjectProperties((InternalLogger)log, (Object)nettyServerConfig);
    }

    public static void createAndStartNamesrvController() throws Exception {
        NamesrvController controller = NamesrvStartup.createNamesrvController();
        NamesrvStartup.start(controller);
        String tip = "The Name Server boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
        log.info(tip);
        System.out.printf("%s%n", tip);
    }

    public static NamesrvController createNamesrvController() {
        NamesrvController controller = new NamesrvController(namesrvConfig, nettyServerConfig, nettyClientConfig);
        controller.getConfiguration().registerConfig(properties);
        return controller;
    }

    public static NamesrvController start(NamesrvController controller) throws Exception {
        if (null == controller) {
            throw new IllegalArgumentException("NamesrvController is null");
        }
        boolean initResult = controller.initialize();
        if (!initResult) {
            controller.shutdown();
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, () -> {
            controller.shutdown();
            return null;
        }));
        controller.start();
        return controller;
    }

    public static void createAndStartControllerManager() throws Exception {
        ControllerManager controllerManager = NamesrvStartup.createControllerManager();
        NamesrvStartup.start(controllerManager);
        String tip = "The ControllerManager boot success. serializeType=" + RemotingCommand.getSerializeTypeConfigInThisServer();
        log.info(tip);
        System.out.printf("%s%n", tip);
    }

    public static ControllerManager createControllerManager() throws Exception {
        NettyServerConfig controllerNettyServerConfig = (NettyServerConfig)nettyServerConfig.clone();
        ControllerManager controllerManager = new ControllerManager(controllerConfig, controllerNettyServerConfig, nettyClientConfig);
        controllerManager.getConfiguration().registerConfig(properties);
        return controllerManager;
    }

    public static ControllerManager start(ControllerManager controllerManager) throws Exception {
        if (null == controllerManager) {
            throw new IllegalArgumentException("ControllerManager is null");
        }
        boolean initResult = controllerManager.initialize();
        if (!initResult) {
            controllerManager.shutdown();
            System.exit(-3);
        }
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHookThread(log, () -> {
            controllerManager.shutdown();
            return null;
        }));
        controllerManager.start();
        return controllerManager;
    }

    public static void shutdown(NamesrvController controller) {
        controller.shutdown();
    }

    public static void shutdown(ControllerManager controllerManager) {
        controllerManager.shutdown();
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Name server config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config items");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static Properties getProperties() {
        return properties;
    }

    static {
        properties = null;
        namesrvConfig = null;
        nettyServerConfig = null;
        nettyClientConfig = null;
        controllerConfig = null;
    }
}

