/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.common;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.Resource;
import com.google.common.base.CharMatcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcConverter;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcProxyException;

public class GrpcValidator {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected static final Object INSTANCE_CREATE_LOCK = new Object();
    protected static volatile GrpcValidator instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrpcValidator getInstance() {
        if (instance == null) {
            Object object = INSTANCE_CREATE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new GrpcValidator();
                }
            }
        }
        return instance;
    }

    public void validateTopic(Resource topic) {
        this.validateTopic(GrpcConverter.getInstance().wrapResourceWithNamespace(topic));
    }

    public void validateTopic(String topicName) {
        try {
            Validators.checkTopic((String)topicName);
        }
        catch (MQClientException mqClientException) {
            throw new GrpcProxyException(Code.ILLEGAL_TOPIC, mqClientException.getErrorMessage());
        }
        if (TopicValidator.isSystemTopic((String)topicName)) {
            throw new GrpcProxyException(Code.ILLEGAL_TOPIC, "cannot access system topic");
        }
    }

    public void validateConsumerGroup(Resource consumerGroup) {
        this.validateConsumerGroup(GrpcConverter.getInstance().wrapResourceWithNamespace(consumerGroup));
    }

    public void validateConsumerGroup(String consumerGroupName) {
        try {
            Validators.checkGroup((String)consumerGroupName);
        }
        catch (MQClientException mqClientException) {
            throw new GrpcProxyException(Code.ILLEGAL_CONSUMER_GROUP, mqClientException.getErrorMessage());
        }
        if (MixAll.isSysConsumerGroup((String)consumerGroupName)) {
            throw new GrpcProxyException(Code.ILLEGAL_CONSUMER_GROUP, "cannot use system consumer group");
        }
    }

    public void validateTopicAndConsumerGroup(Resource topic, Resource consumerGroup) {
        this.validateTopic(topic);
        this.validateConsumerGroup(consumerGroup);
    }

    public void validateInvisibleTime(long invisibleTime) {
        this.validateInvisibleTime(invisibleTime, 0L);
    }

    public void validateInvisibleTime(long invisibleTime, long minInvisibleTime) {
        if (invisibleTime < minInvisibleTime) {
            throw new GrpcProxyException(Code.ILLEGAL_INVISIBLE_TIME, "the invisibleTime is too small. min is " + minInvisibleTime);
        }
        long maxInvisibleTime = ConfigurationManager.getProxyConfig().getMaxInvisibleTimeMills();
        if (maxInvisibleTime <= 0L) {
            return;
        }
        if (invisibleTime > maxInvisibleTime) {
            throw new GrpcProxyException(Code.ILLEGAL_INVISIBLE_TIME, "the invisibleTime is too large. max is " + maxInvisibleTime);
        }
    }

    public void validateTag(String tag) {
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_TAG, "tag cannot be the char sequence of whitespace");
            }
            if (tag.contains("|")) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_TAG, "tag cannot contain '|'");
            }
            if (this.containControlCharacter(tag)) {
                throw new GrpcProxyException(Code.ILLEGAL_MESSAGE_TAG, "tag cannot contain control character");
            }
        }
    }

    public boolean containControlCharacter(String data) {
        for (int i = 0; i < data.length(); ++i) {
            if (!CharMatcher.javaIsoControl().matches(data.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

