/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.acl.plain.PlainAccessValidator;
import org.apache.rocketmq.common.utils.ServiceProvider;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.grpc.GrpcServer;
import org.apache.rocketmq.proxy.grpc.OptionalSSLProtocolNegotiator;
import org.apache.rocketmq.proxy.grpc.interceptor.AuthenticationInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.ContextInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.GlobalExceptionInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.HeaderInterceptor;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;

public class GrpcServerBuilder {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected NettyServerBuilder serverBuilder;

    public static GrpcServerBuilder newBuilder(ThreadPoolExecutor executor, int port) {
        return new GrpcServerBuilder(executor, port);
    }

    protected GrpcServerBuilder(ThreadPoolExecutor executor, int port) {
        this.serverBuilder = NettyServerBuilder.forPort((int)port);
        try {
            this.configSslContext(this.serverBuilder);
        }
        catch (Exception e) {
            log.error("grpc tls set failed. msg: {}, e:", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("grpc tls set failed: " + e.getMessage());
        }
        int bossLoopNum = ConfigurationManager.getProxyConfig().getGrpcBossLoopNum();
        int workerLoopNum = ConfigurationManager.getProxyConfig().getGrpcWorkerLoopNum();
        int maxInboundMessageSize = ConfigurationManager.getProxyConfig().getGrpcMaxInboundMessageSize();
        long idleTimeMills = ConfigurationManager.getProxyConfig().getGrpcClientIdleTimeMills();
        if (ConfigurationManager.getProxyConfig().isEnableGrpcEpoll()) {
            this.serverBuilder.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(bossLoopNum)).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(workerLoopNum)).channelType(EpollServerSocketChannel.class).executor((Executor)executor);
        } else {
            this.serverBuilder.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(bossLoopNum)).workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(workerLoopNum)).channelType(NioServerSocketChannel.class).executor((Executor)executor);
        }
        this.serverBuilder.maxInboundMessageSize(maxInboundMessageSize).maxConnectionIdle(idleTimeMills, TimeUnit.MILLISECONDS);
        log.info("grpc server has built. port: {}, tlsKeyPath: {}, tlsCertPath: {}, threadPool: {}, queueCapacity: {}, boosLoop: {}, workerLoop: {}, maxInboundMessageSize: {}", new Object[]{port, bossLoopNum, workerLoopNum, maxInboundMessageSize});
    }

    public GrpcServerBuilder addService(BindableService service) {
        this.serverBuilder.addService(service);
        return this;
    }

    public GrpcServerBuilder addService(ServerServiceDefinition service) {
        this.serverBuilder.addService(service);
        return this;
    }

    public GrpcServerBuilder appendInterceptor(ServerInterceptor interceptor) {
        this.serverBuilder.intercept(interceptor);
        return this;
    }

    public GrpcServer build() {
        return new GrpcServer(this.serverBuilder.build());
    }

    protected void configSslContext(NettyServerBuilder serverBuilder) throws IOException, CertificateException {
        if (null == serverBuilder) {
            return;
        }
        TlsMode tlsMode = TlsSystemConfig.tlsMode;
        if (!TlsMode.DISABLED.equals((Object)tlsMode)) {
            SslContext sslContext = this.loadSslContext();
            if (TlsMode.PERMISSIVE.equals((Object)tlsMode)) {
                serverBuilder.protocolNegotiator((ProtocolNegotiator)new OptionalSSLProtocolNegotiator(sslContext));
            } else {
                serverBuilder.sslContext(sslContext);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected SslContext loadSslContext() throws CertificateException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GrpcServerBuilder configInterceptor() {
        List accessValidators = ServiceProvider.load(AccessValidator.class);
        if (accessValidators.isEmpty()) {
            log.info("ServiceProvider loaded no AccessValidator, using default org.apache.rocketmq.acl.plain.PlainAccessValidator");
            accessValidators.add(new PlainAccessValidator());
        }
        this.serverBuilder.intercept((ServerInterceptor)new AuthenticationInterceptor(accessValidators));
        ((NettyServerBuilder)((NettyServerBuilder)this.serverBuilder.intercept((ServerInterceptor)new GlobalExceptionInterceptor())).intercept((ServerInterceptor)new ContextInterceptor())).intercept((ServerInterceptor)new HeaderInterceptor());
        return this;
    }
}

