/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.util.List;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class OptionalSSLProtocolNegotiator
implements InternalProtocolNegotiator.ProtocolNegotiator {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final SslContext sslContext;
    private static final int SSL_RECORD_HEADER_LENGTH = 5;

    public OptionalSSLProtocolNegotiator(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public AsciiString scheme() {
        return AsciiString.of((CharSequence)"https");
    }

    public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHttp2ConnectionHandler) {
        ChannelHandler plaintext = InternalProtocolNegotiators.serverPlaintext().newHandler(grpcHttp2ConnectionHandler);
        ChannelHandler ssl = InternalProtocolNegotiators.serverTls((SslContext)this.sslContext).newHandler(grpcHttp2ConnectionHandler);
        return new PortUnificationServerHandler(ssl, plaintext);
    }

    public void close() {
    }

    public static class PortUnificationServerHandler
    extends ByteToMessageDecoder {
        private final ChannelHandler ssl;
        private final ChannelHandler plaintext;

        public PortUnificationServerHandler(ChannelHandler ssl, ChannelHandler plaintext) {
            this.ssl = ssl;
            this.plaintext = plaintext;
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            try {
                if (in.readableBytes() < 5) {
                    return;
                }
                if (SslHandler.isEncrypted((ByteBuf)in)) {
                    ctx.pipeline().addAfter(ctx.name(), null, this.ssl);
                } else {
                    ctx.pipeline().addAfter(ctx.name(), null, this.plaintext);
                }
                ctx.fireUserEventTriggered((Object)InternalProtocolNegotiationEvent.getDefault());
                ctx.pipeline().remove((ChannelHandler)this);
            }
            catch (Exception e) {
                log.error("process protocol negotiator failed.", (Throwable)e);
                throw e;
            }
        }
    }
}

