/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.manager;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class SyncStateInfo {
    private final String clusterName;
    private final String brokerName;
    private final AtomicInteger masterEpoch;
    private final AtomicInteger syncStateSetEpoch;
    private Set<Long> syncStateSet;
    private Long masterBrokerId;

    public SyncStateInfo(String clusterName, String brokerName) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.masterEpoch = new AtomicInteger(0);
        this.syncStateSetEpoch = new AtomicInteger(0);
        this.syncStateSet = Collections.emptySet();
    }

    public void updateMasterInfo(Long masterBrokerId) {
        this.masterBrokerId = masterBrokerId;
        this.masterEpoch.incrementAndGet();
    }

    public void updateSyncStateSetInfo(Set<Long> newSyncStateSet) {
        this.syncStateSet = new HashSet<Long>(newSyncStateSet);
        this.syncStateSetEpoch.incrementAndGet();
    }

    public boolean isFirstTimeForElect() {
        return this.masterEpoch.get() == 0;
    }

    public boolean isMasterExist() {
        return this.masterBrokerId != null;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public Set<Long> getSyncStateSet() {
        return new HashSet<Long>(this.syncStateSet);
    }

    public int getSyncStateSetEpoch() {
        return this.syncStateSetEpoch.get();
    }

    public Long getMasterBrokerId() {
        return this.masterBrokerId;
    }

    public int getMasterEpoch() {
        return this.masterEpoch.get();
    }

    public void removeFromSyncState(Long brokerId) {
        this.syncStateSet.remove(brokerId);
    }
}

