/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.slave;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.loadbalance.MessageRequestModeManager;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.ConsumerOffsetSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.MessageRequestModeSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigAndMappingSerializeWrapper;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.timer.TimerCheckpoint;
import org.apache.rocketmq.store.timer.TimerMetrics;

public class SlaveSynchronize {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private volatile String masterAddr = null;

    public SlaveSynchronize(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public String getMasterAddr() {
        return this.masterAddr;
    }

    public void setMasterAddr(String masterAddr) {
        if (!StringUtils.equals((CharSequence)this.masterAddr, (CharSequence)masterAddr)) {
            LOGGER.info("Update master address from {} to {}", (Object)this.masterAddr, (Object)masterAddr);
            this.masterAddr = masterAddr;
        }
    }

    public void syncAll() {
        this.syncTopicConfig();
        this.syncConsumerOffset();
        this.syncDelayOffset();
        this.syncSubscriptionGroupConfig();
        this.syncMessageRequestMode();
        if (this.brokerController.getMessageStoreConfig().isTimerWheelEnable()) {
            this.syncTimerMetrics();
        }
    }

    private void syncTopicConfig() {
        String masterAddrBak = this.masterAddr;
        if (masterAddrBak != null && !masterAddrBak.equals(this.brokerController.getBrokerAddr())) {
            try {
                Map.Entry item;
                Iterator it;
                ConcurrentMap<String, TopicConfig> topicConfigTable;
                ConcurrentMap newTopicConfigTable;
                TopicConfigAndMappingSerializeWrapper topicWrapper = this.brokerController.getBrokerOuterAPI().getAllTopicConfig(masterAddrBak);
                if (!this.brokerController.getTopicConfigManager().getDataVersion().equals((Object)topicWrapper.getDataVersion())) {
                    this.brokerController.getTopicConfigManager().getDataVersion().assignNewOne(topicWrapper.getDataVersion());
                    newTopicConfigTable = topicWrapper.getTopicConfigTable();
                    topicConfigTable = this.brokerController.getTopicConfigManager().getTopicConfigTable();
                    it = topicConfigTable.entrySet().iterator();
                    while (it.hasNext()) {
                        item = it.next();
                        if (newTopicConfigTable.containsKey(item.getKey())) continue;
                        it.remove();
                    }
                    topicConfigTable.putAll(newTopicConfigTable);
                    this.brokerController.getTopicConfigManager().persist();
                }
                if (topicWrapper.getTopicQueueMappingDetailMap() != null && !topicWrapper.getMappingDataVersion().equals((Object)this.brokerController.getTopicQueueMappingManager().getDataVersion())) {
                    this.brokerController.getTopicQueueMappingManager().getDataVersion().assignNewOne(topicWrapper.getMappingDataVersion());
                    newTopicConfigTable = topicWrapper.getTopicConfigTable();
                    topicConfigTable = this.brokerController.getTopicConfigManager().getTopicConfigTable();
                    it = topicConfigTable.entrySet().iterator();
                    while (it.hasNext()) {
                        item = it.next();
                        if (newTopicConfigTable.containsKey(item.getKey())) continue;
                        it.remove();
                    }
                    topicConfigTable.putAll(newTopicConfigTable);
                    this.brokerController.getTopicQueueMappingManager().persist();
                }
                LOGGER.info("Update slave topic config from master, {}", (Object)masterAddrBak);
            }
            catch (Exception e) {
                LOGGER.error("SyncTopicConfig Exception, {}", (Object)masterAddrBak, (Object)e);
            }
        }
    }

    private void syncConsumerOffset() {
        String masterAddrBak = this.masterAddr;
        if (masterAddrBak != null && !masterAddrBak.equals(this.brokerController.getBrokerAddr())) {
            try {
                ConsumerOffsetSerializeWrapper offsetWrapper = this.brokerController.getBrokerOuterAPI().getAllConsumerOffset(masterAddrBak);
                this.brokerController.getConsumerOffsetManager().getOffsetTable().putAll(offsetWrapper.getOffsetTable());
                this.brokerController.getConsumerOffsetManager().getDataVersion().assignNewOne(offsetWrapper.getDataVersion());
                this.brokerController.getConsumerOffsetManager().persist();
                LOGGER.info("Update slave consumer offset from master, {}", (Object)masterAddrBak);
            }
            catch (Exception e) {
                LOGGER.error("SyncConsumerOffset Exception, {}", (Object)masterAddrBak, (Object)e);
            }
        }
    }

    private void syncDelayOffset() {
        String masterAddrBak = this.masterAddr;
        if (masterAddrBak != null && !masterAddrBak.equals(this.brokerController.getBrokerAddr())) {
            try {
                String delayOffset = this.brokerController.getBrokerOuterAPI().getAllDelayOffset(masterAddrBak);
                if (delayOffset != null) {
                    String fileName = StorePathConfigHelper.getDelayOffsetStorePath((String)this.brokerController.getMessageStoreConfig().getStorePathRootDir());
                    try {
                        MixAll.string2File((String)delayOffset, (String)fileName);
                        this.brokerController.getScheduleMessageService().loadWhenSyncDelayOffset();
                    }
                    catch (IOException e) {
                        LOGGER.error("Persist file Exception, {}", (Object)fileName, (Object)e);
                    }
                }
                LOGGER.info("Update slave delay offset from master, {}", (Object)masterAddrBak);
            }
            catch (Exception e) {
                LOGGER.error("SyncDelayOffset Exception, {}", (Object)masterAddrBak, (Object)e);
            }
        }
    }

    private void syncSubscriptionGroupConfig() {
        String masterAddrBak = this.masterAddr;
        if (masterAddrBak != null && !masterAddrBak.equals(this.brokerController.getBrokerAddr())) {
            try {
                SubscriptionGroupWrapper subscriptionWrapper = this.brokerController.getBrokerOuterAPI().getAllSubscriptionGroupConfig(masterAddrBak);
                if (!this.brokerController.getSubscriptionGroupManager().getDataVersion().equals((Object)subscriptionWrapper.getDataVersion())) {
                    SubscriptionGroupManager subscriptionGroupManager = this.brokerController.getSubscriptionGroupManager();
                    subscriptionGroupManager.getDataVersion().assignNewOne(subscriptionWrapper.getDataVersion());
                    subscriptionGroupManager.getSubscriptionGroupTable().clear();
                    subscriptionGroupManager.getSubscriptionGroupTable().putAll(subscriptionWrapper.getSubscriptionGroupTable());
                    subscriptionGroupManager.persist();
                    LOGGER.info("Update slave Subscription Group from master, {}", (Object)masterAddrBak);
                }
            }
            catch (Exception e) {
                LOGGER.error("SyncSubscriptionGroup Exception, {}", (Object)masterAddrBak, (Object)e);
            }
        }
    }

    private void syncMessageRequestMode() {
        String masterAddrBak = this.masterAddr;
        if (masterAddrBak != null && !masterAddrBak.equals(this.brokerController.getBrokerAddr())) {
            try {
                MessageRequestModeSerializeWrapper messageRequestModeSerializeWrapper = this.brokerController.getBrokerOuterAPI().getAllMessageRequestMode(masterAddrBak);
                MessageRequestModeManager messageRequestModeManager = this.brokerController.getQueryAssignmentProcessor().getMessageRequestModeManager();
                messageRequestModeManager.getMessageRequestModeMap().clear();
                messageRequestModeManager.getMessageRequestModeMap().putAll(messageRequestModeSerializeWrapper.getMessageRequestModeMap());
                messageRequestModeManager.persist();
                LOGGER.info("Update slave Message Request Mode from master, {}", (Object)masterAddrBak);
            }
            catch (Exception e) {
                LOGGER.error("SyncMessageRequestMode Exception, {}", (Object)masterAddrBak, (Object)e);
            }
        }
    }

    public void syncTimerCheckPoint() {
        String masterAddrBak = this.masterAddr;
        if (masterAddrBak != null) {
            try {
                if (null != this.brokerController.getMessageStore().getTimerMessageStore()) {
                    TimerCheckpoint checkpoint = this.brokerController.getBrokerOuterAPI().getTimerCheckPoint(masterAddrBak);
                    if (null != this.brokerController.getTimerCheckpoint()) {
                        this.brokerController.getTimerCheckpoint().setLastReadTimeMs(checkpoint.getLastReadTimeMs());
                        this.brokerController.getTimerCheckpoint().setMasterTimerQueueOffset(checkpoint.getMasterTimerQueueOffset());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("syncTimerCheckPoint Exception, {}", (Object)masterAddrBak, (Object)e);
            }
        }
    }

    private void syncTimerMetrics() {
        String masterAddrBak = this.masterAddr;
        if (masterAddrBak != null) {
            try {
                if (null != this.brokerController.getMessageStore().getTimerMessageStore()) {
                    TimerMetrics.TimerMetricsSerializeWrapper metricsSerializeWrapper = this.brokerController.getBrokerOuterAPI().getTimerMetrics(masterAddrBak);
                    if (!this.brokerController.getMessageStore().getTimerMessageStore().getTimerMetrics().getDataVersion().equals((Object)metricsSerializeWrapper.getDataVersion())) {
                        this.brokerController.getMessageStore().getTimerMessageStore().getTimerMetrics().getDataVersion().assignNewOne(metricsSerializeWrapper.getDataVersion());
                        this.brokerController.getMessageStore().getTimerMessageStore().getTimerMetrics().getTimingCount().clear();
                        this.brokerController.getMessageStore().getTimerMessageStore().getTimerMetrics().getTimingCount().putAll(metricsSerializeWrapper.getTimingCount());
                        this.brokerController.getMessageStore().getTimerMessageStore().getTimerMetrics().persist();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("SyncTimerMetrics Exception, {}", (Object)masterAddrBak, (Object)e);
            }
        }
    }
}

