/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.config;

import java.util.function.BiConsumer;
import org.apache.rocketmq.common.config.ConfigRocksDBStorage;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.rocksdb.FlushOptions;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.WriteBatch;

public class RocksDBConfigManager {
    protected static final Logger BROKER_LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    protected volatile boolean isStop = false;
    protected ConfigRocksDBStorage configRocksDBStorage = null;
    private FlushOptions flushOptions = null;
    private volatile long lastFlushMemTableMicroSecond = 0L;
    private final long memTableFlushInterval;

    public RocksDBConfigManager(long memTableFlushInterval) {
        this.memTableFlushInterval = memTableFlushInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String configFilePath, BiConsumer<byte[], byte[]> biConsumer) {
        this.isStop = false;
        this.configRocksDBStorage = new ConfigRocksDBStorage(configFilePath);
        if (!this.configRocksDBStorage.start()) {
            return false;
        }
        try (RocksIterator iterator = this.configRocksDBStorage.iterator();){
            iterator.seekToFirst();
            while (iterator.isValid()) {
                biConsumer.accept(iterator.key(), iterator.value());
                iterator.next();
            }
        }
        this.flushOptions = new FlushOptions();
        this.flushOptions.setWaitForFlush(false);
        this.flushOptions.setAllowWriteStall(false);
        return true;
    }

    public void start() {
    }

    public boolean stop() {
        this.isStop = true;
        if (this.configRocksDBStorage != null) {
            return this.configRocksDBStorage.shutdown();
        }
        if (this.flushOptions != null) {
            this.flushOptions.close();
        }
        return true;
    }

    public void flushWAL() {
        try {
            if (this.isStop) {
                return;
            }
            if (this.configRocksDBStorage != null) {
                this.configRocksDBStorage.flushWAL();
                long now = System.currentTimeMillis();
                if (now > this.lastFlushMemTableMicroSecond + this.memTableFlushInterval) {
                    this.configRocksDBStorage.flush(this.flushOptions);
                    this.lastFlushMemTableMicroSecond = now;
                }
            }
        }
        catch (Exception e) {
            BROKER_LOG.error("kv flush WAL Failed.", (Throwable)e);
        }
    }

    public void put(byte[] keyBytes, int keyLen, byte[] valueBytes) throws Exception {
        this.configRocksDBStorage.put(keyBytes, keyLen, valueBytes);
    }

    public void delete(byte[] keyBytes) throws Exception {
        this.configRocksDBStorage.delete(keyBytes);
    }

    public void batchPutWithWal(WriteBatch batch) throws Exception {
        this.configRocksDBStorage.batchPutWithWal(batch);
    }

    public Statistics getStatistics() {
        if (this.configRocksDBStorage == null) {
            return null;
        }
        return this.configRocksDBStorage.getStatistics();
    }
}

