/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v1;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.config.v1.RocksDBConfigManager;
import org.apache.rocketmq.broker.topic.TopicConfigManager;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.rocksdb.CompressionType;

public class RocksDBTopicConfigManager
extends TopicConfigManager {
    private static final String VERSION_COLUMN_FAMILY = "topicVersion";
    private static final String TOPIC_COLUMN_FAMILY = "topic";
    protected transient RocksDBConfigManager rocksDBConfigManager;
    private final boolean useSingleRocksDBForAllConfigs;
    private final String storePathRootDir;

    public RocksDBTopicConfigManager(BrokerController brokerController, boolean useSingleRocksDB, String storePathRootDir) {
        super(brokerController, false);
        this.useSingleRocksDBForAllConfigs = useSingleRocksDB;
        this.storePathRootDir = StringUtils.isBlank((CharSequence)storePathRootDir) ? brokerController.getMessageStoreConfig().getStorePathRootDir() : storePathRootDir;
        long flushInterval = brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs();
        CompressionType compressionType = CompressionType.getCompressionType((String)brokerController.getMessageStoreConfig().getRocksdbCompressionType());
        String rocksDBPath = this.rocksdbConfigFilePath(storePathRootDir, useSingleRocksDB);
        this.rocksDBConfigManager = useSingleRocksDB ? new RocksDBConfigManager(rocksDBPath, flushInterval, compressionType, TOPIC_COLUMN_FAMILY, VERSION_COLUMN_FAMILY) : new RocksDBConfigManager(rocksDBPath, flushInterval, compressionType);
    }

    public RocksDBTopicConfigManager(BrokerController brokerController, boolean useSingleRocksDBForAllConfigs) {
        this(brokerController, useSingleRocksDBForAllConfigs, null);
    }

    public RocksDBTopicConfigManager(BrokerController brokerController) {
        this(brokerController, brokerController.getBrokerConfig().isUseSingleRocksDBForAllConfigs(), null);
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.init()) {
            return false;
        }
        if (!this.loadDataVersion() || !this.loadTopicConfig()) {
            return false;
        }
        if (this.useSingleRocksDBForAllConfigs) {
            this.migrateFromSeparateRocksDBs();
        }
        this.init();
        return true;
    }

    public boolean loadTopicConfig() {
        return this.rocksDBConfigManager.loadData(this::decodeTopicConfig) && this.merge();
    }

    @Override
    public boolean loadDataVersion() {
        return this.rocksDBConfigManager.loadDataVersion();
    }

    private boolean merge() {
        if (!UtilAll.isPathExists((String)this.configFilePath()) && !UtilAll.isPathExists((String)(this.configFilePath() + ".bak"))) {
            log.info("topic json file does not exist, so skip merge");
            return true;
        }
        if (!super.loadDataVersion()) {
            log.error("load json topic dataVersion error, startup will exit");
            return false;
        }
        DataVersion dataVersion = super.getDataVersion();
        DataVersion kvDataVersion = this.getDataVersion();
        if (dataVersion.getCounter().get() > kvDataVersion.getCounter().get()) {
            if (!super.load()) {
                log.error("load topic config from json file error, startup will exit");
                return false;
            }
            ConcurrentMap<String, TopicConfig> topicConfigTable = this.getTopicConfigTable();
            for (Map.Entry entry : topicConfigTable.entrySet()) {
                this.putTopicConfig((TopicConfig)entry.getValue());
                log.info("import topic config to rocksdb, topic={}", entry.getValue());
            }
            this.getDataVersion().assignNewOne(dataVersion);
            this.updateDataVersion();
        } else {
            log.info("dataVersion is not greater than kvDataVersion, no need to merge topic metaData, dataVersion={}, kvDataVersion={}", (Object)dataVersion, (Object)kvDataVersion);
        }
        log.info("finish read topic config from json file and merge to rocksdb");
        this.persist();
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    protected void decodeTopicConfig(byte[] key, byte[] body) {
        String topicName = new String(key, DataConverter.CHARSET_UTF8);
        TopicConfig topicConfig = (TopicConfig)JSON.parseObject((byte[])body, TopicConfig.class, (Feature[])new Feature[0]);
        this.topicConfigTable.put(topicName, topicConfig);
        log.info("load exist local topic, {}", (Object)topicConfig.toString());
    }

    @Override
    public TopicConfig putTopicConfig(TopicConfig topicConfig) {
        String topicName = topicConfig.getTopicName();
        TopicConfig oldTopicConfig = this.topicConfigTable.put(topicName, topicConfig);
        try {
            byte[] keyBytes = topicName.getBytes(DataConverter.CHARSET_UTF8);
            byte[] valueBytes = JSON.toJSONBytes((Object)topicConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
            this.rocksDBConfigManager.put(keyBytes, valueBytes);
        }
        catch (Exception e) {
            log.error("kv put topic Failed, {}", (Object)topicConfig.toString(), (Object)e);
        }
        return oldTopicConfig;
    }

    @Override
    protected TopicConfig removeTopicConfig(String topicName) {
        TopicConfig topicConfig = (TopicConfig)this.topicConfigTable.remove(topicName);
        try {
            this.rocksDBConfigManager.delete(topicName.getBytes(DataConverter.CHARSET_UTF8));
        }
        catch (Exception e) {
            log.error("kv remove topic Failed, {}", (Object)topicConfig.toString());
        }
        return topicConfig;
    }

    public synchronized void persist() {
        if (this.brokerController.getMessageStoreConfig().isRealTimePersistRocksDBConfig()) {
            this.rocksDBConfigManager.flushWAL();
        }
    }

    public synchronized void exportToJson() {
        log.info("RocksDBTopicConfigManager export topic config to json file");
        super.persist();
    }

    public String rocksdbConfigFilePath(String storePathRootDir, boolean useSingleRocksDBForAllConfigs) {
        if (StringUtils.isBlank((CharSequence)storePathRootDir)) {
            storePathRootDir = this.brokerController.getMessageStoreConfig().getStorePathRootDir();
        }
        Path rootPath = Paths.get(storePathRootDir, new String[0]);
        if (useSingleRocksDBForAllConfigs) {
            return rootPath.resolve("config").resolve("metadata").toString();
        }
        return rootPath.resolve("config").resolve("topics").toString();
    }

    @Override
    public String configFilePath() {
        return BrokerPathConfigHelper.getTopicConfigPath(this.storePathRootDir);
    }

    @Override
    public DataVersion getDataVersion() {
        return this.rocksDBConfigManager.getKvDataVersion();
    }

    @Override
    public void updateDataVersion() {
        try {
            this.rocksDBConfigManager.updateKvDataVersion();
        }
        catch (Exception e) {
            log.error("update topic config dataVersion error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromSeparateRocksDBs() {
        String separateRocksDBPath = this.rocksdbConfigFilePath(this.storePathRootDir, false);
        if (!UtilAll.isPathExists((String)separateRocksDBPath)) {
            log.info("Separate RocksDB for topics does not exist at {}, no migration needed", (Object)separateRocksDBPath);
            return;
        }
        log.info("Starting migration from separate RocksDB at {} to unified RocksDB", (Object)separateRocksDBPath);
        RocksDBConfigManager separateRocksDBConfigManager = null;
        try {
            long memTableFlushIntervalMs = this.brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs();
            CompressionType compressionType = CompressionType.getCompressionType((String)this.brokerController.getMessageStoreConfig().getRocksdbCompressionType());
            separateRocksDBConfigManager = new RocksDBConfigManager(separateRocksDBPath, memTableFlushIntervalMs, compressionType);
            if (!separateRocksDBConfigManager.init(true)) {
                log.error("Failed to initialize separate RocksDB in read-only mode");
                return;
            }
            if (!separateRocksDBConfigManager.loadDataVersion()) {
                log.error("Failed to load data version from separate RocksDB");
                return;
            }
            DataVersion separateDataVersion = separateRocksDBConfigManager.getKvDataVersion();
            DataVersion unifiedDataVersion = this.getDataVersion();
            log.info("Comparing data versions - Separate: {}, Unified: {}", (Object)separateDataVersion, (Object)unifiedDataVersion);
            if (separateDataVersion.getCounter().get() > unifiedDataVersion.getCounter().get()) {
                log.info("Separate RocksDB has newer data, importing...");
                if (separateRocksDBConfigManager.loadData(this::importTopicConfig)) {
                    log.info("Successfully imported topic configs from separate RocksDB");
                    this.getDataVersion().assignNewOne(separateDataVersion);
                    this.getDataVersion().nextVersion();
                    this.updateDataVersion();
                    log.info("Updated unified data version to {}", (Object)this.getDataVersion());
                } else {
                    log.error("Failed to import topic configs from separate RocksDB");
                }
            } else {
                log.info("Unified RocksDB is already up-to-date, no migration needed");
            }
        }
        catch (Exception e) {
            log.error("Error during migration from separate RocksDB", (Throwable)e);
        }
        finally {
            if (separateRocksDBConfigManager != null) {
                try {
                    separateRocksDBConfigManager.stop();
                }
                catch (Exception e) {
                    log.warn("Error stopping separate RocksDB config manager", (Throwable)e);
                }
            }
        }
    }

    private void importTopicConfig(byte[] key, byte[] body) {
        try {
            this.decodeTopicConfig(key, body);
            this.rocksDBConfigManager.put(key, body);
        }
        catch (Exception e) {
            log.error("Error importing topic config", (Throwable)e);
        }
    }
}

