/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingInfo;

public class TopicRouteData
extends RemotingSerializable {
    private String orderTopicConf;
    private List<QueueData> queueDatas = new ArrayList<QueueData>();
    private List<BrokerData> brokerDatas = new ArrayList<BrokerData>();
    private HashMap<String, List<String>> filterServerTable = new HashMap();
    private Map<String, TopicQueueMappingInfo> topicQueueMappingByBroker;

    public TopicRouteData() {
    }

    public TopicRouteData(TopicRouteData topicRouteData) {
        this.orderTopicConf = topicRouteData.orderTopicConf;
        if (topicRouteData.queueDatas != null) {
            this.queueDatas.addAll(topicRouteData.queueDatas);
        }
        if (topicRouteData.brokerDatas != null) {
            this.brokerDatas.addAll(topicRouteData.brokerDatas);
        }
        if (topicRouteData.filterServerTable != null) {
            this.filterServerTable.putAll(topicRouteData.filterServerTable);
        }
        if (topicRouteData.topicQueueMappingByBroker != null) {
            this.topicQueueMappingByBroker = new HashMap<String, TopicQueueMappingInfo>(topicRouteData.topicQueueMappingByBroker);
        }
    }

    public TopicRouteData cloneTopicRouteData() {
        TopicRouteData topicRouteData = new TopicRouteData();
        topicRouteData.setQueueDatas(new ArrayList<QueueData>());
        topicRouteData.setBrokerDatas(new ArrayList<BrokerData>());
        topicRouteData.setFilterServerTable(new HashMap<String, List<String>>());
        topicRouteData.setOrderTopicConf(this.orderTopicConf);
        topicRouteData.getQueueDatas().addAll(this.queueDatas);
        topicRouteData.getBrokerDatas().addAll(this.brokerDatas);
        topicRouteData.getFilterServerTable().putAll(this.filterServerTable);
        if (this.topicQueueMappingByBroker != null) {
            HashMap<String, TopicQueueMappingInfo> cloneMap = new HashMap<String, TopicQueueMappingInfo>(this.topicQueueMappingByBroker);
            topicRouteData.setTopicQueueMappingByBroker(cloneMap);
        }
        return topicRouteData;
    }

    public TopicRouteData deepCloneTopicRouteData() {
        TopicRouteData topicRouteData = new TopicRouteData();
        topicRouteData.setOrderTopicConf(this.orderTopicConf);
        for (QueueData queueData : this.queueDatas) {
            topicRouteData.getQueueDatas().add(new QueueData(queueData));
        }
        for (BrokerData brokerData : this.brokerDatas) {
            topicRouteData.getBrokerDatas().add(new BrokerData(brokerData));
        }
        for (Map.Entry entry : this.filterServerTable.entrySet()) {
            topicRouteData.getFilterServerTable().put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        if (this.topicQueueMappingByBroker != null) {
            HashMap<String, TopicQueueMappingInfo> cloneMap = new HashMap<String, TopicQueueMappingInfo>(this.topicQueueMappingByBroker.size());
            for (Map.Entry<String, TopicQueueMappingInfo> entry : this.getTopicQueueMappingByBroker().entrySet()) {
                TopicQueueMappingInfo topicQueueMappingInfo = new TopicQueueMappingInfo(entry.getValue().getTopic(), entry.getValue().getTotalQueues(), entry.getValue().getBname(), entry.getValue().getEpoch());
                topicQueueMappingInfo.setDirty(entry.getValue().isDirty());
                topicQueueMappingInfo.setScope(entry.getValue().getScope());
                ConcurrentHashMap<Integer, Integer> concurrentMap = new ConcurrentHashMap<Integer, Integer>(entry.getValue().getCurrIdMap());
                topicQueueMappingInfo.setCurrIdMap(concurrentMap);
                cloneMap.put(entry.getKey(), topicQueueMappingInfo);
            }
            topicRouteData.setTopicQueueMappingByBroker(cloneMap);
        }
        return topicRouteData;
    }

    public boolean topicRouteDataChanged(TopicRouteData oldData) {
        if (oldData == null) {
            return true;
        }
        TopicRouteData old = new TopicRouteData(oldData);
        TopicRouteData now = new TopicRouteData(this);
        Collections.sort(old.getQueueDatas());
        Collections.sort(old.getBrokerDatas());
        Collections.sort(now.getQueueDatas());
        Collections.sort(now.getBrokerDatas());
        return !old.equals(now);
    }

    public List<QueueData> getQueueDatas() {
        return this.queueDatas;
    }

    public void setQueueDatas(List<QueueData> queueDatas) {
        this.queueDatas = queueDatas;
    }

    public List<BrokerData> getBrokerDatas() {
        return this.brokerDatas;
    }

    public void setBrokerDatas(List<BrokerData> brokerDatas) {
        this.brokerDatas = brokerDatas;
    }

    public HashMap<String, List<String>> getFilterServerTable() {
        return this.filterServerTable;
    }

    public void setFilterServerTable(HashMap<String, List<String>> filterServerTable) {
        this.filterServerTable = filterServerTable;
    }

    public String getOrderTopicConf() {
        return this.orderTopicConf;
    }

    public void setOrderTopicConf(String orderTopicConf) {
        this.orderTopicConf = orderTopicConf;
    }

    public Map<String, TopicQueueMappingInfo> getTopicQueueMappingByBroker() {
        return this.topicQueueMappingByBroker;
    }

    public void setTopicQueueMappingByBroker(Map<String, TopicQueueMappingInfo> topicQueueMappingByBroker) {
        this.topicQueueMappingByBroker = topicQueueMappingByBroker;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.brokerDatas == null ? 0 : this.brokerDatas.hashCode());
        result = 31 * result + (this.orderTopicConf == null ? 0 : this.orderTopicConf.hashCode());
        result = 31 * result + (this.queueDatas == null ? 0 : this.queueDatas.hashCode());
        result = 31 * result + (this.filterServerTable == null ? 0 : this.filterServerTable.hashCode());
        result = 31 * result + (this.topicQueueMappingByBroker == null ? 0 : this.topicQueueMappingByBroker.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicRouteData other = (TopicRouteData)obj;
        if (this.brokerDatas == null ? other.brokerDatas != null : !this.brokerDatas.equals(other.brokerDatas)) {
            return false;
        }
        if (this.orderTopicConf == null ? other.orderTopicConf != null : !this.orderTopicConf.equals(other.orderTopicConf)) {
            return false;
        }
        if (this.queueDatas == null ? other.queueDatas != null : !this.queueDatas.equals(other.queueDatas)) {
            return false;
        }
        if (this.filterServerTable == null ? other.filterServerTable != null : !this.filterServerTable.equals(other.filterServerTable)) {
            return false;
        }
        return !(this.topicQueueMappingByBroker == null ? other.topicQueueMappingByBroker != null : !this.topicQueueMappingByBroker.equals(other.topicQueueMappingByBroker));
    }

    public String toString() {
        return "TopicRouteData [orderTopicConf=" + this.orderTopicConf + ", queueDatas=" + this.queueDatas + ", brokerDatas=" + this.brokerDatas + ", filterServerTable=" + this.filterServerTable + ", topicQueueMappingInfoTable=" + this.topicQueueMappingByBroker + "]";
    }
}

