/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.producer;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.SendMessageResponse;
import apache.rocketmq.v2.SendResultEntry;
import apache.rocketmq.v2.Status;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.java.exception.BadRequestException;
import org.apache.rocketmq.client.java.exception.ForbiddenException;
import org.apache.rocketmq.client.java.exception.InternalErrorException;
import org.apache.rocketmq.client.java.exception.NotFoundException;
import org.apache.rocketmq.client.java.exception.PayloadTooLargeException;
import org.apache.rocketmq.client.java.exception.ProxyTimeoutException;
import org.apache.rocketmq.client.java.exception.RequestHeaderFieldsTooLargeException;
import org.apache.rocketmq.client.java.exception.TooManyRequestsException;
import org.apache.rocketmq.client.java.exception.UnauthorizedException;
import org.apache.rocketmq.client.java.exception.UnsupportedException;
import org.apache.rocketmq.client.java.message.MessageIdCodec;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcInvocation;

public class SendReceiptImpl
implements SendReceipt {
    private final MessageId messageId;
    private final String transactionId;
    private final MessageQueueImpl messageQueue;
    private final long offset;

    private SendReceiptImpl(MessageId messageId, String transactionId, MessageQueueImpl messageQueue, long offset) {
        this.messageId = messageId;
        this.transactionId = transactionId;
        this.messageQueue = messageQueue;
        this.offset = offset;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageQueueImpl getMessageQueue() {
        return this.messageQueue;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Endpoints getEndpoints() {
        return this.messageQueue.getBroker().getEndpoints();
    }

    public long getOffset() {
        return this.offset;
    }

    public static List<SendReceiptImpl> processSendMessageResponseInvocation(MessageQueueImpl mq, RpcInvocation<SendMessageResponse> invocation) throws ClientException {
        Code code;
        String requestId = invocation.getContext().getRequestId();
        SendMessageResponse response = invocation.getResponse();
        Status status = response.getStatus();
        ArrayList<SendReceiptImpl> sendReceipts = new ArrayList<SendReceiptImpl>();
        List entries = response.getEntriesList();
        Optional<Status> abnormalStatus = entries.stream().map(SendResultEntry::getStatus).filter((Predicate<Status>)((com.google.common.base.Predicate)s -> !s.getCode().equals((Object)Code.OK))).findFirst();
        if (abnormalStatus.isPresent()) {
            status = abnormalStatus.get();
        }
        if ((code = status.getCode()).equals((Object)Code.OK)) {
            for (SendResultEntry entry : entries) {
                MessageId messageId = MessageIdCodec.getInstance().decode(entry.getMessageId());
                String transactionId = entry.getTransactionId();
                long offset = entry.getOffset();
                SendReceiptImpl impl = new SendReceiptImpl(messageId, transactionId, mq, offset);
                sendReceipts.add(impl);
            }
            return sendReceipts;
        }
        int codeNumber = code.getNumber();
        String statusMessage = status.getMessage();
        switch (code) {
            case ILLEGAL_TOPIC: 
            case ILLEGAL_MESSAGE_TAG: 
            case ILLEGAL_MESSAGE_KEY: 
            case ILLEGAL_MESSAGE_GROUP: 
            case ILLEGAL_MESSAGE_PROPERTY_KEY: 
            case ILLEGAL_MESSAGE_ID: 
            case ILLEGAL_DELIVERY_TIME: 
            case MESSAGE_PROPERTY_CONFLICT_WITH_TYPE: 
            case MESSAGE_CORRUPTED: 
            case CLIENT_ID_REQUIRED: {
                throw new BadRequestException(codeNumber, requestId, statusMessage);
            }
            case UNAUTHORIZED: {
                throw new UnauthorizedException(codeNumber, requestId, statusMessage);
            }
            case FORBIDDEN: {
                throw new ForbiddenException(codeNumber, requestId, statusMessage);
            }
            case NOT_FOUND: 
            case TOPIC_NOT_FOUND: {
                throw new NotFoundException(codeNumber, requestId, statusMessage);
            }
            case PAYLOAD_TOO_LARGE: 
            case MESSAGE_BODY_TOO_LARGE: {
                throw new PayloadTooLargeException(codeNumber, requestId, statusMessage);
            }
            case TOO_MANY_REQUESTS: {
                throw new TooManyRequestsException(codeNumber, requestId, statusMessage);
            }
            case REQUEST_HEADER_FIELDS_TOO_LARGE: 
            case MESSAGE_PROPERTIES_TOO_LARGE: {
                throw new RequestHeaderFieldsTooLargeException(codeNumber, requestId, statusMessage);
            }
            case INTERNAL_ERROR: 
            case INTERNAL_SERVER_ERROR: 
            case HA_NOT_AVAILABLE: {
                throw new InternalErrorException(codeNumber, requestId, statusMessage);
            }
            case PROXY_TIMEOUT: 
            case MASTER_PERSISTENCE_TIMEOUT: 
            case SLAVE_PERSISTENCE_TIMEOUT: {
                throw new ProxyTimeoutException(codeNumber, requestId, statusMessage);
            }
        }
        throw new UnsupportedException(codeNumber, requestId, statusMessage);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).toString();
    }
}

