/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class StandardConsumeService
extends ConsumeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardConsumeService.class);

    public StandardConsumeService(String clientId, ConcurrentMap<MessageQueueImpl, ProcessQueue> processQueueTable, MessageListener messageListener, ThreadPoolExecutor consumptionExecutor, MessageInterceptor messageInterceptor, ScheduledExecutorService scheduler) {
        super(clientId, processQueueTable, messageListener, consumptionExecutor, messageInterceptor, scheduler);
    }

    @Override
    public void startUp() {
        LOGGER.info("Begin to start the standard consume service, clientId={}", (Object)this.clientId);
        super.startUp();
        LOGGER.info("Begin to shutdown the standard consume service, clientId={}", (Object)this.clientId);
    }

    @Override
    public void shutDown() throws InterruptedException {
        LOGGER.info("Begin to shutdown the standard consume service, clientId={}", (Object)this.clientId);
        super.shutDown();
        LOGGER.info("Shutdown the standard consume service successfully, clientId={}", (Object)this.clientId);
    }

    public boolean dispatch0() {
        ArrayList processQueues = new ArrayList(this.processQueueTable.values());
        Collections.shuffle(processQueues);
        boolean dispatched = false;
        for (final ProcessQueue pq : processQueues) {
            Optional<MessageViewImpl> optionalMessageView = pq.tryTakeMessage();
            if (!optionalMessageView.isPresent()) continue;
            dispatched = true;
            final MessageViewImpl messageView = optionalMessageView.get();
            ListenableFuture<ConsumeResult> future = this.consume(messageView);
            Futures.addCallback(future, new FutureCallback<ConsumeResult>(){

                @Override
                public void onSuccess(ConsumeResult consumeResult) {
                    pq.eraseMessage(messageView, consumeResult);
                }

                @Override
                public void onFailure(Throwable t) {
                    LOGGER.error("[Bug] Exception raised in consumption callback, clientId={}", (Object)StandardConsumeService.this.clientId, (Object)t);
                }
            }, MoreExecutors.directExecutor());
        }
        return dispatched;
    }

    @Override
    public void dispatch() {
        boolean dispatched;
        while (dispatched = this.dispatch0()) {
        }
    }
}

