/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.rpc;

import com.alibaba.fastjson.JSONObject;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.model.MessageEvent;
import org.apache.rocketmq.mqtt.cs.channel.ChannelManager;
import org.apache.rocketmq.mqtt.cs.session.notify.MessageNotifyAction;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RpcPacketDispatcher
implements NettyRequestProcessor {
    private static Logger logger = LoggerFactory.getLogger(RpcPacketDispatcher.class);
    @Resource
    private MessageNotifyAction messageNotifyAction;
    @Resource
    private ChannelManager channelManager;

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        RemotingCommand response = RemotingCommand.createResponseCommand((int)1, null);
        response.setOpaque(request.getOpaque());
        int code = request.getCode();
        try {
            if (201 == code) {
                this.doNotify(request);
            } else if (203 == code) {
                this.closeChannel(request);
            }
        }
        catch (Throwable t) {
            logger.error("", t);
            response.setCode(-1);
        }
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }

    private void doNotify(RemotingCommand request) {
        String payload = new String(request.getBody(), StandardCharsets.UTF_8);
        List events = JSONObject.parseArray((String)payload, MessageEvent.class);
        this.messageNotifyAction.notify(events);
    }

    private void closeChannel(RemotingCommand request) {
        String channelId = request.getExtFields() != null ? (String)request.getExtFields().get("channelId") : null;
        this.channelManager.closeConnect(channelId, request.getRemark());
    }
}

