/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.raft.processor;

import com.alipay.sofa.jraft.util.BytesUtil;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import org.apache.rocketmq.mqtt.common.model.consistency.ReadRequest;
import org.apache.rocketmq.mqtt.common.model.consistency.Response;
import org.apache.rocketmq.mqtt.common.model.consistency.WriteRequest;
import org.apache.rocketmq.mqtt.meta.rocksdb.RocksDBEngine;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateProcessor {
    protected static Logger logger = LoggerFactory.getLogger(StateProcessor.class);

    public abstract Response onReadRequest(ReadRequest var1) throws Exception;

    public abstract Response onWriteRequest(WriteRequest var1) throws Exception;

    public abstract String groupCategory();

    public Response get(RocksDBEngine rocksDBEngine, byte[] key) throws Exception {
        Lock readLock = rocksDBEngine.getReadWriteLock().readLock();
        readLock.lock();
        try {
            byte[] value = rocksDBEngine.getRdb().get(key);
            if (value == null) {
                value = "NOT_FOUND".getBytes();
            }
            Response response = Response.newBuilder().setSuccess(true).setData(ByteString.copyFrom((byte[])value)).build();
            return response;
        }
        catch (Exception e) {
            logger.error("Fail to get, k {}", (Object)key, (Object)e);
            throw e;
        }
        finally {
            readLock.unlock();
        }
    }

    public byte[] getRdb(RocksDBEngine rocksDBEngine, byte[] key) throws RocksDBException {
        Lock readLock = rocksDBEngine.getReadWriteLock().readLock();
        readLock.lock();
        try {
            byte[] value;
            byte[] byArray = value = rocksDBEngine.getRdb().get(key);
            return byArray;
        }
        catch (Exception e) {
            logger.error("Fail to get, k {}", (Object)key, (Object)e);
            throw e;
        }
        finally {
            readLock.unlock();
        }
    }

    public Response put(RocksDBEngine rocksDBEngine, byte[] key, byte[] value) throws RocksDBException {
        Lock writeLock = rocksDBEngine.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            rocksDBEngine.getRdb().put(rocksDBEngine.getWriteOptions(), key, value);
            Response response = Response.newBuilder().setSuccess(true).build();
            return response;
        }
        catch (Exception e) {
            logger.error("Fail to put, k {}, v {}", new Object[]{key, value, e});
            throw e;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Response delete(RocksDBEngine rocksDBEngine, byte[] key) throws Exception {
        Lock writeLock = rocksDBEngine.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            rocksDBEngine.getRdb().delete(rocksDBEngine.getWriteOptions(), key);
            Response response = Response.newBuilder().setSuccess(true).build();
            return response;
        }
        catch (Exception e) {
            logger.error("Fail to delete, k {}", (Object)key, (Object)e);
            throw e;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Response compareAndPut(RocksDBEngine rocksDBEngine, byte[] key, byte[] expectValue, byte[] updateValue) throws Exception {
        Lock writeLock = rocksDBEngine.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            byte[] actual = rocksDBEngine.getRdb().get(key);
            if (Arrays.equals(expectValue, actual)) {
                rocksDBEngine.getRdb().put(rocksDBEngine.getWriteOptions(), key, updateValue);
                Response response = Response.newBuilder().setSuccess(true).build();
                return response;
            }
            Response response = Response.newBuilder().setSuccess(false).build();
            return response;
        }
        catch (Exception e) {
            logger.error("Fail to delete, k {}", (Object)key, (Object)e);
            throw e;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Response scan(RocksDBEngine rocksDBEngine, byte[] startKey, byte[] endKey) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Lock readLock = rocksDBEngine.getReadWriteLock().readLock();
        readLock.lock();
        try {
            RocksIterator it = rocksDBEngine.getRdb().newIterator();
            if (startKey == null) {
                it.seekToFirst();
            } else {
                it.seek(startKey);
            }
            while (it.isValid()) {
                byte[] key = it.key();
                if (endKey != null && BytesUtil.compare((byte[])key, (byte[])endKey) >= 0) break;
                result.put(new String(key), new String(it.value()));
                it.next();
            }
            Response response = Response.newBuilder().setSuccess(true).putAllDataMap(result).build();
            return response;
        }
        catch (Exception e) {
            logger.error("Fail to delete, startKey {}, endKey {}", new Object[]{startKey, endKey, e});
            throw e;
        }
        finally {
            readLock.unlock();
        }
    }
}

