/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.ArrayList;
import org.eclipse.paho.client.mqttv3.BufferedMessage;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.IDisconnectedBufferCallback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class DisconnectedMessageBuffer
implements Runnable {
    private final String CLASS_NAME = "DisconnectedMessageBuffer";
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", "DisconnectedMessageBuffer");
    private DisconnectedBufferOptions bufferOpts;
    private ArrayList<BufferedMessage> buffer;
    private final Object bufLock = new Object();
    private IDisconnectedBufferCallback callback;
    private int mycount = 0;

    public DisconnectedMessageBuffer(DisconnectedBufferOptions options) {
        this.bufferOpts = options;
        this.buffer = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(MqttWireMessage message, MqttToken token) throws MqttException {
        BufferedMessage bufferedMessage = new BufferedMessage(message, token);
        Object object = this.bufLock;
        synchronized (object) {
            if (this.buffer.size() < this.bufferOpts.getBufferSize()) {
                this.buffer.add(bufferedMessage);
            } else if (this.bufferOpts.isDeleteOldestMessages()) {
                this.buffer.remove(0);
                this.buffer.add(bufferedMessage);
            } else {
                throw new MqttException(32203);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedMessage getMessage(int messageIndex) {
        Object object = this.bufLock;
        synchronized (object) {
            return this.buffer.get(messageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(int messageIndex) {
        Object object = this.bufLock;
        synchronized (object) {
            this.buffer.remove(messageIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        Object object = this.bufLock;
        synchronized (object) {
            return this.buffer.size();
        }
    }

    @Override
    public void run() {
        String methodName = "run";
        this.log.fine("DisconnectedMessageBuffer", "run", "516");
        while (this.getMessageCount() > 0) {
            try {
                BufferedMessage bufferedMessage = this.getMessage(0);
                this.callback.publishBufferedMessage(bufferedMessage);
                this.deleteMessage(0);
            }
            catch (MqttException ex) {
                if (ex.getReasonCode() == 32202) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                this.log.severe("DisconnectedMessageBuffer", "run", "519", new Object[]{ex.getReasonCode(), ex.getMessage()});
                break;
            }
        }
    }

    public void setPublishCallback(IDisconnectedBufferCallback callback) {
        this.callback = callback;
    }

    public boolean isPersistBuffer() {
        return this.bufferOpts.isPersistBuffer();
    }
}

