/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.rhea.client.DefaultRheaKVStore;
import com.alipay.sofa.jraft.rhea.client.RheaIterator;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverClient;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.util.BytesUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class DefaultRheaIterator
implements RheaIterator<KVEntry> {
    private final DefaultRheaKVStore rheaKVStore;
    private final PlacementDriverClient pdClient;
    private final byte[] startKey;
    private final byte[] endKey;
    private final boolean readOnlySafe;
    private final boolean returnValue;
    private final int bufSize;
    private final Queue<KVEntry> buf;
    private byte[] cursorKey;

    public DefaultRheaIterator(DefaultRheaKVStore rheaKVStore, byte[] startKey, byte[] endKey, int bufSize, boolean readOnlySafe, boolean returnValue) {
        this.rheaKVStore = rheaKVStore;
        this.pdClient = rheaKVStore.getPlacementDriverClient();
        this.startKey = BytesUtil.nullToEmpty((byte[])startKey);
        this.endKey = endKey;
        this.bufSize = bufSize;
        this.readOnlySafe = readOnlySafe;
        this.returnValue = returnValue;
        this.buf = new ArrayDeque<KVEntry>(bufSize);
        this.cursorKey = this.startKey;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.buf.isEmpty()) {
            while (this.endKey == null || BytesUtil.compare((byte[])this.cursorKey, (byte[])this.endKey) < 0) {
                List<KVEntry> kvEntries = this.rheaKVStore.singleRegionScan(this.cursorKey, this.endKey, this.bufSize, this.readOnlySafe, this.returnValue);
                if (kvEntries.isEmpty()) {
                    this.cursorKey = this.pdClient.findStartKeyOfNextRegion(this.cursorKey, false);
                    if (this.cursorKey != null) continue;
                    break;
                }
                KVEntry last = kvEntries.get(kvEntries.size() - 1);
                this.cursorKey = BytesUtil.nextBytes((byte[])last.getKey());
                this.buf.addAll(kvEntries);
                break;
            }
            return !this.buf.isEmpty();
        }
        return true;
    }

    @Override
    public synchronized KVEntry next() {
        if (this.buf.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf.poll();
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public boolean isReadOnlySafe() {
        return this.readOnlySafe;
    }

    public int getBufSize() {
        return this.bufSize;
    }
}

