/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.rhea.errors.RouteTableException;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metadata.RegionEpoch;
import com.alipay.sofa.jraft.rhea.storage.CASEntry;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.Requires;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.StampedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionRouteTable {
    private static final Logger LOG = LoggerFactory.getLogger(RegionRouteTable.class);
    private static final Comparator<byte[]> keyBytesComparator = BytesUtil.getDefaultByteArrayComparator();
    private final StampedLock stampedLock = new StampedLock();
    private final NavigableMap<byte[], Long> rangeTable = new TreeMap<byte[], Long>(keyBytesComparator);
    private final Map<Long, Region> regionTable = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegionById(long regionId) {
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.tryOptimisticRead();
        Region region = RegionRouteTable.safeCopy(this.regionTable.get(regionId));
        if (!stampedLock.validate(stamp)) {
            stamp = stampedLock.readLock();
            try {
                region = RegionRouteTable.safeCopy(this.regionTable.get(regionId));
            }
            finally {
                stampedLock.unlockRead(stamp);
            }
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateRegion(Region region) {
        Requires.requireNonNull((Object)region, (String)"region");
        Requires.requireNonNull((Object)region.getRegionEpoch(), (String)"regionEpoch");
        long regionId = region.getId();
        byte[] startKey = BytesUtil.nullToEmpty((byte[])region.getStartKey());
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.writeLock();
        try {
            this.regionTable.put(regionId, region.copy());
            this.rangeTable.put(startKey, regionId);
        }
        finally {
            stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitRegion(long leftId, Region right) {
        Requires.requireNonNull((Object)right, (String)"right");
        Requires.requireNonNull((Object)right.getRegionEpoch(), (String)"right.regionEpoch");
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.writeLock();
        try {
            Region left = this.regionTable.get(leftId);
            Requires.requireNonNull((Object)left, (String)"left");
            byte[] leftStartKey = BytesUtil.nullToEmpty((byte[])left.getStartKey());
            byte[] leftEndKey = left.getEndKey();
            long rightId = right.getId();
            byte[] rightStartKey = right.getStartKey();
            byte[] rightEndKey = right.getEndKey();
            Requires.requireNonNull((Object)rightStartKey, (String)"rightStartKey");
            Requires.requireTrue((BytesUtil.compare((byte[])leftStartKey, (byte[])rightStartKey) < 0 ? 1 : 0) != 0, (Object)"leftStartKey must < rightStartKey");
            if (leftEndKey == null || rightEndKey == null) {
                Requires.requireTrue((leftEndKey == rightEndKey ? 1 : 0) != 0, (Object)"leftEndKey must == rightEndKey");
            } else {
                Requires.requireTrue((BytesUtil.compare((byte[])leftEndKey, (byte[])rightEndKey) == 0 ? 1 : 0) != 0, (Object)"leftEndKey must == rightEndKey");
                Requires.requireTrue((BytesUtil.compare((byte[])rightStartKey, (byte[])rightEndKey) < 0 ? 1 : 0) != 0, (Object)"rightStartKey must < rightEndKey");
            }
            RegionEpoch leftEpoch = left.getRegionEpoch();
            leftEpoch.setVersion(leftEpoch.getVersion() + 1L);
            left.setEndKey(rightStartKey);
            this.regionTable.put(rightId, right.copy());
            this.rangeTable.put(rightStartKey, rightId);
        }
        finally {
            stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRegion(long regionId) {
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.writeLock();
        try {
            Region region = this.regionTable.remove(regionId);
            if (region != null) {
                byte[] startKey = BytesUtil.nullToEmpty((byte[])region.getStartKey());
                boolean bl = this.rangeTable.remove(startKey) != null;
                return bl;
            }
        }
        finally {
            stampedLock.unlockWrite(stamp);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region findRegionByKey(byte[] key) {
        Requires.requireNonNull((Object)key, (String)"key");
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.readLock();
        try {
            Region region = this.findRegionByKeyWithoutLock(key);
            return region;
        }
        finally {
            stampedLock.unlockRead(stamp);
        }
    }

    private Region findRegionByKeyWithoutLock(byte[] key) {
        Map.Entry<byte[], Long> entry = this.rangeTable.floorEntry(key);
        if (entry == null) {
            this.reportFail(key);
            throw RegionRouteTable.reject(key, "fail to find region by key");
        }
        return this.regionTable.get(entry.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Region, List<byte[]>> findRegionsByKeys(List<byte[]> keys) {
        Requires.requireNonNull(keys, (String)"keys");
        HashMap<Region, List> regionMap = Maps.newHashMap();
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.readLock();
        try {
            for (byte[] key : keys) {
                Region region = this.findRegionByKeyWithoutLock(key);
                regionMap.computeIfAbsent(region, k -> Lists.newArrayList()).add(key);
            }
            HashMap<Region, List> hashMap = regionMap;
            return hashMap;
        }
        finally {
            stampedLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Region, List<KVEntry>> findRegionsByKvEntries(List<KVEntry> kvEntries) {
        Requires.requireNonNull(kvEntries, (String)"kvEntries");
        HashMap<Region, List> regionMap = Maps.newHashMap();
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.readLock();
        try {
            for (KVEntry kvEntry : kvEntries) {
                Region region = this.findRegionByKeyWithoutLock(kvEntry.getKey());
                regionMap.computeIfAbsent(region, k -> Lists.newArrayList()).add(kvEntry);
            }
            HashMap<Region, List> hashMap = regionMap;
            return hashMap;
        }
        finally {
            stampedLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Region, List<CASEntry>> findRegionsByCASEntries(List<CASEntry> casEntries) {
        Requires.requireNonNull(casEntries, (String)"casEntries");
        HashMap<Region, List> regionMap = Maps.newHashMap();
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.readLock();
        try {
            for (CASEntry casEntry : casEntries) {
                Region region = this.findRegionByKeyWithoutLock(casEntry.getKey());
                regionMap.computeIfAbsent(region, k -> Lists.newArrayList()).add(casEntry);
            }
            HashMap<Region, List> hashMap = regionMap;
            return hashMap;
        }
        finally {
            stampedLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Region> findRegionsByKeyRange(byte[] startKey, byte[] endKey) {
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.readLock();
        try {
            byte[] realStartKey = BytesUtil.nullToEmpty((byte[])startKey);
            NavigableMap<byte[], Long> subRegionMap = endKey == null ? this.rangeTable.tailMap(realStartKey, false) : this.rangeTable.subMap(realStartKey, false, endKey, true);
            ArrayList<Region> regionList = Lists.newArrayListWithCapacity(subRegionMap.size() + 1);
            Map.Entry<byte[], Long> headEntry = this.rangeTable.floorEntry(realStartKey);
            if (headEntry == null) {
                this.reportFail(startKey);
                throw RegionRouteTable.reject(startKey, "fail to find region by startKey");
            }
            regionList.add(RegionRouteTable.safeCopy(this.regionTable.get(headEntry.getValue())));
            for (Long regionId : subRegionMap.values()) {
                regionList.add(RegionRouteTable.safeCopy(this.regionTable.get(regionId)));
            }
            ArrayList<Region> arrayList = regionList;
            return arrayList;
        }
        finally {
            stampedLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] findStartKeyOfNextRegion(byte[] key) {
        Requires.requireNonNull((Object)key, (String)"key");
        StampedLock stampedLock = this.stampedLock;
        long stamp = stampedLock.tryOptimisticRead();
        byte[] nextStartKey = this.rangeTable.higherKey(key);
        if (!stampedLock.validate(stamp)) {
            stamp = stampedLock.readLock();
            try {
                nextStartKey = this.rangeTable.higherKey(key);
            }
            finally {
                stampedLock.unlockRead(stamp);
            }
        }
        return nextStartKey;
    }

    private void reportFail(byte[] relatedKey) {
        if (LOG.isErrorEnabled()) {
            LOG.error("There is a high probability that the data in the region table is corrupted.");
            LOG.error("---------------------------------------------------------------------------");
            LOG.error("* RelatedKey:  {}.", (Object)BytesUtil.toHex((byte[])relatedKey));
            LOG.error("* RangeTable:  {}.", this.rangeTable);
            LOG.error("* RegionTable: {}.", this.regionTable);
            LOG.error("---------------------------------------------------------------------------");
        }
    }

    private static Region safeCopy(Region region) {
        if (region == null) {
            return null;
        }
        return region.copy();
    }

    private static RouteTableException reject(byte[] relatedKey, String message) {
        return new RouteTableException("key: " + BytesUtil.toHex((byte[])relatedKey) + ", message: " + message);
    }
}

