/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.metadata;

import com.alipay.sofa.jraft.rhea.metadata.Peer;
import com.alipay.sofa.jraft.rhea.metadata.RegionEpoch;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.Copiable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Region
implements Copiable<Region>,
Serializable {
    private static final long serialVersionUID = -2610978803578899118L;
    public static final long MIN_ID_WITH_MANUAL_CONF = -1L;
    public static final long MAX_ID_WITH_MANUAL_CONF = 1000000L;
    private long id;
    private byte[] startKey;
    private byte[] endKey;
    private RegionEpoch regionEpoch;
    private List<Peer> peers;

    public Region() {
    }

    public Region(long id, byte[] startKey, byte[] endKey, RegionEpoch regionEpoch, List<Peer> peers) {
        this.id = id;
        this.startKey = startKey;
        this.endKey = endKey;
        this.regionEpoch = regionEpoch;
        this.peers = peers;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public void setStartKey(byte[] startKey) {
        this.startKey = startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public void setEndKey(byte[] endKey) {
        this.endKey = endKey;
    }

    public RegionEpoch getRegionEpoch() {
        return this.regionEpoch;
    }

    public void setRegionEpoch(RegionEpoch regionEpoch) {
        this.regionEpoch = regionEpoch;
    }

    public List<Peer> getPeers() {
        return this.peers;
    }

    public void setPeers(List<Peer> peers) {
        this.peers = peers;
    }

    public Region copy() {
        RegionEpoch regionEpoch = null;
        if (this.regionEpoch != null) {
            regionEpoch = this.regionEpoch.copy();
        }
        ArrayList<Peer> peers = null;
        if (this.peers != null) {
            peers = Lists.newArrayListWithCapacity(this.peers.size());
            for (Peer peer : this.peers) {
                peers.add(peer.copy());
            }
        }
        return new Region(this.id, this.startKey, this.endKey, regionEpoch, peers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.id == region.id && Objects.equals(this.regionEpoch, region.regionEpoch);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.regionEpoch);
    }

    public String toString() {
        return "Region{id=" + this.id + ", startKey=" + BytesUtil.toHex((byte[])this.startKey) + ", endKey=" + BytesUtil.toHex((byte[])this.endKey) + ", regionEpoch=" + this.regionEpoch + ", peers=" + this.peers + '}';
    }
}

