/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rhea.StateListener;
import com.alipay.sofa.jraft.rhea.StoreEngine;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.IllegalKVOperationException;
import com.alipay.sofa.jraft.rhea.errors.StoreCodecException;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.rhea.serialization.Serializer;
import com.alipay.sofa.jraft.rhea.serialization.Serializers;
import com.alipay.sofa.jraft.rhea.storage.BatchRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.KVClosureAdapter;
import com.alipay.sofa.jraft.rhea.storage.KVOperation;
import com.alipay.sofa.jraft.rhea.storage.KVState;
import com.alipay.sofa.jraft.rhea.storage.KVStateOutputList;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.KVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.storage.KVStoreSnapshotFileFactory;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.alipay.sofa.jraft.util.BytesUtil;
import com.alipay.sofa.jraft.util.RecycleUtil;
import com.alipay.sofa.jraft.util.internal.ThrowUtil;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVStoreStateMachine
extends StateMachineAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KVStoreStateMachine.class);
    private final AtomicLong leaderTerm = new AtomicLong(-1L);
    private final Serializer serializer = Serializers.getDefault();
    private final Region region;
    private final StoreEngine storeEngine;
    private final BatchRawKVStore<?> rawKVStore;
    private final KVStoreSnapshotFile storeSnapshotFile;
    private final Meter applyMeter;
    private final Histogram batchWriteHistogram;

    public KVStoreStateMachine(Region region, StoreEngine storeEngine) {
        this.region = region;
        this.storeEngine = storeEngine;
        this.rawKVStore = storeEngine.getRawKVStore();
        this.storeSnapshotFile = KVStoreSnapshotFileFactory.getKVStoreSnapshotFile(this.rawKVStore);
        String regionStr = String.valueOf(this.region.getId());
        this.applyMeter = KVMetrics.meter("rhea-st-apply-qps", regionStr);
        this.batchWriteHistogram = KVMetrics.histogram("rhea-st-batch-write", regionStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApply(Iterator it) {
        int index = 0;
        int applied = 0;
        try {
            KVStateOutputList kvStates = KVStateOutputList.newInstance();
            while (it.hasNext()) {
                KVOperation kvOp;
                KVClosureAdapter done = (KVClosureAdapter)it.done();
                if (done != null) {
                    kvOp = done.getOperation();
                } else {
                    ByteBuffer buf = it.getData();
                    try {
                        kvOp = buf.hasArray() ? this.serializer.readObject(buf.array(), KVOperation.class) : this.serializer.readObject(buf, KVOperation.class);
                        if (kvOp != null && kvOp.isReadOp()) {
                            ++index;
                            it.next();
                            continue;
                        }
                    }
                    catch (Throwable t) {
                        ++index;
                        throw new StoreCodecException("Decode operation error", t);
                    }
                }
                KVState first = kvStates.getFirstElement();
                if (first != null && !first.isSameOp(kvOp)) {
                    applied += this.batchApplyAndRecycle(first.getOpByte(), kvStates);
                    kvStates = KVStateOutputList.newInstance();
                }
                kvStates.add(KVState.of(kvOp, done));
                ++index;
                it.next();
            }
            if (!kvStates.isEmpty()) {
                KVState first = kvStates.getFirstElement();
                assert (first != null);
                applied += this.batchApplyAndRecycle(first.getOpByte(), kvStates);
            }
        }
        catch (Throwable t) {
            LOG.error("StateMachine meet critical error: {}.", (Object)StackTraceUtil.stackTrace(t));
            it.setErrorAndRollback((long)(index - applied), new Status(RaftError.ESTATEMACHINE, "StateMachine meet critical error: %s.", new Object[]{t.getMessage()}));
        }
        finally {
            this.applyMeter.mark((long)applied);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int batchApplyAndRecycle(byte opByte, KVStateOutputList kvStates) {
        try {
            int size = kvStates.size();
            if (size == 0) {
                int n = 0;
                return n;
            }
            if (!KVOperation.isValidOp(opByte)) {
                throw new IllegalKVOperationException("Unknown operation: " + opByte);
            }
            Meter opApplyMeter = KVMetrics.meter("rhea-st-apply-qps", String.valueOf(this.region.getId()), KVOperation.opName(opByte));
            opApplyMeter.mark((long)size);
            this.batchWriteHistogram.update(size);
            this.batchApply(opByte, kvStates);
            int n = size;
            return n;
        }
        finally {
            RecycleUtil.recycle((Object)kvStates);
        }
    }

    private void batchApply(byte opType, KVStateOutputList kvStates) {
        switch (opType) {
            case 1: {
                this.rawKVStore.batchPut(kvStates);
                break;
            }
            case 2: {
                this.rawKVStore.batchPutIfAbsent(kvStates);
                break;
            }
            case 4: {
                this.rawKVStore.batchPutList(kvStates);
                break;
            }
            case 3: {
                this.rawKVStore.batchDelete(kvStates);
                break;
            }
            case 5: {
                this.rawKVStore.batchDeleteRange(kvStates);
                break;
            }
            case 18: {
                this.rawKVStore.batchDeleteList(kvStates);
                break;
            }
            case 6: {
                this.rawKVStore.batchGetSequence(kvStates);
                break;
            }
            case 7: {
                this.rawKVStore.batchNodeExecute(kvStates, this.isLeader());
                break;
            }
            case 8: {
                this.rawKVStore.batchTryLockWith(kvStates);
                break;
            }
            case 9: {
                this.rawKVStore.batchReleaseLockWith(kvStates);
                break;
            }
            case 10: {
                this.rawKVStore.batchGet(kvStates);
                break;
            }
            case 11: {
                this.rawKVStore.batchMultiGet(kvStates);
                break;
            }
            case 19: {
                this.rawKVStore.batchContainsKey(kvStates);
                break;
            }
            case 12: {
                this.rawKVStore.batchScan(kvStates);
                break;
            }
            case 20: {
                this.rawKVStore.batchReverseScan(kvStates);
                break;
            }
            case 13: {
                this.rawKVStore.batchGetAndPut(kvStates);
                break;
            }
            case 17: {
                this.rawKVStore.batchCompareAndPut(kvStates);
                break;
            }
            case 21: {
                this.rawKVStore.batchCompareAndPutAll(kvStates);
                break;
            }
            case 14: {
                this.rawKVStore.batchMerge(kvStates);
                break;
            }
            case 15: {
                this.rawKVStore.batchResetSequence(kvStates);
                break;
            }
            case 16: {
                this.doSplit(kvStates);
                break;
            }
            default: {
                throw new IllegalKVOperationException("Unknown operation: " + opType);
            }
        }
    }

    private void doSplit(KVStateOutputList kvStates) {
        byte[] parentKey = this.region.getStartKey();
        for (KVState kvState : kvStates) {
            KVOperation op = kvState.getOp();
            long currentRegionId = op.getCurrentRegionId();
            long newRegionId = op.getNewRegionId();
            byte[] splitKey = op.getKey();
            KVStoreClosure closure = kvState.getDone();
            try {
                this.rawKVStore.initFencingToken(parentKey, splitKey);
                this.storeEngine.doSplit(currentRegionId, newRegionId, splitKey);
                if (closure == null) continue;
                closure.setData(Boolean.TRUE);
                closure.run(Status.OK());
            }
            catch (Throwable t) {
                LOG.error("Fail to split, regionId={}, newRegionId={}, splitKey={}.", new Object[]{currentRegionId, newRegionId, BytesUtil.toHex((byte[])splitKey)});
                KVStoreStateMachine.setCriticalError(closure, t);
            }
        }
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        this.storeSnapshotFile.save(writer, this.region.copy(), done, this.storeEngine.getSnapshotExecutor());
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (this.isLeader()) {
            LOG.warn("Leader is not supposed to load snapshot.");
            return false;
        }
        return this.storeSnapshotFile.load(reader, this.region.copy());
    }

    public void onLeaderStart(long term) {
        super.onLeaderStart(term);
        this.leaderTerm.set(term);
        List<StateListener> listeners = this.storeEngine.getStateListenerContainer().getStateListenerGroup(this.getRegionId());
        if (listeners.isEmpty()) {
            return;
        }
        this.storeEngine.getRaftStateTrigger().execute(() -> {
            for (StateListener listener : listeners) {
                listener.onLeaderStart(term);
            }
        });
    }

    public void onLeaderStop(Status status) {
        super.onLeaderStop(status);
        long oldTerm = this.leaderTerm.get();
        this.leaderTerm.set(-1L);
        List<StateListener> listeners = this.storeEngine.getStateListenerContainer().getStateListenerGroup(this.getRegionId());
        if (listeners.isEmpty()) {
            return;
        }
        this.storeEngine.getRaftStateTrigger().execute(() -> {
            for (StateListener listener : listeners) {
                listener.onLeaderStop(oldTerm);
            }
        });
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        super.onStartFollowing(ctx);
        List<StateListener> listeners = this.storeEngine.getStateListenerContainer().getStateListenerGroup(this.getRegionId());
        if (listeners.isEmpty()) {
            return;
        }
        this.storeEngine.getRaftStateTrigger().execute(() -> {
            for (StateListener listener : listeners) {
                listener.onStartFollowing(ctx.getLeaderId(), ctx.getTerm());
            }
        });
    }

    public void onStopFollowing(LeaderChangeContext ctx) {
        super.onStopFollowing(ctx);
        List<StateListener> listeners = this.storeEngine.getStateListenerContainer().getStateListenerGroup(this.getRegionId());
        if (listeners.isEmpty()) {
            return;
        }
        this.storeEngine.getRaftStateTrigger().execute(() -> {
            for (StateListener listener : listeners) {
                listener.onStopFollowing(ctx.getLeaderId(), ctx.getTerm());
            }
        });
    }

    public boolean isLeader() {
        return this.leaderTerm.get() > 0L;
    }

    public long getRegionId() {
        return this.region.getId();
    }

    private static void setCriticalError(KVStoreClosure closure, Throwable ex) {
        if (closure != null) {
            closure.setError(Errors.forException(ex));
        }
        ThrowUtil.throwException((Throwable)ex);
    }
}

