/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.closure.ReadIndexClosure;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.serialization.Serializers;
import com.alipay.sofa.jraft.rhea.storage.CASEntry;
import com.alipay.sofa.jraft.rhea.storage.KVClosureAdapter;
import com.alipay.sofa.jraft.rhea.storage.KVEntry;
import com.alipay.sofa.jraft.rhea.storage.KVIterator;
import com.alipay.sofa.jraft.rhea.storage.KVOperation;
import com.alipay.sofa.jraft.rhea.storage.KVStoreClosure;
import com.alipay.sofa.jraft.rhea.storage.NodeExecutor;
import com.alipay.sofa.jraft.rhea.storage.RawKVStore;
import com.alipay.sofa.jraft.rhea.util.Clock;
import com.alipay.sofa.jraft.rhea.util.Pair;
import com.alipay.sofa.jraft.rhea.util.concurrent.DistributedLock;
import com.alipay.sofa.jraft.util.BytesUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftRawKVStore
implements RawKVStore {
    private static final Logger LOG = LoggerFactory.getLogger(RaftRawKVStore.class);
    private final Node node;
    private final RawKVStore kvStore;
    private final Executor readIndexExecutor;

    public RaftRawKVStore(Node node, RawKVStore kvStore, Executor readIndexExecutor) {
        this.node = node;
        this.kvStore = kvStore;
        this.readIndexExecutor = readIndexExecutor;
    }

    @Override
    public KVIterator localIterator() {
        return this.kvStore.localIterator();
    }

    @Override
    public void get(byte[] key, KVStoreClosure closure) {
        this.get(key, true, closure);
    }

    @Override
    public void get(final byte[] key, boolean readOnlySafe, final KVStoreClosure closure) {
        if (!readOnlySafe) {
            this.kvStore.get(key, false, closure);
            return;
        }
        this.node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

            public void run(Status status, long index, byte[] reqCtx) {
                if (status.isOk()) {
                    RaftRawKVStore.this.kvStore.get(key, true, closure);
                    return;
                }
                RaftRawKVStore.this.readIndexExecutor.execute(() -> {
                    if (RaftRawKVStore.this.isLeader()) {
                        LOG.warn("Fail to [get] with 'ReadIndex': {}, try to applying to the state machine.", (Object)status);
                        RaftRawKVStore.this.applyOperation(KVOperation.createGet(key), closure);
                    } else {
                        LOG.warn("Fail to [get] with 'ReadIndex': {}.", (Object)status);
                        new KVClosureAdapter(closure, null).run(status);
                    }
                });
            }
        });
    }

    @Override
    public void multiGet(List<byte[]> keys, KVStoreClosure closure) {
        this.multiGet(keys, true, closure);
    }

    @Override
    public void multiGet(final List<byte[]> keys, boolean readOnlySafe, final KVStoreClosure closure) {
        if (!readOnlySafe) {
            this.kvStore.multiGet(keys, false, closure);
            return;
        }
        this.node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

            public void run(Status status, long index, byte[] reqCtx) {
                if (status.isOk()) {
                    RaftRawKVStore.this.kvStore.multiGet(keys, true, closure);
                    return;
                }
                RaftRawKVStore.this.readIndexExecutor.execute(() -> {
                    if (RaftRawKVStore.this.isLeader()) {
                        LOG.warn("Fail to [multiGet] with 'ReadIndex': {}, try to applying to the state machine.", (Object)status);
                        RaftRawKVStore.this.applyOperation(KVOperation.createMultiGet(keys), closure);
                    } else {
                        LOG.warn("Fail to [multiGet] with 'ReadIndex': {}.", (Object)status);
                        new KVClosureAdapter(closure, null).run(status);
                    }
                });
            }
        });
    }

    @Override
    public void containsKey(final byte[] key, final KVStoreClosure closure) {
        this.node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

            public void run(Status status, long index, byte[] reqCtx) {
                if (status.isOk()) {
                    RaftRawKVStore.this.kvStore.containsKey(key, closure);
                    return;
                }
                RaftRawKVStore.this.readIndexExecutor.execute(() -> {
                    if (RaftRawKVStore.this.isLeader()) {
                        LOG.warn("Fail to [containsKey] with 'ReadIndex': {}, try to applying to the state machine.", (Object)status);
                        RaftRawKVStore.this.applyOperation(KVOperation.createContainsKey(key), closure);
                    } else {
                        LOG.warn("Fail to [containsKey] with 'ReadIndex': {}.", (Object)status);
                        new KVClosureAdapter(closure, null).run(status);
                    }
                });
            }
        });
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, boolean readOnlySafe, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        this.scan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, returnValue, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, KVStoreClosure closure) {
        this.scan(startKey, endKey, limit, true, closure);
    }

    @Override
    public void scan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, KVStoreClosure closure) {
        this.scan(startKey, endKey, limit, readOnlySafe, true, closure);
    }

    @Override
    public void scan(final byte[] startKey, final byte[] endKey, final int limit, boolean readOnlySafe, final boolean returnValue, final KVStoreClosure closure) {
        if (!readOnlySafe) {
            this.kvStore.scan(startKey, endKey, limit, false, returnValue, closure);
            return;
        }
        this.node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

            public void run(Status status, long index, byte[] reqCtx) {
                if (status.isOk()) {
                    RaftRawKVStore.this.kvStore.scan(startKey, endKey, limit, true, returnValue, closure);
                    return;
                }
                RaftRawKVStore.this.readIndexExecutor.execute(() -> {
                    if (RaftRawKVStore.this.isLeader()) {
                        LOG.warn("Fail to [scan] with 'ReadIndex': {}, try to applying to the state machine.", (Object)status);
                        RaftRawKVStore.this.applyOperation(KVOperation.createScan(startKey, endKey, limit, returnValue), closure);
                    } else {
                        LOG.warn("Fail to [scan] with 'ReadIndex': {}.", (Object)status);
                        new KVClosureAdapter(closure, null).run(status);
                    }
                });
            }
        });
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, Integer.MAX_VALUE, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, boolean readOnlySafe, boolean returnValue, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, Integer.MAX_VALUE, readOnlySafe, returnValue, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, int limit, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, limit, true, closure);
    }

    @Override
    public void reverseScan(byte[] startKey, byte[] endKey, int limit, boolean readOnlySafe, KVStoreClosure closure) {
        this.reverseScan(startKey, endKey, limit, readOnlySafe, true, closure);
    }

    @Override
    public void reverseScan(final byte[] startKey, final byte[] endKey, final int limit, boolean readOnlySafe, final boolean returnValue, final KVStoreClosure closure) {
        if (!readOnlySafe) {
            this.kvStore.reverseScan(startKey, endKey, limit, false, returnValue, closure);
            return;
        }
        this.node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

            public void run(Status status, long index, byte[] reqCtx) {
                if (status.isOk()) {
                    RaftRawKVStore.this.kvStore.reverseScan(startKey, endKey, limit, true, returnValue, closure);
                    return;
                }
                RaftRawKVStore.this.readIndexExecutor.execute(() -> {
                    if (RaftRawKVStore.this.isLeader()) {
                        LOG.warn("Fail to [reverseScan] with 'ReadIndex': {}, try to applying to the state machine.", (Object)status);
                        RaftRawKVStore.this.applyOperation(KVOperation.createReverseScan(startKey, endKey, limit, returnValue), closure);
                    } else {
                        LOG.warn("Fail to [reverseScan] with 'ReadIndex': {}.", (Object)status);
                        new KVClosureAdapter(closure, null).run(status);
                    }
                });
            }
        });
    }

    @Override
    public void getSequence(final byte[] seqKey, int step, final KVStoreClosure closure) {
        if (step > 0) {
            this.applyOperation(KVOperation.createGetSequence(seqKey, step), closure);
            return;
        }
        this.node.readIndex(BytesUtil.EMPTY_BYTES, new ReadIndexClosure(){

            public void run(Status status, long index, byte[] reqCtx) {
                if (status.isOk()) {
                    RaftRawKVStore.this.kvStore.getSequence(seqKey, 0, closure);
                    return;
                }
                RaftRawKVStore.this.readIndexExecutor.execute(() -> {
                    if (RaftRawKVStore.this.isLeader()) {
                        LOG.warn("Fail to [getSequence] with 'ReadIndex': {}, try to applying to the state machine.", (Object)status);
                        RaftRawKVStore.this.applyOperation(KVOperation.createGetSequence(seqKey, 0), closure);
                    } else {
                        LOG.warn("Fail to [getSequence] with 'ReadIndex': {}.", (Object)status);
                        new KVClosureAdapter(closure, null).run(status);
                    }
                });
            }
        });
    }

    @Override
    public void resetSequence(byte[] seqKey, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createResetSequence(seqKey), closure);
    }

    @Override
    public void put(byte[] key, byte[] value, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createPut(key, value), closure);
    }

    @Override
    public void getAndPut(byte[] key, byte[] value, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createGetAndPut(key, value), closure);
    }

    @Override
    public void compareAndPut(byte[] key, byte[] expect, byte[] update, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createCompareAndPut(key, expect, update), closure);
    }

    @Override
    public void merge(byte[] key, byte[] value, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createMerge(key, value), closure);
    }

    @Override
    public void put(List<KVEntry> entries, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createPutList(entries), closure);
    }

    @Override
    public void compareAndPutAll(List<CASEntry> entries, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createCompareAndPutAll(entries), closure);
    }

    @Override
    public void putIfAbsent(byte[] key, byte[] value, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createPutIfAbsent(key, value), closure);
    }

    @Override
    public void tryLockWith(byte[] key, byte[] fencingKey, boolean keepLease, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        acquirer.setLockingTimestamp(Clock.defaultClock().getTime());
        this.applyOperation(KVOperation.createKeyLockRequest(key, fencingKey, Pair.of(keepLease, acquirer)), closure);
    }

    @Override
    public void releaseLockWith(byte[] key, DistributedLock.Acquirer acquirer, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createKeyLockReleaseRequest(key, acquirer), closure);
    }

    @Override
    public void delete(byte[] key, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createDelete(key), closure);
    }

    @Override
    public void deleteRange(byte[] startKey, byte[] endKey, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createDeleteRange(startKey, endKey), closure);
    }

    @Override
    public void delete(List<byte[]> keys, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createDeleteList(keys), closure);
    }

    @Override
    public void execute(NodeExecutor nodeExecutor, boolean isLeader, KVStoreClosure closure) {
        this.applyOperation(KVOperation.createNodeExecutor(nodeExecutor), closure);
    }

    private void applyOperation(KVOperation op, KVStoreClosure closure) {
        if (!this.isLeader()) {
            closure.setError(Errors.NOT_LEADER);
            closure.run(new Status(RaftError.EPERM, "Not leader", new Object[0]));
            return;
        }
        Task task = new Task();
        task.setData(ByteBuffer.wrap(Serializers.getDefault().writeObject(op)));
        task.setDone((Closure)new KVClosureAdapter(closure, op));
        this.node.apply(task);
    }

    private boolean isLeader() {
        return this.node.isLeader(false);
    }
}

