/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.rhea.errors.StorageException;
import com.alipay.sofa.jraft.rhea.metadata.Region;
import com.alipay.sofa.jraft.rhea.storage.AbstractKVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.storage.RocksDBBackupInfo;
import com.alipay.sofa.jraft.rhea.storage.RocksRawKVStore;
import com.alipay.sofa.jraft.rhea.util.RegionHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class RocksKVStoreSnapshotFile
extends AbstractKVStoreSnapshotFile {
    private final RocksRawKVStore kvStore;

    RocksKVStoreSnapshotFile(RocksRawKVStore kvStore) {
        this.kvStore = kvStore;
    }

    @Override
    CompletableFuture<LocalFileMetaOutter.LocalFileMeta.Builder> doSnapshotSave(String snapshotPath, Region region, ExecutorService executor) throws Exception {
        if (RegionHelper.isMultiGroup(region)) {
            CompletableFuture<Void> snapshotFuture = this.kvStore.writeSstSnapshot(snapshotPath, region, executor);
            CompletableFuture<LocalFileMetaOutter.LocalFileMeta.Builder> metaFuture = new CompletableFuture<LocalFileMetaOutter.LocalFileMeta.Builder>();
            snapshotFuture.whenComplete((aVoid, throwable) -> {
                if (throwable == null) {
                    metaFuture.complete(this.writeMetadata(region));
                } else {
                    metaFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return metaFuture;
        }
        if (this.kvStore.isFastSnapshot()) {
            this.kvStore.writeSnapshot(snapshotPath);
            return CompletableFuture.completedFuture(this.writeMetadata(null));
        }
        RocksDBBackupInfo backupInfo = this.kvStore.backupDB(snapshotPath);
        return CompletableFuture.completedFuture(this.writeMetadata(backupInfo));
    }

    @Override
    void doSnapshotLoad(String snapshotPath, LocalFileMetaOutter.LocalFileMeta meta, Region region) throws Exception {
        if (RegionHelper.isMultiGroup(region)) {
            Region snapshotRegion = this.readMetadata(meta, Region.class);
            if (!RegionHelper.isSameRange(region, snapshotRegion)) {
                throw new StorageException("Invalid snapshot region: " + snapshotRegion + " current region is: " + region);
            }
            this.kvStore.readSstSnapshot(snapshotPath);
            return;
        }
        if (this.kvStore.isFastSnapshot()) {
            this.kvStore.readSnapshot(snapshotPath);
            return;
        }
        RocksDBBackupInfo rocksBackupInfo = this.readMetadata(meta, RocksDBBackupInfo.class);
        this.kvStore.restoreBackup(snapshotPath, rocksBackupInfo);
    }
}

