/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.internal;

import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnsafeDirectBufferUtil {
    private static final Logger LOG;
    private static final UnsafeUtil.UnsafeAccessor UNSAFE_ACCESSOR;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    private static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;
    private static final boolean BIG_ENDIAN_NATIVE_ORDER;
    private static final boolean UNALIGNED;

    public static byte getByte(long address) {
        return UNSAFE_ACCESSOR.getByte(address);
    }

    public static short getShort(long address) {
        if (UNALIGNED) {
            short v = UNSAFE_ACCESSOR.getShort(address);
            return BIG_ENDIAN_NATIVE_ORDER ? v : Short.reverseBytes(v);
        }
        return (short)(UNSAFE_ACCESSOR.getByte(address) << 8 | UNSAFE_ACCESSOR.getByte(address + 1L) & 0xFF);
    }

    public static short getShortLE(long address) {
        if (UNALIGNED) {
            short v = UNSAFE_ACCESSOR.getShort(address);
            return BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes(v) : v;
        }
        return (short)(UNSAFE_ACCESSOR.getByte(address) & 0xFF | UNSAFE_ACCESSOR.getByte(address + 1L) << 8);
    }

    public static int getInt(long address) {
        if (UNALIGNED) {
            int v = UNSAFE_ACCESSOR.getInt(address);
            return BIG_ENDIAN_NATIVE_ORDER ? v : Integer.reverseBytes(v);
        }
        return UNSAFE_ACCESSOR.getByte(address) << 24 | (UNSAFE_ACCESSOR.getByte(address + 1L) & 0xFF) << 16 | (UNSAFE_ACCESSOR.getByte(address + 2L) & 0xFF) << 8 | UNSAFE_ACCESSOR.getByte(address + 3L) & 0xFF;
    }

    public static int getIntLE(long address) {
        if (UNALIGNED) {
            int v = UNSAFE_ACCESSOR.getInt(address);
            return BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(v) : v;
        }
        return UNSAFE_ACCESSOR.getByte(address) & 0xFF | (UNSAFE_ACCESSOR.getByte(address + 1L) & 0xFF) << 8 | (UNSAFE_ACCESSOR.getByte(address + 2L) & 0xFF) << 16 | UNSAFE_ACCESSOR.getByte(address + 3L) << 24;
    }

    public static long getLong(long address) {
        if (UNALIGNED) {
            long v = UNSAFE_ACCESSOR.getLong(address);
            return BIG_ENDIAN_NATIVE_ORDER ? v : Long.reverseBytes(v);
        }
        return (long)UNSAFE_ACCESSOR.getByte(address) << 56 | ((long)UNSAFE_ACCESSOR.getByte(address + 1L) & 0xFFL) << 48 | ((long)UNSAFE_ACCESSOR.getByte(address + 2L) & 0xFFL) << 40 | ((long)UNSAFE_ACCESSOR.getByte(address + 3L) & 0xFFL) << 32 | ((long)UNSAFE_ACCESSOR.getByte(address + 4L) & 0xFFL) << 24 | ((long)UNSAFE_ACCESSOR.getByte(address + 5L) & 0xFFL) << 16 | ((long)UNSAFE_ACCESSOR.getByte(address + 6L) & 0xFFL) << 8 | (long)UNSAFE_ACCESSOR.getByte(address + 7L) & 0xFFL;
    }

    public static long getLongLE(long address) {
        if (UNALIGNED) {
            long v = UNSAFE_ACCESSOR.getLong(address);
            return BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(v) : v;
        }
        return (long)UNSAFE_ACCESSOR.getByte(address) & 0xFFL | ((long)UNSAFE_ACCESSOR.getByte(address + 1L) & 0xFFL) << 8 | ((long)UNSAFE_ACCESSOR.getByte(address + 2L) & 0xFFL) << 16 | ((long)UNSAFE_ACCESSOR.getByte(address + 3L) & 0xFFL) << 24 | ((long)UNSAFE_ACCESSOR.getByte(address + 4L) & 0xFFL) << 32 | ((long)UNSAFE_ACCESSOR.getByte(address + 5L) & 0xFFL) << 40 | ((long)UNSAFE_ACCESSOR.getByte(address + 6L) & 0xFFL) << 48 | (long)UNSAFE_ACCESSOR.getByte(address + 7L) << 56;
    }

    public static void getBytes(long address, byte[] dst, int dstIndex, int length) {
        if (length > 6) {
            UnsafeDirectBufferUtil.copyMemory(null, address, dst, BYTE_ARRAY_BASE_OFFSET + (long)dstIndex, length);
        } else {
            int end = dstIndex + length;
            for (int i = dstIndex; i < end; ++i) {
                dst[i] = UNSAFE_ACCESSOR.getByte(address++);
            }
        }
    }

    public static void setByte(long address, int value) {
        UNSAFE_ACCESSOR.putByte(address, (byte)value);
    }

    public static void setShort(long address, int value) {
        if (UNALIGNED) {
            UNSAFE_ACCESSOR.putShort(address, BIG_ENDIAN_NATIVE_ORDER ? (short)value : Short.reverseBytes((short)value));
        } else {
            UNSAFE_ACCESSOR.putByte(address, (byte)(value >>> 8));
            UNSAFE_ACCESSOR.putByte(address + 1L, (byte)value);
        }
    }

    public static void setShortLE(long address, int value) {
        if (UNALIGNED) {
            UNSAFE_ACCESSOR.putShort(address, BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)value) : (short)value);
        } else {
            UNSAFE_ACCESSOR.putByte(address, (byte)value);
            UNSAFE_ACCESSOR.putByte(address + 1L, (byte)(value >>> 8));
        }
    }

    public static void setInt(long address, int value) {
        if (UNALIGNED) {
            UNSAFE_ACCESSOR.putInt(address, BIG_ENDIAN_NATIVE_ORDER ? value : Integer.reverseBytes(value));
        } else {
            UNSAFE_ACCESSOR.putByte(address, (byte)(value >>> 24));
            UNSAFE_ACCESSOR.putByte(address + 1L, (byte)(value >>> 16));
            UNSAFE_ACCESSOR.putByte(address + 2L, (byte)(value >>> 8));
            UNSAFE_ACCESSOR.putByte(address + 3L, (byte)value);
        }
    }

    public static void setIntLE(long address, int value) {
        if (UNALIGNED) {
            UNSAFE_ACCESSOR.putInt(address, BIG_ENDIAN_NATIVE_ORDER ? Integer.reverseBytes(value) : value);
        } else {
            UNSAFE_ACCESSOR.putByte(address, (byte)value);
            UNSAFE_ACCESSOR.putByte(address + 1L, (byte)(value >>> 8));
            UNSAFE_ACCESSOR.putByte(address + 2L, (byte)(value >>> 16));
            UNSAFE_ACCESSOR.putByte(address + 3L, (byte)(value >>> 24));
        }
    }

    public static void setLong(long address, long value) {
        if (UNALIGNED) {
            UNSAFE_ACCESSOR.putLong(address, BIG_ENDIAN_NATIVE_ORDER ? value : Long.reverseBytes(value));
        } else {
            UNSAFE_ACCESSOR.putByte(address, (byte)(value >>> 56));
            UNSAFE_ACCESSOR.putByte(address + 1L, (byte)(value >>> 48));
            UNSAFE_ACCESSOR.putByte(address + 2L, (byte)(value >>> 40));
            UNSAFE_ACCESSOR.putByte(address + 3L, (byte)(value >>> 32));
            UNSAFE_ACCESSOR.putByte(address + 4L, (byte)(value >>> 24));
            UNSAFE_ACCESSOR.putByte(address + 5L, (byte)(value >>> 16));
            UNSAFE_ACCESSOR.putByte(address + 6L, (byte)(value >>> 8));
            UNSAFE_ACCESSOR.putByte(address + 7L, (byte)value);
        }
    }

    public static void setLongLE(long address, long value) {
        if (UNALIGNED) {
            UNSAFE_ACCESSOR.putLong(address, BIG_ENDIAN_NATIVE_ORDER ? Long.reverseBytes(value) : value);
        } else {
            UNSAFE_ACCESSOR.putByte(address, (byte)value);
            UNSAFE_ACCESSOR.putByte(address + 1L, (byte)(value >>> 8));
            UNSAFE_ACCESSOR.putByte(address + 2L, (byte)(value >>> 16));
            UNSAFE_ACCESSOR.putByte(address + 3L, (byte)(value >>> 24));
            UNSAFE_ACCESSOR.putByte(address + 4L, (byte)(value >>> 32));
            UNSAFE_ACCESSOR.putByte(address + 5L, (byte)(value >>> 40));
            UNSAFE_ACCESSOR.putByte(address + 6L, (byte)(value >>> 48));
            UNSAFE_ACCESSOR.putByte(address + 7L, (byte)(value >>> 56));
        }
    }

    public static void setBytes(long address, byte[] src, int srcIndex, int length) {
        if (length > 6) {
            UnsafeDirectBufferUtil.copyMemory(src, BYTE_ARRAY_BASE_OFFSET + (long)srcIndex, null, address, length);
        } else {
            int end = srcIndex + length;
            for (int i = srcIndex; i < end; ++i) {
                UNSAFE_ACCESSOR.putByte(address++, src[i]);
            }
        }
    }

    private static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE_ACCESSOR.copyMemory(src, srcOffset, dst, dstOffset, size);
            length -= size;
            srcOffset += size;
            dstOffset += size;
        }
    }

    private UnsafeDirectBufferUtil() {
    }

    static {
        boolean _unaligned;
        LOG = LoggerFactory.getLogger(UnsafeDirectBufferUtil.class);
        UNSAFE_ACCESSOR = UnsafeUtil.getUnsafeAccessor();
        BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
        BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        try {
            Class<?> bitsClass = Class.forName("java.nio.Bits", false, UnsafeUtil.getSystemClassLoader());
            Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
            unalignedMethod.setAccessible(true);
            _unaligned = (Boolean)unalignedMethod.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("java.nio.Bits: unavailable, {}.", (Object)StackTraceUtil.stackTrace(t));
            }
            _unaligned = false;
        }
        UNALIGNED = _unaligned;
    }
}

