/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.MappedFile;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class ConsumeQueueExt {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqStore");
    private final MappedFileQueue mappedFileQueue;
    private final String topic;
    private final int queueId;
    private final String storePath;
    private final int mappedFileSize;
    private ByteBuffer tempContainer;
    public static final int END_BLANK_DATA_LENGTH = 4;
    public static final long MAX_ADDR = -2147483649L;
    public static final long MAX_REAL_OFFSET = 0x7FFFFFFF7FFFFFFFL;

    public ConsumeQueueExt(String topic, int queueId, String storePath, int mappedFileSize, int bitMapLength) {
        this.storePath = storePath;
        this.mappedFileSize = mappedFileSize;
        this.topic = topic;
        this.queueId = queueId;
        String queueDir = this.storePath + File.separator + topic + File.separator + queueId;
        this.mappedFileQueue = new MappedFileQueue(queueDir, mappedFileSize, null);
        if (bitMapLength > 0) {
            this.tempContainer = ByteBuffer.allocate(bitMapLength / 8);
        }
    }

    public static boolean isExtAddr(long address) {
        return address <= -2147483649L;
    }

    public long unDecorate(long address) {
        if (ConsumeQueueExt.isExtAddr(address)) {
            return address - Long.MIN_VALUE;
        }
        return address;
    }

    public long decorate(long offset) {
        if (!ConsumeQueueExt.isExtAddr(offset)) {
            return offset + Long.MIN_VALUE;
        }
        return offset;
    }

    public CqExtUnit get(long address) {
        CqExtUnit cqExtUnit = new CqExtUnit();
        if (this.get(address, cqExtUnit)) {
            return cqExtUnit;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(long address, CqExtUnit cqExtUnit) {
        long realOffset;
        if (!ConsumeQueueExt.isExtAddr(address)) {
            return false;
        }
        int mappedFileSize = this.mappedFileSize;
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(realOffset, (realOffset = this.unDecorate(address)) == 0L);
        if (mappedFile == null) {
            return false;
        }
        int pos = (int)(realOffset % (long)mappedFileSize);
        SelectMappedBufferResult bufferResult = mappedFile.selectMappedBuffer(pos);
        if (bufferResult == null) {
            log.warn("[BUG] Consume queue extend unit({}) is not found!", (Object)realOffset);
            return false;
        }
        boolean ret = false;
        try {
            ret = cqExtUnit.read(bufferResult.getByteBuffer());
        }
        finally {
            bufferResult.release();
        }
        return ret;
    }

    public long put(CqExtUnit cqExtUnit) {
        int retryTimes = 3;
        try {
            int size = cqExtUnit.calcUnitSize();
            if (size > Short.MAX_VALUE) {
                log.error("Size of cq ext unit is greater than {}, {}", (Object)Short.MAX_VALUE, (Object)cqExtUnit);
                return 1L;
            }
            if (this.mappedFileQueue.getMaxOffset() + (long)size > 0x7FFFFFFF7FFFFFFFL) {
                log.warn("Capacity of ext is maximum!{}, {}", (Object)this.mappedFileQueue.getMaxOffset(), (Object)size);
                return 1L;
            }
            if (this.tempContainer == null || this.tempContainer.capacity() < size) {
                this.tempContainer = ByteBuffer.allocate(size);
            }
            for (int i = 0; i < 3; ++i) {
                MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
                if (mappedFile == null || mappedFile.isFull()) {
                    mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
                }
                if (mappedFile == null) {
                    log.error("Create mapped file when save consume queue extend, {}", (Object)cqExtUnit);
                    continue;
                }
                int wrotePosition = mappedFile.getWrotePosition();
                int blankSize = this.mappedFileSize - wrotePosition - 4;
                if (size > blankSize) {
                    this.fullFillToEnd(mappedFile, wrotePosition);
                    log.info("No enough space(need:{}, has:{}) of file {}, so fill to end", new Object[]{size, blankSize, mappedFile.getFileName()});
                    continue;
                }
                if (!mappedFile.appendMessage(cqExtUnit.write(this.tempContainer), 0, size)) continue;
                return this.decorate((long)wrotePosition + mappedFile.getFileFromOffset());
            }
        }
        catch (Throwable e) {
            log.error("Save consume queue extend error, " + cqExtUnit, e);
        }
        return 1L;
    }

    protected void fullFillToEnd(MappedFile mappedFile, int wrotePosition) {
        ByteBuffer mappedFileBuffer = mappedFile.sliceByteBuffer();
        mappedFileBuffer.position(wrotePosition);
        mappedFileBuffer.putShort((short)-1);
        mappedFile.setWrotePosition(this.mappedFileSize);
    }

    public boolean load() {
        boolean result = this.mappedFileQueue.load();
        log.info("load consume queue extend" + this.topic + "-" + this.queueId + " " + (result ? "OK" : "Failed"));
        return result;
    }

    public void checkSelf() {
        this.mappedFileQueue.checkSelf();
    }

    public void recover() {
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (mappedFiles == null || mappedFiles.isEmpty()) {
            return;
        }
        int index = 0;
        MappedFile mappedFile = mappedFiles.get(index);
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        long processOffset = mappedFile.getFileFromOffset();
        long mappedFileOffset = 0L;
        CqExtUnit extUnit = new CqExtUnit();
        while (true) {
            extUnit.readBySkip(byteBuffer);
            if (extUnit.getSize() > 0) {
                mappedFileOffset += (long)extUnit.getSize();
                continue;
            }
            if (++index >= mappedFiles.size()) break;
            mappedFile = mappedFiles.get(index);
            byteBuffer = mappedFile.sliceByteBuffer();
            processOffset = mappedFile.getFileFromOffset();
            mappedFileOffset = 0L;
            log.info("Recover next consume queue extend file, " + mappedFile.getFileName());
        }
        log.info("All files of consume queue extend has been recovered over, last mapped file " + mappedFile.getFileName());
        this.mappedFileQueue.setFlushedWhere(processOffset += mappedFileOffset);
        this.mappedFileQueue.setCommittedWhere(processOffset);
        this.mappedFileQueue.truncateDirtyFiles(processOffset);
    }

    public void truncateByMinAddress(long minAddress) {
        if (!ConsumeQueueExt.isExtAddr(minAddress)) {
            return;
        }
        log.info("Truncate consume queue ext by min {}.", (Object)minAddress);
        ArrayList<MappedFile> willRemoveFiles = new ArrayList<MappedFile>();
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        long realOffset = this.unDecorate(minAddress);
        for (MappedFile file : mappedFiles) {
            long fileTailOffset = file.getFileFromOffset() + (long)this.mappedFileSize;
            if (fileTailOffset >= realOffset) continue;
            log.info("Destroy consume queue ext by min: file={}, fileTailOffset={}, minOffset={}", new Object[]{file.getFileName(), fileTailOffset, realOffset});
            if (!file.destroy(1000L)) continue;
            willRemoveFiles.add(file);
        }
        this.mappedFileQueue.deleteExpiredFile(willRemoveFiles);
    }

    public void truncateByMaxAddress(long maxAddress) {
        if (!ConsumeQueueExt.isExtAddr(maxAddress)) {
            return;
        }
        log.info("Truncate consume queue ext by max {}.", (Object)maxAddress);
        CqExtUnit cqExtUnit = this.get(maxAddress);
        if (cqExtUnit == null) {
            log.error("[BUG] address {} of consume queue extend not found!", (Object)maxAddress);
            return;
        }
        long realOffset = this.unDecorate(maxAddress);
        this.mappedFileQueue.truncateDirtyFiles(realOffset + (long)cqExtUnit.getSize());
    }

    public boolean flush(int flushLeastPages) {
        return this.mappedFileQueue.flush(flushLeastPages);
    }

    public void destroy() {
        this.mappedFileQueue.destroy();
    }

    public long getMaxAddress() {
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        if (mappedFile == null) {
            return this.decorate(0L);
        }
        return this.decorate(mappedFile.getFileFromOffset() + (long)mappedFile.getWrotePosition());
    }

    public long getMinAddress() {
        MappedFile firstFile = this.mappedFileQueue.getFirstMappedFile();
        if (firstFile == null) {
            return this.decorate(0L);
        }
        return this.decorate(firstFile.getFileFromOffset());
    }

    public static class CqExtUnit {
        public static final short MIN_EXT_UNIT_SIZE = 20;
        public static final int MAX_EXT_UNIT_SIZE = Short.MAX_VALUE;
        private short size;
        private long tagsCode;
        private long msgStoreTime;
        private short bitMapSize;
        private byte[] filterBitMap;

        public CqExtUnit() {
        }

        public CqExtUnit(Long tagsCode, long msgStoreTime, byte[] filterBitMap) {
            this.tagsCode = tagsCode == null ? 0L : tagsCode;
            this.msgStoreTime = msgStoreTime;
            this.filterBitMap = filterBitMap;
            this.bitMapSize = (short)(filterBitMap == null ? 0 : filterBitMap.length);
            this.size = (short)(20 + this.bitMapSize);
        }

        private boolean read(ByteBuffer buffer) {
            if (buffer.position() + 2 > buffer.limit()) {
                return false;
            }
            this.size = buffer.getShort();
            if (this.size < 1) {
                return false;
            }
            this.tagsCode = buffer.getLong();
            this.msgStoreTime = buffer.getLong();
            this.bitMapSize = buffer.getShort();
            if (this.bitMapSize < 1) {
                return true;
            }
            if (this.filterBitMap == null || this.filterBitMap.length != this.bitMapSize) {
                this.filterBitMap = new byte[this.bitMapSize];
            }
            buffer.get(this.filterBitMap);
            return true;
        }

        private void readBySkip(ByteBuffer buffer) {
            short tempSize;
            ByteBuffer temp = buffer.slice();
            this.size = tempSize = temp.getShort();
            if (tempSize > 0) {
                buffer.position(buffer.position() + this.size);
            }
        }

        private byte[] write(ByteBuffer container) {
            this.bitMapSize = (short)(this.filterBitMap == null ? 0 : this.filterBitMap.length);
            this.size = (short)(20 + this.bitMapSize);
            ByteBuffer temp = container;
            if (temp == null || temp.capacity() < this.size) {
                temp = ByteBuffer.allocate(this.size);
            }
            temp.flip();
            temp.limit(this.size);
            temp.putShort(this.size);
            temp.putLong(this.tagsCode);
            temp.putLong(this.msgStoreTime);
            temp.putShort(this.bitMapSize);
            if (this.bitMapSize > 0) {
                temp.put(this.filterBitMap);
            }
            return temp.array();
        }

        private int calcUnitSize() {
            int sizeTemp = 20 + (this.filterBitMap == null ? 0 : this.filterBitMap.length);
            return sizeTemp;
        }

        public long getTagsCode() {
            return this.tagsCode;
        }

        public void setTagsCode(long tagsCode) {
            this.tagsCode = tagsCode;
        }

        public long getMsgStoreTime() {
            return this.msgStoreTime;
        }

        public void setMsgStoreTime(long msgStoreTime) {
            this.msgStoreTime = msgStoreTime;
        }

        public byte[] getFilterBitMap() {
            if (this.bitMapSize < 1) {
                return null;
            }
            return this.filterBitMap;
        }

        public void setFilterBitMap(byte[] filterBitMap) {
            this.filterBitMap = filterBitMap;
            this.bitMapSize = (short)(filterBitMap == null ? 0 : filterBitMap.length);
        }

        public short getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CqExtUnit)) {
                return false;
            }
            CqExtUnit cqExtUnit = (CqExtUnit)o;
            if (this.bitMapSize != cqExtUnit.bitMapSize) {
                return false;
            }
            if (this.msgStoreTime != cqExtUnit.msgStoreTime) {
                return false;
            }
            if (this.size != cqExtUnit.size) {
                return false;
            }
            if (this.tagsCode != cqExtUnit.tagsCode) {
                return false;
            }
            return Arrays.equals(this.filterBitMap, cqExtUnit.filterBitMap);
        }

        public int hashCode() {
            int result = this.size;
            result = 31 * result + (int)(this.tagsCode ^ this.tagsCode >>> 32);
            result = 31 * result + (int)(this.msgStoreTime ^ this.msgStoreTime >>> 32);
            result = 31 * result + this.bitMapSize;
            result = 31 * result + (this.filterBitMap != null ? Arrays.hashCode(this.filterBitMap) : 0);
            return result;
        }

        public String toString() {
            return "CqExtUnit{size=" + this.size + ", tagsCode=" + this.tagsCode + ", msgStoreTime=" + this.msgStoreTime + ", bitMapSize=" + this.bitMapSize + ", filterBitMap=" + Arrays.toString(this.filterBitMap) + '}';
        }
    }
}

